%define _use_internal_dependency_generator 0
%{!?perl_vendorlib: %define perl_vendorlib %(eval "`perl -V:installvendorlib`"; echo $installvendorlib)}

Summary: XML-SAX Perl module
Name: perl-XML-SAX
Version: 0.14
Release: 5
Epoch: 2
License: GPL or Artistic
Group: Development/Libraries
URL: http://search.cpan.org/dist/XML-SAX/
Source: ftp://cpan.org/pub/CPAN/authors/id/M/MS/MSERGEANT/XML-SAX-%{version}.tar.gz 
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: perl >= 2:5.8.0
Requires: %(perl -MConfig -le 'if (defined $Config{useithreads}) { print "perl(:WITH_ITHREADS)" } else { print "perl(:WITHOUT_ITHREADS)" }')
Requires: %(perl -MConfig -le 'if (defined $Config{usethreads}) { print "perl(:WITH_THREADS)" } else { print "perl(:WITHOUT_THREADS)" }')
Requires: %(perl -MConfig -le 'if (defined $Config{uselargefiles}) { print "perl(:WITH_LARGEFILES)" } else { print "perl(:WITHOUT_LARGEFILES)" }')
Requires: perl(:MODULE_COMPAT_%(perl -MConfig -e 'print $Config{version}'))
Source1: filter-requires-xmlsax.sh
BuildArch: noarch
BuildRequires: perl-XML-NamespaceSupport perl-XML-LibXML perl-XML-LibXML-Common

# Provide perl-specific find-{provides,requires}.
%define __find_provides /usr/lib/rpm/find-provides.perl
# %%define __find_requires /usr/lib/rpm/find-requires.perl
%define __find_requires %{SOURCE1}


%description
%{summary}.

%prep
%setup -q -n XML-SAX-%{version}

%build
echo N | CFLAGS="$RPM_OPT_FLAGS" perl Makefile.PL INSTALLDIRS=vendor
make OPTIMIZE="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
make install \
  PERL_INSTALL_ROOT=$RPM_BUILD_ROOT \
  INSTALLARCHLIB=$RPM_BUILD_ROOT%{perl_archlib}
find $RPM_BUILD_ROOT -type f -a \( -name perllocal.pod -o -name .packlist \
  -o \( -name '*.bs' -a -empty \) \) -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type d -depth -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*
touch $RPM_BUILD_ROOT%{perl_vendorlib}/XML/SAX/ParserDetails.ini

%check || :
make test

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc Changes LICENSE README
%dir %{perl_vendorlib}/XML
%{perl_vendorlib}/XML/SAX.pm
%dir %{perl_vendorlib}/XML/SAX
%{perl_vendorlib}/XML/SAX/*.pm
%{perl_vendorlib}/XML/SAX/*.pod
%{perl_vendorlib}/XML/SAX/PurePerl
%{_mandir}/man3/XML::*.3*
%ghost %{perl_vendorlib}/XML/SAX/ParserDetails.ini
%exclude %{perl_vendorlib}/XML/SAX/placeholder.pl

%changelog
* Mon Oct 29 2007 KONDO hideaki <kondo.hideaki@oss.ntt.co.jp>
- Created for ultramonkey3 on RHEL5

* Tue Jan 23 2007 Robin Norwood <rnorwood@redhat.com> - 0.14-5
- Resolves: #223057: try again to get the script ordering correct.

* Wed Jan 17 2007 Robin Norwood <rnorwood@redhat.com> - 0.14-4
- Resolves: #223057: incorrect use of 'return' instead of 'exit'.

* Tue Jan 09 2007 Robin Norwood <rnorwood@redhat.com> - 0.14-3
- Resolves: #210009: XML::LibXML::Common not found during upgrade

* Fri Jun 09 2006 Jason Vas Dias <jvdias@redhat.com> - 0.14-2
- fix bug 194706: fails to build under (new!) mock

* Mon Jun 05 2006 Jason Vas Dias <jvdias@redhat.com> - 0.14-1
- upgrade to 0.14

* Fri Feb 03 2006 Jason Vas Dias <jvdias@redhat.com> - 0.13-1.1
- rebuild for new perl-5.8.8

* Mon Dec 19 2005 Jason Vas Dias <jvdias@redhat.com> - 0.13-1
- upgrade to 0.13

* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt for new gcc

* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt for new gcj

* Sun Apr 18 2004 Ville Skyttä <ville.skytta at iki.fi> - 0.12-7
- #121167
- Handle ParserDetails.ini parser registration.
- Require perl(:MODULE_COMPAT_*).
- Own installed directories.

* Wed Oct 22 2003 Chip Turner <cturner@redhat.com> - 0.12-1
- Specfile autogenerated.

