Summary: A library of handy utility functions.
Name: glib
Version: 1.2.10
Release: 20%{?dist}
Epoch: 1
License: LGPL
Group: System Environment/Libraries
Source: ftp://ftp.gimp.org/pub/gtk/v1.2/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
URL: http://www.gtk.org

# Suppress warnings about varargs macros for -pedantic
Patch1: glib-1.2.10-isowarning.patch
Patch2: glib-1.2.10-gcc34.patch
Patch3: glib-1.2.10-underquoted.patch
Patch4: glib-1.2.10-multilib.patch

%description
GLib is a handy library of utility functions. This C library is
designed to solve some portability problems and provide other useful
functionality which most programs require.

GLib is used by GDK, GTK+ and many applications.  You should install
th glib package because many of your applications will depend on this
library.

%package devel
Summary: The GIMP ToolKit (GTK+) and GIMP Drawing Kit (GDK) support library.
Group: Development/Libraries
Requires: glib = %{epoch}:%{version}

%description devel
The glib-devel package includes the static libraries and header files
for the support library for the GIMP's X libraries (GTK+ and GDK),
which are available as public libraries.

Install glib-devel if you want to develop programs which will use
GLib.


%prep
%setup -q 

%patch1 -p1 -b .isowarning
%patch2 -p1 -b .gcc34
%patch3 -p1 -b .underquoted
%patch4 -p1 -b .multilib

%build
%configure
make

%install
rm -rf $RPM_BUILD_ROOT

%makeinstall

rm -rf $RPM_BUILD_ROOT%{_infodir}
rm -rf $RPM_BUILD_ROOT%{_libdir}/*a
chmod a+x $RPM_BUILD_ROOT%{_libdir}/*.so

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{_libdir}/libglib-1.2.so.*
%{_libdir}/libgthread-1.2.so.*
%{_libdir}/libgmodule-1.2.so.*

%files devel
%defattr(-, root, root)

%{_libdir}/lib*.so
%{_libdir}/glib
%{_libdir}/pkgconfig/*
%{_includedir}/*
%{_mandir}/man1/*
%{_datadir}/aclocal/*
%{_bindir}/*

%changelog
* Thu Jan 11 2007 Matthias Clasen <mclasen@redhat.com> - 1:1.2.10-20
- Fix multilib conflict (#22161)

* Thu Oct 12 2006 Matthias Clasen <mclasen@redhat.com> - 1:1.2.10-19
- Rebuild

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1:1.2.10-18.2.2
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 1:1.2.10-18.2.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Tue Jan  3 2006 Jesse Keating <jkeating@redhat.com> 1:1.2.10-18.2
- rebuilt again

* Fri Dec 09 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt

* Mon Nov 21 2005 Matthias Clasen <mclasen@redhat.com> 1:1.2.10-18
- Make sure all libraries are stripped

* Mon Nov  7 2005 Matthias Clasen <mclasen@redhat.com> 1:1.2.10-17
- Remove .la files and static libs from the -devel package.

* Wed Mar  2 2005 Matthias Clasen <mclasen@redhat.com> 1:1.2.10-16
- Rebuild with gcc4

* Mon Aug  9 2004 Tim Waugh <twaugh@redhat.com> 1:1.2.10-15
- Fixed underquoted m4 definitions.

* Mon Jun 20 2004 Matthias Clasen <mclasen@redhat.com> 1:1.2.10-14
- Make it build with gcc 3.4

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Sun Jun  8 2003 Tim Powers <timp@redhat.com> 1:1.2.10-11.1
- build for RHEL

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Jun  3 2003 Jeff Johnson <jbj@redhat.com>
- add explicit epoch's where needed.

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Fri Nov 29 2002 Tim Powers <timp@redhat.com> 1:1.2.10-9
- remove unpackaged files from the buildroot

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Sat Jul 21 2001 Owen Taylor <otaylor@redhat.com>
- Add #pragma GCC system_header to supress warnings when in -pedantic
  mode. (41271)

* Tue Jul 10 2001 Trond Eivind Glomsrd <teg@redhat.com>
- s/Copyright/License/
- Make the devel subpackage depend on the main package

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Sun Apr 22 2001  <jrb@redhat.com>
- Include pc files.

* Tue Apr 17 2001 Jonathan Blandford <jrb@redhat.com>
- Version 1.2.10

* Mon Mar 05 2001 Owen Taylor <otaylor@redhat.com>
- Version 1.2.9

* Wed Feb 28 2001 Owen Taylor <otaylor@redhat.com>
- Version 1.2.9pre3

* Tue Feb 27 2001 Owen Taylor <otaylor@redhat.com>
- Version 1.2.9pre2

* Tue Feb 13 2001 Owen Taylor <otaylor@redhat.com>
- Version 1.2.9pre1

* Sat Oct 28 2000 Owen Taylor <otaylor@redhat.com>
- Add patch to suppress warnings from GCC by using
  C99 standard varargs macros

* Fri Aug 11 2000 Jonathan Blandford <jrb@redhat.com>
- Up Epoch and release

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jun 19 2000 Preston Brown <pbrown@redhat.com>
- FHS paths

* Thu May 25 2000 Owen Taylor <otaylor@redhat.com>
- Version 1.2.8

* Mon May  1 2000 Matt Wilson <msw@redhat.com>
- version 1.2.7

* Fri Feb 04 2000 Owen Taylor <otaylor@redhat.com>
- Added fixes from stable branch of CVS

* Thu Oct 7  1999 Owen Taylor <otaylor@redhat.com>
- version 1.2.6

* Fri Sep 24 1999 Owen Taylor <otaylor@redhat.com>
- version 1.2.5

* Fri Sep 17 1999 Owen Taylor <otaylor@redhat.com>
- version 1.2.4

* Mon Jun 7 1999 Owen Taylor <otaylor@redhat.com>
- version 1.2.3

* Thu Mar 25 1999 Michael Fulbright <drmike@redhat.com>
- version 1.2.1

* Fri Feb 26 1999 Michael Fulbright <drmike@redhat.com>
- Version 1.2

* Thu Feb 25 1999 Michael Fulbright <drmike@redhat.com>
- version 1.2.0pre1

* Tue Feb 23 1999 Cristian Gafton <gafton@redhat.com>
- new description tags 

* Sun Feb 21 1999 Michael Fulbright <drmike@redhat.com>
- removed libtoolize from %build

* Thu Feb 11 1999 Michael Fulbright <drmike@redhat.com>
- added libgthread to file list

* Fri Feb 05 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.15

* Wed Feb 03 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.14

* Mon Jan 18 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.13

* Wed Jan 06 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.12

* Wed Dec 16 1998 Michael Fulbright <drmike@redhat.com>
- updated in preparation for the GNOME freeze

* Mon Apr 13 1998 Marc Ewing <marc@redhat.com>
- Split out glib package
