/*
 * @file  parameter_impl.h
 * @brief parameter module implementation class.
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2008  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *      
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef __PARAMETER_IMPL_H__
#define __PARAMETER_IMPL_H__

#include "parameter_enum.h"
#include <iostream>
#include <string>
#include <map>


namespace l7vs
{
	struct	component{
		std::string	section;
		void		(*function)();
		component(){ section = ""; function = NULL;}
		component( std::string str, void (*p_func)() ){ section = str; function = p_func;}
		component& operator=(const component& in_comp){
			section = in_comp.section;
			function = in_comp.function;
			return *this;
		}
	};
	class ParameterImpl
	{
	private:
		std::string	removebrank( const std::string& );
		bool	readParameterFile( const std::string& );
		bool	isNumeric( const std::string& );

		std::multimap<std::string,std::string>	preparse;

		std::map<PARAMETER_COMPONENT_TAG, component>	compTable;
		std::multimap<std::string, std::string>	stringMap;
		std::multimap<std::string, int>		intMap;

	protected:
		ParameterImpl();
		ParameterImpl( const ParameterImpl& );
		ParameterImpl& operator=( const ParameterImpl& );

	public:
		static ParameterImpl & getInstance(){
			static ParameterImpl instance;
			return instance;
		}
		bool	init();
		bool	rereadFile( const PARAMETER_COMPONENT_TAG, const std::string& );
	
		bool	isIntExist( const PARAMETER_COMPONENT_TAG, const std::string& );
		bool	isStringExist( const PARAMETER_COMPONENT_TAG, const std::string& );
		int	getIntValue( const PARAMETER_COMPONENT_TAG, const std::string& );
		std::string	getStringValue( const PARAMETER_COMPONENT_TAG, const std::string& );
		void	getStringMapValue( const PARAMETER_COMPONENT_TAG, const std::string&, std::multimap<std::string, std::string>&);

		void	registerFunctionPointer( const PARAMETER_COMPONENT_TAG, void (*)() );
	};
}
#endif	//__PARAMETER_IMPL_H__
