/*
 * @file  http_response.h
 * @brief HTTP Response Message Header
 *
 * Copyright (C) 2009  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef __HTTP_RESPONSE_H__
#define __HTTP_RESPONSE_H__

#include <string>
#include "http_message.h"
#include "http_response_enum.h"
#include "logger_wrapper.h"

//! HTTP Response Class (RFC2616)
class http_response : public http_message
{
private:
    std::string         _http_version;
    std::string         _status_code;
    std::string         _reason_phrase;

public:
    http_response();
    http_response( std::string );
    ~http_response();

    std::string http_version() const;
    std::string http_version( std::string );
    std::string status_code() const;
    std::string status_code( std::string );
    std::string reason_phrase() const;
    std::string reason_phrase( std::string );
    std::string status_line() const;
    std::string as_string();
    void parse( std::string );
    void rebuild();
};

#endif //__HTTP_RESPONSE_H__
