/*!
 * @file  snmpfunc.cpp
 * @brief snmp function module.
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2010  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.create-dataset.conf 17337 2009-01-01 14:28:29Z magfr $
 *        : mib2c.scalar.conf 17337 2009-01-01 14:28:29Z magfr $
 *        : mib2c.notify.conf 17455 2009-04-05 09:53:29Z magfr $
 */
#include "mibdata.h"
#include "snmpagent_impl.h"
#include "snmpfunc.h"

static const oid snmptrap_oid[] = { 1, 3, 6, 1, 6, 3, 1, 1, 4, 1, 0 };
netsnmp_table_data_set *vs_table;
netsnmp_table_data_set *rs_table;
netsnmp_handler_registration *vs_table_size_handler = NULL;
netsnmp_handler_registration *vs_table_handler = NULL;
netsnmp_handler_registration *rs_table_handler = NULL;
netsnmp_handler_registration *replication_handler = NULL;

/*!
 * register snmp scaler and table data set handler.
 *
 * @param[in]      error_code& is trap error code
 * @retrun         void
 */
void
init_snmp_handles(error_code& err)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 76, "snmpfunc::init_snmp_handles", __FILE__, __LINE__);

        oid       l7vsVsNumber_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 1, 1, 1 };
        oid       l7vsReplicationMode_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 1, 1, 4 };
        oid       l7vsVsTable_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 1, 1, 2 };
        oid       l7vsRsTable_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 1, 1, 3 };

        DEBUGMSGTL(("ultramonkey_l7", "init_snmp_handles\n"));

        vs_table_size_handler = netsnmp_create_handler_registration
                                ("l7vsVsNumber", handle_get_vstable_count,
                                 l7vsVsNumber_oid,
                                 OID_LENGTH(l7vsVsNumber_oid),
                                 HANDLER_CAN_RONLY);

        int ret = netsnmp_register_scalar(vs_table_size_handler);

        if ( ret ) {
                std::string msg("netsnmp_register_scalar failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 68, msg, __FILE__, __LINE__);
                //set error code
                err.setter(true, msg);
                return;
        }

        replication_handler = netsnmp_create_handler_registration
                              ("l7vsReplicationMode",
                               handle_get_rep_state,
                               l7vsReplicationMode_oid,
                               OID_LENGTH(l7vsReplicationMode_oid),
                               HANDLER_CAN_RONLY);

        ret = netsnmp_register_scalar(replication_handler);

        if (ret) {
                std::string msg("netsnmp_register_scalar failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 69, msg, __FILE__, __LINE__);
                //set error code
                err.setter(true, msg);
                return;
        }


        /*
         * registering the table with the master agent
         */
        /*
         * note: if you don't need a subhandler to deal with any aspects
         * of the request, change handle_get_vstable to "NULL"
         */
        if (vs_table) {
                vs_table_handler = netsnmp_create_handler_registration
                                   ("l7vsVsTable", handle_get_vstable,
                                    l7vsVsTable_oid,
                                    OID_LENGTH(l7vsVsTable_oid),
                                    HANDLER_CAN_RWRITE);
                int ret = netsnmp_register_table_data_set(vs_table_handler, vs_table, NULL);

                if (ret) {
                        std::string msg("netsnmp create l7vsVsTable data set failed.");
                        Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 24, msg, __FILE__, __LINE__);
                        //set error code
                        err.setter(true, msg);
                        return;
                }
        }

        /*
         * registering the table with the master agent
         */
        /*
         * note: if you don't need a subhandler to deal with any aspects
         * of the request, change handle_get_rstable to "NULL"
         */
        if (rs_table) {
                rs_table_handler = netsnmp_create_handler_registration
                                   ("l7vsRsTable", handle_get_rstable,
                                    l7vsRsTable_oid,
                                    OID_LENGTH(l7vsRsTable_oid),
                                    HANDLER_CAN_RWRITE);
                int ret = netsnmp_register_table_data_set(rs_table_handler, rs_table, NULL);

                if (ret) {
                        std::string msg("netsnmp create l7vsRsTable data set failed.");
                        Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 26, msg, __FILE__, __LINE__);
                        //set error code
                        err.setter(true, msg);
                        return;
                }
        }
}

/*!
 * handle for virtual service count.
 *
 */
int
handle_get_vstable_count(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *reqinfo,
                         netsnmp_request_info *requests)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 77, "snmpfunc::handle_get_vstable_count", __FILE__, __LINE__);
        /*
         * We are never called for a GETNEXT if it's registered as a
         * "instance", as it's "magically" handled for us.
         */

        /*
         * a instance handler also only hands us one request at a time, so
         * we don't need to loop over a list of requests; we'll only get one.
         */

        switch (reqinfo->mode) {

        case MODE_GET: {
                //get virtual serveice size
                int table_size = l7vs::mibdata::get_instance().get_vs_table_size();

                //set value
                int ret = snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                                   (u_char *)&table_size,
                                                   sizeof(int));

                if (ret) {
                        std::string msg("snmp_set_var_typed_value failed.");
                        Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 20, msg, __FILE__, __LINE__);

                        return SNMP_ERR_GENERR;
                }

                //increment getrequest count
                snmpagent_impl::get_instance().increment_getrequest_count();

                //update last request date
                snmpagent_impl::get_instance().update_last_request_date();
        }
        break;
        default:
                /*
                 * we should never get here, so this is a really bad error
                 */
                snmp_log(LOG_ERR, "unknown mode (%d) in handle_get_vstable_count\n",
                         reqinfo->mode);
                return SNMP_ERR_GENERR;
        }

        return SNMP_ERR_NOERROR;
}

/*!
 * handle for replication state.
 *
 */
int
handle_get_rep_state(netsnmp_mib_handler *handler,
                     netsnmp_handler_registration *reginfo,
                     netsnmp_agent_request_info *reqinfo,
                     netsnmp_request_info *requests)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 78, "snmpfunc::handle_get_rep_state", __FILE__, __LINE__);

        /*
         * We are never called for a GETNEXT if it's registered as a
         * "instance", as it's "magically" handled for us.
         */

        /*
         * a instance handler also only hands us one request at a time, so
         * we don't need to loop over a list of requests; we'll only get one.
         */

        switch (reqinfo->mode) {

        case MODE_GET: {
                //get replication state
                int rep_state = l7vs::mibdata::get_instance().get_replication_state();


                //set value
                int ret = snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                                   (u_char *)&rep_state,
                                                   sizeof(int));

                if (ret) {
                        std::string msg("snmp_set_var_typed_value failed.");
                        Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 22, msg, __FILE__, __LINE__);

                        return SNMP_ERR_GENERR;
                }

                //increment getrequest count
                snmpagent_impl::get_instance().increment_getrequest_count();

                //update last request date
                snmpagent_impl::get_instance().update_last_request_date();
        }
        break;
        default:
                /*
                 * we should never get here, so this is a really bad error
                 */
                snmp_log(LOG_ERR,
                         "unknown mode (%d) in handle_get_rep_state\n",
                         reqinfo->mode);
                return SNMP_ERR_GENERR;
        }

        return SNMP_ERR_NOERROR;
}

/*!
 * initialize virtual service table data set.
 *
 * @param[in]      error_code& is trap error code
 * @retrun         void
 */
void
initialize_virtual_service_table(error_code &err)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 79, "snmpfunc::initialize_virtual_service_table", __FILE__, __LINE__);

        /*
         * create the table structure itself
         */
        vs_table = netsnmp_create_table_data_set("l7vsVsTable");

        if (!vs_table) {
                std::string msg("netsnmp create l7vsVsTable data set failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 23, msg, __FILE__, __LINE__);
                //set error code
                err.setter(true, msg);
                return;
        }

        //set data set into mibdata
        mibdata::get_instance().set_vs_table(vs_table);

        /*
         * comment this out or delete if you don't support creation of new rows
         */
        vs_table->allow_creation = 1;

        /***************************************************
         * Adding indexes
         */
        DEBUGMSGTL(("initialize_virtual_service_table",
                    "adding indexes to table l7vsVsTable\n"));
        netsnmp_table_set_add_indexes(vs_table, ASN_INTEGER,       /* index: l7vsVsIndex */
                                      0);

        DEBUGMSGTL(("initialize_virtual_service_table",
                    "adding column types to table l7vsVsTable\n"));
        netsnmp_table_set_multi_add_default_row(vs_table,
                                                COLUMN_L7VSVSINDEX,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSPROTOCOL,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSADDRTYPE,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSADDR,
                                                ASN_OCTET_STR, 0, NULL, 0,
                                                COLUMN_L7VSVSPORT,
                                                ASN_UNSIGNED, 0, NULL, 0,
                                                COLUMN_L7VSVSPROTOCOLMODULENAME,
                                                ASN_OCTET_STR, 0, NULL, 0,
                                                COLUMN_L7VSVSPROTOCOLMODULEOPTIONS,
                                                ASN_OCTET_STR, 0, NULL, 0,
                                                COLUMN_L7VSVSSCHEDULEMODULENAME,
                                                ASN_OCTET_STR, 0, NULL, 0,
                                                COLUMN_L7VSVSSCHEDULEMODULEOPTIONS,
                                                ASN_OCTET_STR, 0, NULL, 0,
                                                COLUMN_L7VSVSSORRYADDRTYPE,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSSORRYADDR,
                                                ASN_OCTET_STR, 0, NULL, 0,
                                                COLUMN_L7VSVSSORRYPORT,
                                                ASN_UNSIGNED, 0, NULL, 0,
                                                COLUMN_L7VSVSSORRYCONNLIMIT,
                                                ASN_COUNTER64, 0, NULL, 0,
                                                COLUMN_L7VSVSSORRYFORCEENABLED,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSTHROUGHPUTUP,
                                                ASN_COUNTER64, 0, NULL, 0,
                                                COLUMN_L7VSVSTHROUGHPUTDOWN,
                                                ASN_COUNTER64, 0, NULL, 0,
                                                COLUMN_L7VSVSTHROUGHPUTUPQOS,
                                                ASN_COUNTER64, 0, NULL, 0,
                                                COLUMN_L7VSVSTHROUGHPUTDOWNQOS,
                                                ASN_COUNTER64, 0, NULL, 0,
                                                COLUMN_L7VSVSSSLFLAG,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSSESSIONPOOLCOUNT,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSSESSIONACTIVECOUNT,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSSESSIONWAITCOUNT,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSVSHTTPTOTALCOUNT,
                                                ASN_COUNTER64, 0, NULL, 0,
                                                COLUMN_L7VSVSHTTPGETCOUNT,
                                                ASN_COUNTER64, 0, NULL, 0,
                                                COLUMN_L7VSVSHTTPPOSTCOUNT,
                                                ASN_COUNTER64, 0, NULL, 0,
                                                COLUMN_L7VSVSRSNUMBER,
                                                ASN_INTEGER, 0, NULL, 0, 0);

}

/*!
 * initialize real server table data set.
 *
 * @param[in]      error_code& is trap error code
 * @retrun         void
 */
void
initialize_real_server_table(error_code &err)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 80, "snmpfunc::initialize_real_server_table", __FILE__, __LINE__);

        /*
         * create the table structure itself
         */
        rs_table = netsnmp_create_table_data_set("l7vsRsTable");

        if (!rs_table) {
                std::string msg("netsnmp create l7vsRsTable data set failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 25, msg, __FILE__, __LINE__);
                //set error code
                err.setter(true, msg);
                return;
        }

        //set data set into mibdata
        mibdata::get_instance().set_rs_table(rs_table);
        /*
         * comment this out or delete if you don't support creation of new rows
         */
        rs_table->allow_creation = 1;

        /***************************************************
         * Adding indexes
         */
        DEBUGMSGTL(("initialize_real_server_table",
                    "adding indexes to table l7vsRsTable\n"));
        netsnmp_table_set_add_indexes(rs_table, ASN_INTEGER,       /* index: l7vsRsIndex */
                                      0);

        DEBUGMSGTL(("initialize_real_server_table",
                    "adding column types to table l7vsRsTable\n"));
        netsnmp_table_set_multi_add_default_row(rs_table,
                                                COLUMN_L7VSRSINDEX,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSRSVSINDEX,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSRSADDRTYPE,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSRSADDR,
                                                ASN_OCTET_STR, 0, NULL, 0,
                                                COLUMN_L7VSRSPORT,
                                                ASN_UNSIGNED, 0, NULL, 0,
                                                COLUMN_L7VSRSFORWARD,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSRSWEIGHT,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSRSACTIVECONN,
                                                ASN_INTEGER, 0, NULL, 0,
                                                COLUMN_L7VSRSINACTIVECONN,
                                                ASN_INTEGER, 0, NULL, 0, 0);
}

/*!
 * unregister snmp handler.
 *
 */
void unregister_handler()
{
        // unregister snmp handler
        if (rs_table_handler && vs_table_handler && vs_table_size_handler && replication_handler) {
                //fix memory leak for function netsnmp_register_table_data_set() start
                //get table registration information
                netsnmp_table_registration_info *rs_table_registration_info = netsnmp_find_table_registration_info(rs_table_handler);
                netsnmp_table_registration_info *vs_table_registration_info = netsnmp_find_table_registration_info(vs_table_handler);

                if (rs_table_registration_info) {
                        SNMP_FREE(rs_table_registration_info->indexes);
                        SNMP_FREE(rs_table_registration_info->valid_columns);
                        SNMP_FREE(rs_table_registration_info);
                }
                if (vs_table_registration_info) {
                        SNMP_FREE(vs_table_registration_info->indexes);
                        SNMP_FREE(vs_table_registration_info->valid_columns);
                        SNMP_FREE(vs_table_registration_info);
                }
                //fix memory leak for function netsnmp_register_table_data_set() end

                netsnmp_unregister_handler(rs_table_handler);
                netsnmp_unregister_handler(vs_table_handler);
                netsnmp_unregister_handler(vs_table_size_handler);
                netsnmp_unregister_handler(replication_handler);
        }
}

/*!
 * handle for virtual service table.
 *
 */
int
handle_get_vstable(netsnmp_mib_handler *handler,
                   netsnmp_handler_registration *reginfo,
                   netsnmp_agent_request_info *reqinfo,
                   netsnmp_request_info *requests)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 81, "snmpfunc::handle_get_vstable", __FILE__, __LINE__);

        /*
         * perform anything here that you need to do.  The requests have
         * already been processed by the master table_dataset handler, but
         * this gives you chance to act on the request in some other way
         * if need be.
         */
        switch (reqinfo->mode) {
        case MODE_GET: {
                //increment getrequest count
                snmpagent_impl::get_instance().increment_getrequest_count();

                //update last request date
                snmpagent_impl::get_instance().update_last_request_date();
        }
        break;
        case MODE_GETNEXT:
                break;
        default:
                /*
                 * we should never get here, so this is a really bad error
                 */
                snmp_log(LOG_ERR,
                         "unknown mode (%d) in handle_get_vstable\n",
                         reqinfo->mode);
                return SNMP_ERR_GENERR;
        }

        return SNMP_ERR_NOERROR;
}

/*!
 * handle for real server table.
 *
 */
int
handle_get_rstable(netsnmp_mib_handler *handler,
                   netsnmp_handler_registration *reginfo,
                   netsnmp_agent_request_info *reqinfo,
                   netsnmp_request_info *requests)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 82, "snmpfunc::handle_get_rstable", __FILE__, __LINE__);

        /*
         * perform anything here that you need to do.  The requests have
         * already been processed by the master table_dataset handler, but
         * this gives you chance to act on the request in some other way
         * if need be.
         */
        switch (reqinfo->mode) {

        case MODE_GET: {
                //increment getrequest count
                snmpagent_impl::get_instance().increment_getrequest_count();

                //update last request date
                snmpagent_impl::get_instance().update_last_request_date();
        }
        break;
        case MODE_GETNEXT:
                break;
        default:
                /*
                 * we should never get here, so this is a really bad error
                 */
                snmp_log(LOG_ERR,
                         "unknown mode (%d) in handle_get_rstable\n",
                         reqinfo->mode);
                return SNMP_ERR_GENERR;
        }

        return SNMP_ERR_NOERROR;
}

/*!
 * send service start trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_service_start(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 83, "snmpfunc::trap_service_start", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_service_start arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 84, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsServiceStart_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 1, 1 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid,
                                             OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsServiceStart_oid,
                                             sizeof(l7vsServiceStart_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 29, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsServiceStart_oid,
                                             OID_LENGTH(l7vsServiceStart_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 30, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send service stop trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_service_stop(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 85, "snmpfunc::trap_service_stop", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_service_stop arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 86, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsServiceStop_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 1, 2 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid,
                                             OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsServiceStop_oid,
                                             sizeof(l7vsServiceStop_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 31, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsServiceStop_oid,
                                             OID_LENGTH(l7vsServiceStop_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 32, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send virtual service add trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_vs_add(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 87, "snmpfunc::trap_vs_add", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_vs_add arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 88, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingVsAdd_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 1 };


        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingVsAdd_oid,
                                             sizeof(l7vsBalancingVsAdd_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 33, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingVsAdd_oid,
                                             OID_LENGTH(l7vsBalancingVsAdd_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 34, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send virtual service change trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_vs_change(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 89, "snmpfunc::trap_vs_change", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_vs_change arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 90, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingVsChange_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 2 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingVsChange_oid,
                                             sizeof(l7vsBalancingVsChange_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 35, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingVsChange_oid,
                                             OID_LENGTH(l7vsBalancingVsChange_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 36, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send virtual service remove trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_vs_remove(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 91, "snmpfunc::trap_vs_remove", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_vs_remove arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 92, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingVsRemove_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 3 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingVsRemove_oid,
                                             sizeof(l7vsBalancingVsRemove_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 37, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingVsRemove_oid,
                                             OID_LENGTH(l7vsBalancingVsRemove_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 38, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send real server add trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_rs_add(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 93, "snmpfunc::trap_rs_add", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_rs_add arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 94, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingRsAdd_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 4 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingRsAdd_oid,
                                             sizeof(l7vsBalancingRsAdd_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 39, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingRsAdd_oid,
                                             OID_LENGTH(l7vsBalancingRsAdd_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 40, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send real server change trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_rs_change(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 95, "snmpfunc::trap_rs_change", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_rs_change arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 96, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingRsChange_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 5 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingRsChange_oid,
                                             sizeof(l7vsBalancingRsChange_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 41, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingRsChange_oid,
                                             OID_LENGTH(l7vsBalancingRsChange_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 42, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send real server remove trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_rs_remove(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 97, "snmpfunc::trap_rs_remove", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_rs_remove arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 98, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingRsRemove_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 6 };
        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingRsRemove_oid,
                                             sizeof(l7vsBalancingRsRemove_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 43, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingRsRemove_oid,
                                             OID_LENGTH(l7vsBalancingRsRemove_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 44, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send upstream QoS alert on trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_up_qos_alert_on(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 99, "snmpfunc::trap_up_qos_alert_on", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_up_qos_alert_on arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 100, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingUpQoSAlertOn_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 7 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingUpQoSAlertOn_oid,
                                             sizeof(l7vsBalancingUpQoSAlertOn_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 45, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingUpQoSAlertOn_oid,
                                             OID_LENGTH(l7vsBalancingUpQoSAlertOn_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 46, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send upstream QoS alert off trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_up_qos_alert_off(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 101, "snmpfunc::trap_up_qos_alert_off", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_up_qos_alert_off arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 102, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingUpQoSAlertOff_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 8 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingUpQoSAlertOff_oid,
                                             sizeof(l7vsBalancingUpQoSAlertOff_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 47, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingUpQoSAlertOff_oid,
                                             OID_LENGTH(l7vsBalancingUpQoSAlertOff_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 48, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send downstream QoS alert on trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_down_qos_alert_on(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 103, "snmpfunc::trap_down_qos_alert_on", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_down_qos_alert_on arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 104, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingDownQoSAlertOn_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 9 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingDownQoSAlertOn_oid,
                                             sizeof(l7vsBalancingDownQoSAlertOn_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 49, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingDownQoSAlertOn_oid,
                                             OID_LENGTH(l7vsBalancingDownQoSAlertOn_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 50, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send downstream QoS alert off trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_down_qos_alert_off(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 105, "snmpfunc::trap_down_qos_alert_off", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_down_qos_alert_off arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 106, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingDownQoSAlertOff_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 10 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingDownQoSAlertOff_oid,
                                             sizeof(l7vsBalancingDownQoSAlertOff_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 51, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingDownQoSAlertOff_oid,
                                             OID_LENGTH(l7vsBalancingDownQoSAlertOff_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 52, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send session pool alert on trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_sessionpool_alert_on(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 107, "snmpfunc::trap_sessionpool_alert_on", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_sessionpool_alert_on arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 108, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingSessionPoolAlertOn_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 11 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingSessionPoolAlertOn_oid,
                                             sizeof(l7vsBalancingSessionPoolAlertOn_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 53, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingSessionPoolAlertOn_oid,
                                             OID_LENGTH(l7vsBalancingSessionPoolAlertOn_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 54, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send session pool alert off trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_sessionpool_alert_off(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 109, "snmpfunc::trap_sessionpool_alert_off", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_sessionpool_alert_off arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 110, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsBalancingSessionPoolAlertOff_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 2, 12 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsBalancingSessionPoolAlertOff_oid,
                                             sizeof
                                             (l7vsBalancingSessionPoolAlertOff_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 55, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsBalancingSessionPoolAlertOff_oid,
                                             OID_LENGTH(l7vsBalancingSessionPoolAlertOff_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 56, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send fatal log trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_fatal(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 111, "snmpfunc::trap_fatal", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_fatal arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 112, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsLogFatal_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 3, 1 };
        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsLogFatal_oid, sizeof(l7vsLogFatal_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 57, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsLogFatal_oid,
                                             OID_LENGTH(l7vsLogFatal_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 58, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send error log trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_error(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 113, "snmpfunc::trap_error", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_error arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 114, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsLogError_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 3, 2 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsLogError_oid, sizeof(l7vsLogError_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 59, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsLogError_oid,
                                             OID_LENGTH(l7vsLogError_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 60, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send warn log trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_warn(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 115, "snmpfunc::trap_warn", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_warn arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 116, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsLogWarn_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 3, 3 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsLogWarn_oid, sizeof(l7vsLogWarn_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 61, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsLogWarn_oid,
                                             OID_LENGTH(l7vsLogWarn_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 62, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send info log trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_info(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 117, "snmpfunc::trap_info", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_info arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 118, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsLogInfo_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 3, 4 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsLogInfo_oid, sizeof(l7vsLogInfo_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 63, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsLogInfo_oid,
                                             OID_LENGTH(l7vsLogInfo_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 64, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}

/*!
 * send debug log trap.
 *
 * @param[in]      std::string is trap message
 * @retrun         int  success:SNMP_ERR_NOERROR  failed:SNMP_ERR_GENERR
 */
int
trap_debug(const std::string &in_trapmessage)
{
        Logger    logger(LOG_CAT_L7VSD_SNMPAGENT, 119, "snmpfunc::trap_debug", __FILE__, __LINE__);

        /*-------- DEBUG LOG --------*/
        if (LOG_LV_DEBUG == Logger::getLogLevel(LOG_CAT_L7VSD_SNMPAGENT)) {
                std::stringstream    debugstr;
                debugstr << "snmpfunc::trap_debug arguments:";
                debugstr << boost::format("in_trapmessage=%s") % in_trapmessage;
                Logger::putLogDebug(LOG_CAT_L7VSD_SNMPAGENT, 120, debugstr.str(), __FILE__, __LINE__);
        }
        /*------ DEBUG LOG END ------*/

        netsnmp_variable_list *var_list = NULL;
        netsnmp_variable_list *ret_list = NULL;
        oid       l7vsLogDebug_oid[] = { 1, 3, 6, 1, 4, 1, 32132, 1, 0, 3, 5 };

        /*
         * Set the snmpTrapOid.0 value
         */
        ret_list = snmp_varlist_add_variable(&var_list,
                                             snmptrap_oid, OID_LENGTH(snmptrap_oid),
                                             ASN_OBJECT_ID,
                                             (u_char*)l7vsLogDebug_oid, sizeof(l7vsLogDebug_oid));
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 65, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }

        ret_list = snmp_varlist_add_variable(&var_list,
                                             l7vsLogDebug_oid,
                                             OID_LENGTH(l7vsLogDebug_oid),
                                             ASN_OCTET_STR,
                                             (u_char*)in_trapmessage.c_str(),
                                             in_trapmessage.length());
        if (!ret_list) {
                std::string msg("snmp_varlist_add_variable failed.");
                Logger::putLogError(LOG_CAT_L7VSD_SNMPAGENT, 66, msg, __FILE__, __LINE__);
                return SNMP_ERR_GENERR;
        }
        /*
         * Add any extra (optional) objects here
         */

        /*
         * Send the trap to the list of configured destinations
         *  and clean up
         */
        send_v2trap(var_list);
        snmp_free_varbind(var_list);

        return SNMP_ERR_NOERROR;
}
