#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: ultrapossum.rb,v 1.2 2004/04/02 02:34:28 taru Exp $

module UltraPossum

  class Config < Hash

    MODULES = [] 
    open("|ultrapossum-config module") do |io|
      io.each_line do |line|
        MODULES << line.chop!
      end
    end

    def Config.variables (mod)
      variables = []
      open("|ultrapossum-config variable #{mod}") do |io|
        io.each_line do |line|
	  variables << line.chop!
	end
      end
      variables
    end
    VARIABLES = {}
    MODULES.each do |m|
      VARIABLES[m] = variables(m)
    end

    def initialize
      open("|ultrapossum-config get") do |io|
        io.each_line do |line|
          /([^=]+)=\"(.*)\"/ =~ line
	  self[$1] = $2
	end
      end
    end

  end

end

if __FILE__ == $0
  UltraPossum::Config::MODULES.each do |m|
    puts m
    UltraPossum::Config::VARIABLES[m].each do |v|
      puts "\t#{v}"
    end
  end
  conf = UltraPossum::Config.new
  conf.each_key do |key|
    puts "#{key} -> #{conf[key]}"
  end
end

