/*
 * usecase_draw.c
 */
#include <gtk/gtk.h>

#include "def_tenko.h"

#include "usecase.h"
#include "usecase_draw.h"

extern GdkPixmap *g_usecase_pixmap;

extern GdkGC *black_gc;
extern GdkGC *white_gc;
extern GdkGC *select_gc;
extern GdkGC *erase_gc;

extern GdkFont *g_font;

extern int usecase_node_count;
extern int usecase_arc_count;
extern int usecase_system_count;

extern UsecaseNodeStruct usecaseNodeDat[USECASE_MAX_NODE];
extern UsecaseArcStruct usecaseArcDat[USECASE_MAX_ARC];
extern UsecaseSystemStruct usecaseSystemDat[USECASE_MAX_SYSTEM];

/*
 * usecase_draw_canvas_init
 */
void usecase_draw_canvas_init()
{
  gdk_draw_rectangle(g_usecase_pixmap, white_gc, TRUE,
		     0, 0, USECASE_PICTURE_WIDTH, USECASE_PICTURE_HEIGHT);
}

/*
 * usecase_draw_refresh_all
 */
void usecase_draw_refresh_all()
{
  int i;

  for(i=0; i<usecase_arc_count; i++){
    if(usecaseArcDat[i].select_mode == FALSE)
      usecase_draw_arc(g_usecase_pixmap, black_gc, &usecaseArcDat[i]);
  }
  for(i=0; i<usecase_node_count; i++){
    usecase_draw_white_node(g_usecase_pixmap, &usecaseNodeDat[i]);
  }
  for(i=0; i<usecase_node_count; i++){
    usecase_draw_node(g_usecase_pixmap, black_gc, &usecaseNodeDat[i]);
  }
  for(i=0; i<usecase_system_count; i++){
    usecase_draw_system(g_usecase_pixmap, black_gc, &usecaseSystemDat[i]);
  }
}

/*
 * usecase_draw_node
 */
void usecase_draw_node(GdkPixmap *pixmap, GdkGC *gc, UsecaseNodeStruct *n_ptr)
{
  switch(n_ptr->type){
  case usecase_actor_enum:
    usecase_draw_actor(pixmap, gc, n_ptr);
    break;
  case usecase_usecase_enum:
    usecase_draw_usecase(pixmap, gc, n_ptr);
    break;
  }
}  

/*
 * usecase_draw_actor
 */
void usecase_draw_actor(GdkPixmap *pixmap, GdkGC *gc,
			UsecaseNodeStruct *n_ptr)
{
  gdk_draw_arc(pixmap, gc, FALSE,
	       n_ptr->rect.x+15, n_ptr->rect.y, 20, 20, 0, 360*64);

  gdk_draw_line(pixmap, gc,
		n_ptr->rect.x, n_ptr->rect.y+30, 
		n_ptr->rect.x+50, n_ptr->rect.y+30);

  gdk_draw_line(pixmap, gc,
		n_ptr->rect.x+25, n_ptr->rect.y+20, 
		n_ptr->rect.x+25, n_ptr->rect.y+50);

  gdk_draw_line(pixmap, gc,
		n_ptr->rect.x+25, n_ptr->rect.y+50, 
		n_ptr->rect.x, n_ptr->rect.y+80);

  gdk_draw_line(pixmap, gc,
		n_ptr->rect.x+25, n_ptr->rect.y+50, 
		n_ptr->rect.x+50, n_ptr->rect.y+80);

  gdk_draw_string(pixmap, g_font, gc,
		  n_ptr->str_rect.x,
		  n_ptr->str_rect.y+n_ptr->str_rect.height-4,
		  n_ptr->name);
}

/*
 * usecase_draw_usecase
 */
void usecase_draw_usecase(GdkPixmap *pixmap,
			  GdkGC *gc, UsecaseNodeStruct *n_ptr)
{
  gdk_draw_arc(pixmap, gc, FALSE,
	       n_ptr->rect.x, n_ptr->rect.y, 100, 60, 0, 360*64);

  gdk_draw_string(pixmap, g_font, gc,
		  n_ptr->str_rect.x, n_ptr->str_rect.y,
		  n_ptr->name);
}

/*
 * usecase_draw_system
 */
void usecase_draw_system(GdkPixmap *pixmap,
			  GdkGC *gc, UsecaseSystemStruct *s_ptr)
{
  gdk_draw_rectangle(pixmap, gc, FALSE,
		     s_ptr->rect.x, s_ptr->rect.y,
		     s_ptr->rect.width, s_ptr->rect.height);
}

/*
 * usecase_draw_selected_node
 */
void usecase_draw_selected_node(GdkPixmap *pixmap,
				GdkGC *gc, UsecaseNodeStruct *n_ptr)
{
  int x1,x2,y1,y2;

  x1 = n_ptr->rect.x;
  x2 = n_ptr->rect.x + n_ptr->rect.width;
  y1 = n_ptr->rect.y;
  y2 = n_ptr->rect.y + n_ptr->rect.height;

  gdk_draw_rectangle(pixmap, gc, TRUE, x1-4, y1-4, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x1-4, y2-7, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x2+1, y1-4, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x2+1, y2-7, 4, 4);
}

/*
 * usecase_draw_selected_system
 */
void usecase_draw_selected_system(GdkPixmap *pixmap,
				  GdkGC *gc, UsecaseSystemStruct *s_ptr)
{
  int x1,x2,y1,y2;

  x1 = s_ptr->rect.x;
  x2 = s_ptr->rect.x + s_ptr->rect.width;
  y1 = s_ptr->rect.y;
  y2 = s_ptr->rect.y + s_ptr->rect.height;

  gdk_draw_rectangle(pixmap, gc, TRUE, x1-4, y1-4, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x1-4, y2, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x2+1, y1-4, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x2+1, y2, 4, 4);
}

/*
 * usecase_draw_selected_str
 */
void usecase_draw_selected_str(GdkPixmap *pixmap,
			       GdkGC *gc, GdkRectangle *rect)
{
  int x1,x2,y1,y2;

  x1 = rect->x;
  x2 = rect->x + rect->width;
  y1 = rect->y+2;
  y2 = rect->y - rect->height;

  gdk_draw_rectangle(pixmap, gc, TRUE, x1-2, y1-2, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x1-2, y2-2, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x2-2, y1-2, 4, 4);
  gdk_draw_rectangle(pixmap, gc, TRUE, x2-2, y2-2, 4, 4);
}

/*
 * usecase_draw_arc
 */
void usecase_draw_arc(GdkPixmap *pixmap, GdkGC *gc, UsecaseArcStruct *a_ptr)
{
  gdk_draw_line(pixmap, gc,
		a_ptr->start_x, a_ptr->start_y, a_ptr->end_x, a_ptr->end_y);

  if(strlen(a_ptr->name) > 0) {

    gdk_draw_rectangle(pixmap, white_gc, TRUE,
		     a_ptr->str_rect.x-2,
		     a_ptr->str_rect.y-a_ptr->str_rect.height,
		     a_ptr->str_rect.width+4,
		     a_ptr->str_rect.height+5);
    
    gdk_draw_string(pixmap, g_font, gc,
		    a_ptr->str_rect.x,
		    a_ptr->str_rect.y,
		    a_ptr->name);
  }
}

/*
 * usecase_draw_white_node
 */
void usecase_draw_white_node(GdkPixmap *pixmap, UsecaseNodeStruct *n_ptr)
{
  gdk_draw_rectangle(pixmap, white_gc, TRUE,
		     n_ptr->rect.x, n_ptr->rect.y,
		     n_ptr->rect.width, n_ptr->rect.height);

  gdk_draw_rectangle(pixmap, white_gc, TRUE,
		     n_ptr->str_rect.x,
		     n_ptr->str_rect.y,
		     n_ptr->str_rect.width,
		     n_ptr->str_rect.height);
}

/*
 * usecase_draw_selected_arc
 */
void usecase_draw_selected_arc(GdkPixmap *pixmap, UsecaseArcStruct *a_ptr)
{
  
  gdk_draw_line(pixmap, white_gc,
		a_ptr->start_x, a_ptr->start_y, a_ptr->end_x, a_ptr->end_y);

  gdk_draw_line(pixmap, select_gc,
		a_ptr->start_x, a_ptr->start_y, a_ptr->end_x, a_ptr->end_y);
}

