/*
 * usecase_io.c
 */
#include <stdio.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <X11/xpm.h>
#include <gdk_imlib.h>

#include "def_tenko.h"

#include "usecase_dialog.h"
#include "usecase_io.h"
#include "usecase_edit.h"
#include "usecase_util.h"

extern UsecaseNodeStruct usecaseNodeDat[USECASE_MAX_NODE];
extern UsecaseArcStruct usecaseArcDat[USECASE_MAX_ARC];
extern GdkPixmap *g_usecase_pixmap;

extern int usecase_node_count;
extern int usecase_node_seq;

extern int usecase_arc_count;
extern int usecase_arc_seq;

extern gchar *g_usecase_filename;

/*
 * usecase_header_save (local)
 */
void usecase_header_save(FILE *fp)
{
  fprintf(fp, AU_LINE);
  fprintf(fp, HD_LINE);
  fprintf(fp, AU_LINE);
}	  

/*
 * usecase_node_save
 */
void usecase_node_save(FILE *fp)
{
  int i, j;
  
  fprintf(fp, "Node! %d %d\n", usecase_node_count, usecase_node_seq);

  for(i=0; i<usecase_node_count; i++){
    fprintf(fp, "node:");
    fprintf(fp, " %d", usecaseNodeDat[i].id);
    fprintf(fp, " %s", usecaseNodeDat[i].name);
    fprintf(fp, " %d %d %d %d",
	    usecaseNodeDat[i].rect.x,
	    usecaseNodeDat[i].rect.y,
	    usecaseNodeDat[i].rect.width,
	    usecaseNodeDat[i].rect.height);
    fprintf(fp, " %d %d %d %d",
	    usecaseNodeDat[i].str_rect.x,
	    usecaseNodeDat[i].str_rect.y,
	    usecaseNodeDat[i].str_rect.width,
	    usecaseNodeDat[i].str_rect.height);
    fprintf(fp, " %d", usecaseNodeDat[i].type);
    fprintf(fp, " %d", usecaseNodeDat[i].select_mode);
    fprintf(fp, "\n");
  }
}

/*
 * usecase_arc_save
 */
void usecase_arc_save(FILE *fp)
{
  int i;
  
  fprintf(fp, "Arc! %d %d\n", usecase_arc_count, usecase_arc_seq);

  for(i=0; i<usecase_arc_count; i++){
    fprintf(fp, "arc:");
    fprintf(fp, " %d", usecaseArcDat[i].id);
    if(strlen(usecaseArcDat[i].name) > 0)
      fprintf(fp, " %s", usecaseArcDat[i].name);
    else
      fprintf(fp, " None");
    fprintf(fp, " %d %d %d %d",
	    usecaseArcDat[i].str_rect.x,
	    usecaseArcDat[i].str_rect.y,
	    usecaseArcDat[i].str_rect.width,
	    usecaseArcDat[i].str_rect.height);
    fprintf(fp, " %d %d %d",
	    usecaseArcDat[i].start_x,
	    usecaseArcDat[i].start_y,
	    usecaseArcDat[i].start_node_id);
    fprintf(fp, " %d %d %d",
	    usecaseArcDat[i].end_x,
	    usecaseArcDat[i].end_y,
	    usecaseArcDat[i].end_node_id);
    fprintf(fp, " %d", usecaseArcDat[i].select_mode);
    fprintf(fp, "\n");
  }
}

/*
 * usecase_save (global)
 */
void usecase_save()
{
  FILE *fp;
  
  if((fp = fopen(g_usecase_filename, "w")) == NULL) {
    g_print("Cannot Open %s\n", g_usecase_filename);
    return;
  }

  usecase_header_save(fp);
  usecase_node_save(fp);
  usecase_arc_save(fp);

  fclose(fp);
}

/*
 * usecase_load_header
 */
int usecase_load_header(FILE *fp)
{
  char line[BUFSIZ];

  fgets(line, BUFSIZ, fp);
  if(strcmp(line,AU_LINE)){
    printf("Invalid File\n");
    return FALSE;
  }
  fgets(line, BUFSIZ, fp);
  if(strcmp(line,HD_LINE)){
    printf("Invalid File\n");
    return FALSE;
  }
  fgets(line, BUFSIZ, fp);
  if(strcmp(line,AU_LINE)){
    printf("Invalid File\n");
    return FALSE;
  }

  return TRUE;
}

/*
 * usecase_load_node (local)
 */
void usecase_load_node(FILE *fp)
{
  char line[BUFSIZ];
  int count, seq;
  int i;
  int dummy;
  char str[6];
  char flg[6];

  fgets(line, BUFSIZ, fp);
  sscanf(line, "%s %d %d", str, &count, &seq);

  usecase_node_count = count;
  usecase_node_seq = seq;

  for(i=0; i<count; i++){
    fgets(line, BUFSIZ, fp);
    sscanf(line,
	   "%s %d %s %d %d %d %d %d %d %d %d %d %d",
	   flg, &usecaseNodeDat[i].id, usecaseNodeDat[i].name,
	   &usecaseNodeDat[i].rect.x,
	   &usecaseNodeDat[i].rect.y,
	   &usecaseNodeDat[i].rect.width,
	   &usecaseNodeDat[i].rect.height,
	   &usecaseNodeDat[i].str_rect.x,
	   &usecaseNodeDat[i].str_rect.y,
	   &usecaseNodeDat[i].str_rect.width,
	   &usecaseNodeDat[i].str_rect.height,
	   &usecaseNodeDat[i].type,
	   &dummy
	   );
  }
}  

/*
 * usecase_load_arc (local)
 */
void usecase_load_arc(FILE *fp)
{
  char line[BUFSIZ];
  int count, seq;
  int i;
  int dummy;
  char str[6];
  char flg[6];

  fgets(line, BUFSIZ, fp);
  sscanf(line, "%s %d %d", str, &count, &seq);

  usecase_arc_count = count;
  usecase_arc_seq = seq;

  for(i=0; i<count; i++){
    fgets(line, BUFSIZ, fp);
    sscanf(line,
	   "%s %d %s %d %d %d %d %d %d %d %d %d %d %d",
	   flg, &usecaseArcDat[i].id, usecaseArcDat[i].name,
	   &usecaseArcDat[i].str_rect.x,
	   &usecaseArcDat[i].str_rect.y,
	   &usecaseArcDat[i].str_rect.width,
	   &usecaseArcDat[i].str_rect.height,
	   &usecaseArcDat[i].start_x,
	   &usecaseArcDat[i].start_y,
	   &usecaseArcDat[i].start_node_id,
	   &usecaseArcDat[i].end_x,
	   &usecaseArcDat[i].end_y,
	   &usecaseArcDat[i].end_node_id,
	   &dummy
	   );
    if(!strcmp(usecaseArcDat[i].name,"None"))
      sprintf(usecaseArcDat[i].name,"");
  }
	   
  //usecase_arc_stdout_all(); //debug
}  

/*
 * usecase_load
 */
int usecase_load()
{
  FILE *fp;
  char line[BUFSIZ];
  
  if((fp = fopen(g_usecase_filename, "r")) == NULL) {
    g_print("Cannot Open %s\n", g_usecase_filename);
    return;
  }

  if(!usecase_load_header(fp)){
    g_print("Invalid header\n");
    return FALSE;
  }

  usecase_load_node(fp);
  usecase_load_arc(fp);

  fclose(fp);

  return TRUE;
}

/*
 * usecase_export
 */
void usecase_export(export_kind ek)
{
  GdkRectangle rect;
  GdkImlibImage *im;
  FILE *fp;

  int res;

  gchar *export_filename;
  
  export_filename = g_basename(g_usecase_filename);
  strtok(export_filename, ".");

  switch(ek){
  case JPG:
    strcat(export_filename, ".jpg");
    break;
    /**
  case PNG:
    strcat(export_filename, ".png");
    break;
    **/
  case EPS:
    strcat(export_filename, ".eps");
    break;
  }

  if((fp = fopen(export_filename, "w")) == NULL) {
    g_print("Cannot Open %s\n", export_filename);
    return;
  }

  if(!usecase_canvas_effective_rect(&rect)){
    g_print("No Effective Rect\n");
    return;
  }

  im = gdk_imlib_create_image_from_drawable((GdkWindow*)g_usecase_pixmap, 
					    NULL,
					    rect.x, rect.y,
					    rect.width, rect.height);

  res = gdk_imlib_save_image(im, export_filename, NULL);

  if(!res)
    g_print("Cannot Save Image\n");

  fclose(fp);

}
