/*
 * usecase_util.c
 */
#include <gtk/gtk.h>
#include <stdio.h>

#include "def_tenko.h"
#include "usecase_util.h"
#include "usecase_edit.h"
#include "usecase_dialog.h"

extern UsecaseNodeStruct usecaseNodeDat[USECASE_MAX_NODE];
extern UsecaseArcStruct usecaseArcDat[USECASE_MAX_ARC];
extern UsecaseSystemStruct usecaseSystemDat[USECASE_MAX_SYSTEM];

extern int usecase_node_count;
extern int usecase_node_seq;

extern int usecase_selected_node;
extern int usecase_last_selected_node;

extern int usecase_system_count;
extern int usecase_system_seq;
extern int usecase_selected_system;
extern int usecase_last_selected_system;

extern int usecase_arc_count;
extern int usecase_arc_seq;
extern int usecase_last_selected_arc;

extern gchar *g_usecase_filename;

/*
 * usecase_init_counters
 */
void usecase_init_counters()
{
  usecase_node_count = 0;
  usecase_node_seq   = 0;

  usecase_system_count = 0;
  usecase_system_seq   = 0;

  usecase_arc_count = 0;
  usecase_arc_seq   = 0;

  usecase_selected_node        = 9999;
  usecase_last_selected_node   = 9999;
  usecase_last_selected_arc    = 9999;
  usecase_selected_system      = 9999;
  usecase_last_selected_system = 9999;

}  

/*
 * usecase_init_nodes
 */
void usecase_init_nodes()
{
  int i;

  for(i=0; i<USECASE_MAX_NODE; i++){
    usecaseNodeDat[i].id = 0;
    sprintf(usecaseNodeDat[i].name, "");
    usecaseNodeDat[i].rect.x = 0;
    usecaseNodeDat[i].rect.y = 0;
    usecaseNodeDat[i].rect.width = 0;
    usecaseNodeDat[i].rect.height = 0;
    usecaseNodeDat[i].str_rect.x = 0;
    usecaseNodeDat[i].str_rect.y = 0;
    usecaseNodeDat[i].str_rect.width = 0;
    usecaseNodeDat[i].str_rect.height = 0;
    usecaseNodeDat[i].type = 0;
    usecaseNodeDat[i].select_mode = FALSE;
  }
}  

/*
 * usecase_init_systems
 */
void usecase_init_systems()
{
  int i;

  for(i=0; i<USECASE_MAX_SYSTEM; i++){
    usecaseSystemDat[i].id = 0;
    sprintf(usecaseSystemDat[i].name, "");
    usecaseSystemDat[i].rect.x = 0;
    usecaseSystemDat[i].rect.y = 0;
    usecaseSystemDat[i].rect.width = 0;
    usecaseSystemDat[i].rect.height = 0;
    usecaseSystemDat[i].str_rect.x = 0;
    usecaseSystemDat[i].str_rect.y = 0;
    usecaseSystemDat[i].str_rect.width = 0;
    usecaseSystemDat[i].str_rect.height = 0;
    usecaseSystemDat[i].type = 0;
    usecaseSystemDat[i].select_mode = usecase_false;
  }
}  

/*
 * usecase_init_arcs
 */
void usecase_init_arcs()
{
  int i;

  for(i=0; i<USECASE_MAX_ARC; i++){
    usecaseArcDat[i].id = 0;
    sprintf(usecaseArcDat[i].name, "");
    usecaseArcDat[i].str_rect.x = 0;
    usecaseArcDat[i].str_rect.y = 0;
    usecaseArcDat[i].str_rect.width = 0;
    usecaseArcDat[i].str_rect.height = 0;

    usecaseArcDat[i].start_x = 0;
    usecaseArcDat[i].start_y = 0;
    usecaseArcDat[i].start_node_id = 0;

    usecaseArcDat[i].end_x = 0;
    usecaseArcDat[i].end_y = 0;
    usecaseArcDat[i].end_node_id = 0;

    usecaseArcDat[i].select_mode = FALSE;
  }
}  

/*
 * usecase_node_stdout_all
 */
void usecase_node_stdout_all()
{
  int i;

  for(i=0; i<usecase_node_count; i++){
    g_print("node:");
    g_print(" %d", usecaseNodeDat[i].id);
    g_print(" %s", usecaseNodeDat[i].name);
    g_print(" %d %d %d %d",
	    usecaseNodeDat[i].rect.x,
	    usecaseNodeDat[i].rect.y,
	    usecaseNodeDat[i].rect.width,
	    usecaseNodeDat[i].rect.height);
    g_print(" %d %d %d %d",
	    usecaseNodeDat[i].str_rect.x,
	    usecaseNodeDat[i].str_rect.y,
	    usecaseNodeDat[i].str_rect.width,
	    usecaseNodeDat[i].str_rect.height);
    g_print(" %d", usecaseNodeDat[i].type);
    g_print(" %d", usecaseNodeDat[i].select_mode);
    g_print("\n");
  }
}

/*
 * usecase_arc_stdout_all
 */
void usecase_arc_stdout_all()
{
  int i;

  for(i=0; i<usecase_arc_count; i++){
    g_print("arc:");
    g_print(" %d", usecaseArcDat[i].id);
    g_print(" %s", usecaseArcDat[i].name);
    g_print(" %d %d %d %d",
	    usecaseArcDat[i].str_rect.x,
	    usecaseArcDat[i].str_rect.y,
	    usecaseArcDat[i].str_rect.width,
	    usecaseArcDat[i].str_rect.height);

    g_print(" %d", usecaseArcDat[i].start_x);
    g_print(" %d", usecaseArcDat[i].start_y);
    g_print(" %d", usecaseArcDat[i].start_node_id);

    g_print(" %d", usecaseArcDat[i].end_x);
    g_print(" %d", usecaseArcDat[i].end_y);
    g_print(" %d", usecaseArcDat[i].end_node_id);

    g_print(" %d", usecaseArcDat[i].select_mode);
    g_print("\n");
  }
}

/*
 * usecase_canvas_effective_rect
 */
gint usecase_canvas_effective_rect(GdkRectangle *rect)
{
  int i;
  int x = USECASE_PICTURE_WIDTH;
  int y = USECASE_PICTURE_HEIGHT;
  int w = 0;
  int h = 0;

  if(usecase_node_count == 0)
    return FALSE;

  for(i=0; i<usecase_node_count; i++){
    if(x > usecaseNodeDat[i].rect.x)
      x = usecaseNodeDat[i].rect.x;
    if(y > usecaseNodeDat[i].rect.y)
      y = usecaseNodeDat[i].rect.y; 
    if(w < (usecaseNodeDat[i].rect.x + usecaseNodeDat[i].rect.width))
      w = usecaseNodeDat[i].rect.x + usecaseNodeDat[i].rect.width;
    if(h < (usecaseNodeDat[i].rect.y + usecaseNodeDat[i].rect.height))
      h = usecaseNodeDat[i].rect.y + usecaseNodeDat[i].rect.height;
  }

  rect->x = x-10;
  rect->y = y-10;
  rect->width = w+25-x;
  rect->height = h+30-y;

  return TRUE;
}
