<?php function db_load_login($dbconn,$mb_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['login']}` " ."WHERE `mb_id`=".$dbconn->escape($mb_id); return $dbconn->query_row_assoc($sql); } function db_insert_login($dbconn,$mbinfo) { global $Config; $sql="INSERT INTO `{$Config->TableMap['login']}` " ."(`mb_login`, `mb_pswdhash`, `mb_status`) " ."VALUES (" ."'".$dbconn->escape($mbinfo['mb_login'])."'," ."'".$dbconn->escape($mbinfo['mb_pswdhash'])."'," ."'".$dbconn->escape($mbinfo['mb_status'])."')"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_update_password($dbconn,$mb_id,$mb_pswdhash) { global $Config; $sql="UPDATE `{$Config->TableMap['login']}` " ."SET `mb_pswdhash`='".$dbconn->escape($mb_pswdhash)."' " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_set_member($dbconn,$mb_id,$mbinfo) { global $Config; $mbinfo['mb_id']=$mb_id; list($fieldstr,$valuestr)=_db_data_strings_insert($dbconn,$mbinfo,array('mb_id', 'mb_nickname', 'mb_timezone_minutes', 'mb_timestamp')); if ($fieldstr) { $sql="REPLACE INTO `{$Config->TableMap['member']}` (".$fieldstr.") VALUES (".$valuestr.")"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } return false; } function db_update_member($dbconn,$mb_id,$mbinfo) { global $Config; $assignstr=_db_data_string_update($dbconn,$mbinfo,array('mb_nickname', 'mb_timezone_minutes', 'mb_timestamp'),true,true); if ($assignstr) { $sql="UPDATE `{$Config->TableMap['member']}` SET ".$assignstr." WHERE `mb_id`=".$dbconn->escape($mb_id,true); $dbconn->real_query($sql,"error.db.updatefail"); return $dbconn->insert_id(); } return false; } function db_member_set_status($dbconn,$mb_id,$mb_status) { global $Config; $sql="UPDATE `{$Config->TableMap['member']}` " ."SET `mb_status`='".$dbconn->escape($mb_status)."' " ."WHERE `mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_set_member_emails($dbconn,$mb_id,$emails) { global $Config; $sql="DELETE FROM `{$Config->TableMap['member_email']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." " .($emails?"AND `mb_email` NOT IN (".$dbconn->escape($emails,true).")":' '); $dbconn->real_query($sql,"error.db.deletefail"); if (!$emails) return; $sql="INSERT IGNORE INTO `{$Config->TableMap['member_email']}` " ."(`mb_id`, `mb_email`, `me_timestamp`, `me_status`) VALUES "; $first=true; foreach ($emails as $email) { if ($first) $first=false; else $sql.=","; $sql.="('".$dbconn->escape($mb_id)."','".$dbconn->escape($email)."',UTC_TIMESTAMP(),'PREVALID')"; } $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_validate_member_email($dbconn,$mb_id,$emails) { if (!$emails) return; global $Config; $sql="UPDATE `{$Config->TableMap['member_email']}` " ."SET " ."`me_status`='VALIDATED', `me_timestamp`=UTC_TIMESTAMP() " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." AND " ."`mb_email` IN (".$dbconn->escape($emails,true).")"; $dbconn->real_query($sql,"error.db.updatefail"); return $dbconn->affected_rows(); } function db_set_member_info($dbconn,$mb_id,$mbinfo) { global $Config; $mbinfo['mb_id']=$mb_id; list($fieldstr,$valuestr)=_db_data_strings_insert($dbconn,$mbinfo,array('mb_id', 'mb_name', 'mb_name_read', 'mb_gender', 'mb_zipcode', 'mb_country', 'mb_state', 'mb_city', 'mb_address', 'mb_birthday', 'mb_timestamp')); if ($fieldstr) { $sql="REPLACE INTO `{$Config->TableMap['member_info']}` (".$fieldstr.") VALUES (".$valuestr.")"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } return false; } function db_update_member_info($dbconn,$mb_id,$mbinfo) { global $Config; $assignstr=_db_data_string_update($dbconn,$mbinfo,array('mb_id', 'mb_name', 'mb_name_read', 'mb_gender', 'mb_zipcode', 'mb_country', 'mb_state', 'mb_city', 'mb_address', 'mb_birthday', 'mb_timestamp'),true,true); if ($assignstr) { $sql="UPDATE `{$Config->TableMap['member_info']}` SET ".$assignstr." WHERE `mb_id`=".$dbconn->escape($mb_id,true); $dbconn->real_query($sql,"error.db.updatefail"); return $dbconn->insert_id(); } return false; } function db_set_member_phones($dbconn,$mb_id,$phones) { global $Config; $sql="DELETE FROM `{$Config->TableMap['member_phone']}` " ."WHERE `mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.deletefail"); if ($phones) { $sql=""; foreach ($phones as $phone) { if ($sql) $sql.=", "; $sql.="(".$dbconn->escape($mb_id).", '".$dbconn->escape($phone)."')"; } $sql="REPLACE INTO `{$Config->TableMap['member_phone']}` (" ."`mb_id`, `mb_phone`" .") VALUES ".$sql; $dbconn->real_query($sql,"error.db.insertfail"); } } function db_set_member_notifying_email($dbconn,$mb_id,$email) { global $Config; $sql="UPDATE `{$Config->TableMap['member_email']}` " ."SET `me_notify`=(`mb_email`=".$dbconn->escape($email,true).") " ."WHERE `mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_set_member_timezone($dbconn,$mb_id,$mb_timezone_minutes) { global $Config; $sql="UPDATE `{$Config->TableMap['member']}` " ."SET `mb_timezone_minutes`=".$dbconn->escape($mb_timezone_minutes)." " ."WHERE `mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_clean_expired_prevalids($dbconn) { global $Config; $sql="DELETE FROM `{$Config->TableMap['member_email']}` " ."WHERE " ."`me_timestamp`<UTC_TIMESTAMP() - INTERVAL ".$Config->PREVALID_LIFTTIME." SECOND AND " ."`me_status`='PREVALID'"; $dbconn->real_query($sql,"error.db.deletefail"); } function db_count_login($dbconn,$login) { global $Config; db_clean_expired_prevalids($dbconn); $sql="SELECT COUNT(*) FROM `{$Config->TableMap['login']}` " ."WHERE `mb_login`='".$dbconn->escape($login)."'"; return $dbconn->query_value($sql); } function db_member_ids_by_logins($dbconn,$logins,$validatedonly=true) { if (!$emails) return array(); global $Config; $sql="SELECT `mb_id` " ."FROM `{$Config->TableMap['login']}` " ."WHERE " ."`mb_login` IN (".$dbconn->escape($logins,true).") " .($validatedonly?"AND `mb_status`='VALID' ":''); return $dbconn->query_value_array($sql); } function db_load_email_with_login($dbconn,$email,$login=false,$validatedonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['member_email']}` " ."NATURAL JOIN `{$Config->TableMap['login']}` " ."WHERE " ."`mb_email`=".$dbconn->escape($email,true)." " .($login?"AND `mb_login`=".$dbconn->escape($login,true)." ":'') .($validatedonly?"AND `me_status`='VALIDATED' ":''); return $dbconn->query_allrows_assoc($sql,"error.db.queryfail"); } function db_load_unilar_balance($dbconn,$mb_id) { global $Config; $sql="SELECT `ub_amount` " ."FROM `{$Config->TableMap['unilar_balance']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id); return 0+$dbconn->query_value($sql); } function db_record_unilar_flow($dbconn,$history) { if (!isset($history['mb_id']) || !isset($history['uh_amount']) || !isset($history['uh_reason'])) throw new Exception("Losing entries in unilar history record: ".print_r($history,true)); if (!$history['uh_amount']) return 0; global $Config; $sql="INSERT INTO `{$Config->TableMap['unilar_history']}` (" ."`mb_id`, `uh_amount`, `uh_reason`, `uh_comment`, `uh_result_balance`, `uh_timestamp`" .") VALUES (" .$dbconn->escape($history['mb_id']).", " .$dbconn->escape($history['uh_amount']).", " .$dbconn->escape($history['uh_reason'],true).", " .($history['uh_comment']?$dbconn->escape($history['uh_comment'],true):'NULL').", " ."IFNULL(( " ."SELECT `ub_amount` " ."FROM `{$Config->TableMap['unilar_balance']}` " ."WHERE `mb_id`=".$dbconn->escape($history['mb_id'])." " ."),0)+(".$dbconn->escape($history['uh_amount'])."), " ."UTC_TIMESTAMP() )"; $dbconn->real_query($sql,"error.db.insertfail"); $uh_id=$dbconn->insert_id(); $sql="INSERT IGNORE INTO `{$Config->TableMap['unilar_balance']}` (" ."`mb_id`, `ub_amount`" .") VALUES (" .$dbconn->escape($history['mb_id']).", " ."0)"; $dbconn->real_query($sql,"error.db.insertfail"); $sql="UPDATE `{$Config->TableMap['unilar_balance']}` " ."SET `ub_amount`=`ub_amount`+".$dbconn->escape($history['uh_amount'])." " ."WHERE " ."`mb_id`=".$dbconn->escape($history['mb_id']); $dbconn->real_query($sql,"error.db.insertfail"); return $uh_id; } function db_insert_affiliate_history($dbconn,$mb_id_affiliate,$mb_id_invited,$uh_id,$afltr_id,$ah_ip_invited=false,$ah_pcid_invited=false) { global $Config; $sql="INSERT INTO `{$Config->TableMap['affiliate_history']}` ( " ."`mb_id_affiliate`, `mb_id_invited`, `uh_id`, `afltr_id`, `ah_ip_invited`, `ah_pcid_invited` , `aflt_timestamp` " .") VALUES (" .($mb_id_affiliate?$dbconn->escape($mb_id_affiliate,true):'NULL').", " .$dbconn->escape($mb_id_invited,true).", " .($uh_id?$dbconn->escape($uh_id):'NULL').", " .($afltr_id?$dbconn->escape($afltr_id,true):'NULL').", " .($ah_ip_invited?$dbconn->escape($ah_ip_invited,true):'NULL').", " .($ah_pcid_invited?$dbconn->escape($ah_pcid_invited,true):'NULL').", " ."UTC_TIMESTAMP() ) "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_count_affiliate_contribution($dbconn,$ip,$pcid) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['affiliate_history']}` " ."WHERE " ."`aflt_pcid`=".$dbconn->escape($pcid,true)." OR " ."`aflt_ip`=".$dbconn->escape($ip,true)." AND " ."`aflt_timestamp`>=DATE_SUB(UTC_TIMESTAMP(),INTERVAL ".$dbconn->escape($Config->HISTORY_IP_LIFE_TIME)." SECOND)"; return $dbconn->query_value($sql); } function db_load_affiliate_by_invitee($dbconn,$mb_id_invited) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['affiliate_history']}` " ."WHERE " ."`mb_id_invited`=".$dbconn->escape($mb_id_invited); return $dbconn->query_row_assoc($sql); } function db_insert_bill_detail($dbconn,$uh_id,$ubd_amount,$ubd_upto_timestamp=null) { if (!$uh_id) return 0; global $Config; $sql="INSERT INTO `{$Config->TableMap['unilar_bill_detail']}` (" ."`uh_id`, `ubd_amount`, `ubd_upto_timestamp`" .") VALUES (" .$dbconn->escape($uh_id).", " .$dbconn->escape($ubd_amount).", " .($ubd_upto_timestamp?$dbconn->escape($ubd_upto_timestamp,true):'NULL').") "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function _db_insert_bill_detail_obj($dbconn,$objname,$ubd_id,$obj_id_key,$obj_id_val) { if (!$ubd_id) return; global $Config; $sql="INSERT INTO `{$Config->TableMap[$objname]}` (" ."`ubd_id`,`{$obj_id_key}`" .") VALUES (" .$dbconn->escape($ubd_id).", " .$dbconn->escape($obj_id_val).")"; $dbconn->real_query($sql,"error.db.insertfail"); } function db_insert_bill_classroom($dbconn,$ubd_id,$clsr_id) { _db_insert_bill_detail_obj($dbconn,'bill_classroom',$ubd_id,'clsr_id',$clsr_id); } function db_insert_bill_course($dbconn,$ubd_id,$cs_id) { _db_insert_bill_detail_obj($dbconn,'bill_course',$ubd_id,'cs_id',$cs_id); } function db_insert_bill_lecture($dbconn,$ubd_id,$lctr_id) { _db_insert_bill_detail_obj($dbconn,'bill_lecture',$ubd_id,'lctr_id',$lctr_id); } function db_insert_bill_place($dbconn,$ubd_id,$plc_id) { _db_insert_bill_detail_obj($dbconn,'bill_place',$ubd_id,'plc_id',$plc_id); } function db_insert_bill_reservation($dbconn,$ubd_id,$rsv_id) { _db_insert_bill_detail_obj($dbconn,'bill_reservation',$ubd_id,'rsv_id',$rsv_id); } function db_insert_bill_seat($dbconn,$ubd_id,$st_id) { _db_insert_bill_detail_obj($dbconn,'bill_seat',$ubd_id,'st_id',$st_id); } function db_insert_bill_timeavail($dbconn,$ubd_id,$ta_id) { _db_insert_bill_detail_obj($dbconn,'bill_timeavail',$ubd_id,'ta_id',$ta_id); } function _db_load_last_bill_detail($dbconn,$objname,$obj_id_key,$obj_id_vals) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap[$objname]}` " ."NATURAL JOIN `{$Config->TableMap['unilar_bill_detail']}` " ."WHERE " ."`ubd_id` IN (" ."SELECT MAX(`ubd_id`) " ."FROM `{$Config->TableMap[$objname]}` " ."WHERE " ."`{$obj_id_key}` IN (".$dbconn->escape($obj_id_vals).") " ."GROUP BY `{$obj_id_key}` " .") AND " ."`{$obj_id_key}` IN (".$dbconn->escape($obj_id_vals).") " ."ORDER BY `ubd_upto_timestamp` DESC "; return $dbconn->query_allrows_assoc($sql); } function db_load_last_bill_classroom($dbconn,$clsr_ids) { return _db_load_last_bill_detail($dbconn,'bill_classroom','clsr_id',$clsr_ids); } function db_load_last_bill_course($dbconn,$cs_ids) { return _db_load_last_bill_detail($dbconn,'bill_course','cs_id',$cs_ids); } function db_load_last_bill_lecture($dbconn,$lctr_ids) { return _db_load_last_bill_detail($dbconn,'bill_lecture','lctr_id',$lctr_ids); } function db_load_last_bill_place($dbconn,$plc_ids) { return _db_load_last_bill_detail($dbconn,'bill_place','plc_id',$plc_ids); } function db_load_last_bill_reservation($dbconn,$rsv_ids) { return _db_load_last_bill_detail($dbconn,'bill_reservation','rsv_id',$rsv_ids); } function db_load_last_bill_seat($dbconn,$st_ids) { return _db_load_last_bill_detail($dbconn,'bill_seat','st_id',$st_ids); } function db_load_last_bill_timeavail($dbconn,$ta_ids) { return _db_load_last_bill_detail($dbconn,'bill_timeavail','ta_id',$ta_ids); } function db_load_unilar_history($dbconn,$mb_id,$offset=false,$limit=false) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['unilar_history']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." " ."ORDER BY `uh_id` DESC " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_load_unilar_history_by_id($dbconn,$uh_id,$mb_id=false) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['unilar_history']}` " ."WHERE " .($mb_id?"`mb_id`=".$dbconn->escape($mb_id)." AND ":'') ."`uh_id`=".$dbconn->escape($uh_id)." "; return $dbconn->query_row_assoc($sql); } function db_load_bill_detail($dbconn,$uh_id,$offset=false,$limit=false) { global $Config; $sql="SELECT " ."`ubd`.*, " ."`bclsr`.`clsr_id`, `bcs`.`cs_id`, `bl`.`lctr_id`, `bp`.`plc_id`, COALESCE(`r`.`rsv_id`, `rc`.`rsv_id`) `rsv_id`, `bs`.`st_id`, `bt`.`ta_id`, " ."`clsr`.`clsr_name`, " ."COALESCE(`cd`.`cs_name`, `lcd`.`cs_name`, `rlcd`.`cs_name`) `cs_name`, " ."COALESCE(`l`.`lctr_since`, `rl`.`lctr_since`) `lctr_since`, " ."COALESCE(`l`.`lctr_expire`, `rl`.`lctr_expire`) `lctr_expire`, " ."`p`.`plc_name`, " ."`m`.`mb_nickname`, " ."`s`.`st_no`, " ."`t`.`ta_begin`, `t`.`ta_end`, " ."`rl`.`lctr_id` `rsv_lctr_id` " ."FROM `{$Config->TableMap['unilar_bill_detail']}` `ubd` " ."NATURAL LEFT JOIN `{$Config->TableMap['bill_classroom']}` `bclsr` " ."NATURAL LEFT JOIN `{$Config->TableMap['bill_course']}` `bcs` " ."NATURAL LEFT JOIN `{$Config->TableMap['bill_lecture']}` `bl` " ."NATURAL LEFT JOIN `{$Config->TableMap['bill_place']}` `bp` " ."NATURAL LEFT JOIN `{$Config->TableMap['bill_reservation']}` `br` " ."NATURAL LEFT JOIN `{$Config->TableMap['bill_seat']}` `bs` " ."NATURAL LEFT JOIN `{$Config->TableMap['bill_timeavail']}` `bt` " ."LEFT JOIN `{$Config->TableMap['classroom']}` `clsr` ON (`clsr`.`clsr_id`=`bclsr`.`clsr_id`) " ."LEFT JOIN `{$Config->TableMap['course_desc']}` `cd` ON (`cd`.`cs_id`=`bcs`.`cs_id`) " ."LEFT JOIN `{$Config->TableMap['lecture']}` `l` ON (`l`.`lctr_id`=`bl`.`lctr_id`) " ."LEFT JOIN `{$Config->TableMap['place']}` `p` ON (`p`.`plc_id`=`bp`.`plc_id`) " ."LEFT JOIN `{$Config->TableMap['reservation']}` `r` ON (`r`.`rsv_id`=`br`.`rsv_id`) " ."LEFT JOIN `{$Config->TableMap['reservation_cancel']}` `rc` ON (`rc`.`rsv_id`=`br`.`rsv_id`) " ."LEFT JOIN `{$Config->TableMap['seat']}` `s` ON (`s`.`st_id`=`bs`.`st_id`) " ."LEFT JOIN `{$Config->TableMap['timeavail']}` `t` ON (`t`.`ta_id`=`bt`.`ta_id`) " ."LEFT JOIN `{$Config->TableMap['course_desc']}` `lcd` ON (`lcd`.`cs_id`=`l`.`cs_id`) " ."LEFT JOIN `{$Config->TableMap['lecture']}` `rl` ON (`rl`.`lctr_id`=`r`.`lctr_id` OR `rl`.`lctr_id`=`rc`.`lctr_id`) " ."LEFT JOIN `{$Config->TableMap['course_desc']}` `rlcd` ON (`rlcd`.`cs_id`=`rl`.`cs_id`) " ."LEFT JOIN `{$Config->TableMap['member']}` `m` ON (`m`.`mb_id`=`r`.`mb_id` OR `m`.`mb_id`=`rc`.`mb_id`) " ."WHERE " ."`ubd`.`uh_id`=".$dbconn->escape($uh_id)." " ."ORDER BY `ubd_id` DESC " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function _db_query_unpaid_subscription_obj($dbconn,$objname,$obj_key,$obj_status_key,$obj_status_val,$due_time,$fields=array('COUNT(*) `count`'),$limit=false,$eq_conds=array()) { global $Config; $obj_bill_table="`".$Config->TableMap["bill_".$objname]."`"; $eq_cond_str=""; foreach ($eq_conds as $key=>$value) $eq_cond_str.="AND `".$key."`='".$dbconn->escape($value)."' "; $sql="SELECT " .implode(', ',$fields)." " ."FROM `{$Config->TableMap[$objname]}` `o` " ."JOIN `{$obj_bill_table}` `ob` USING (`$obj_key`) " ."LEFT JOIN `{$Config->TableMap['unilar_bill_detail']}` `ubd` USING(`ubd_id`) " ."WHERE " ."`ubd_upto_timestamp`<".$dbconn->escape($due_time,true)." AND " ."`{$obj_status_key}`='{$obj_status_val}' " .$eq_cond_str ._db_limit($limit); return $dbconn->query_allrows_assoc($sql); } function db_query_member_with_unpaid_subscription($dbconn,$due_datetime,$limit=false,$fields=array('COUNT(DISTINCT `mb_id`) `count`'),$eq_cond_map=array()) { global $Config; $DDTesc=$dbconn->escape($due_datetime); $eq_cond_str=""; foreach ($eq_cond_map as $key=>$value) $eq_cond_str.="`".$key."`=".$dbconn->escape($value,true)." AND "; $sql_classroom="SELECT " ."`lgn`.`mb_id` `mb_id`, `clsr`.`clsr_id` `clsr_id`, NULL `cs_id`, NULL `plc_id`, NULL `st_id` " ."FROM `{$Config->TableMap['login']}` `lgn` " ."JOIN `{$Config->TableMap['classroom']}` `clsr`            ON (`clsr` .`mb_id_owner`=`lgn`. `mb_id`  ) " ."LEFT JOIN (" ."SELECT `clsr_id`, MAX(`ubd_upto_timestamp`) `ubd_upto_timestamp`" ."FROM `{$Config->TableMap['bill_classroom']}` " ."NATURAL JOIN `{$Config->TableMap['unilar_bill_detail']}` " ."GROUP BY `clsr_id` " .") `u` ON ( `clsr`.`clsr_id`=`u`.`clsr_id` ) " ."WHERE " ."`clsr`.`clsr_status`='VALID' AND " ."(`u`.`ubd_upto_timestamp` IS NULL OR `u`.`ubd_upto_timestamp`<'$DDTesc') AND " .$eq_cond_str ."1 "; $sql_course="SELECT " ."`lgn`.`mb_id` `mb_id`, NULL `clsr_id`, `cs`.`cs_id` `cs_id`, NULL `plc_id`, NULL `st_id` " ."FROM `{$Config->TableMap['login']}` `lgn` " ."JOIN `{$Config->TableMap['course']}` `cs`                 ON (`cs` .`mb_id_owner`=`lgn`.`mb_id`  ) " ."LEFT JOIN (" ."SELECT `cs_id`, MAX(`ubd_upto_timestamp`) `ubd_upto_timestamp`" ."FROM `{$Config->TableMap['bill_course']}` " ."NATURAL JOIN `{$Config->TableMap['unilar_bill_detail']}` " ."GROUP BY `cs_id` " .") `u` ON ( `cs`.`cs_id`=`u`.`cs_id` ) " ."WHERE " ."`cs`  .`cs_status`  ='VALID' AND " ."(`u`.`ubd_upto_timestamp` IS NULL OR `u`.`ubd_upto_timestamp`<'$DDTesc') AND " .$eq_cond_str ."1 "; $sql_place="SELECT " ."`lgn`.`mb_id` `mb_id`, NULL `clsr_id`, NULL `cs_id`, `p`.`plc_id` `plc_id`, NULL `st_id` " ."FROM `{$Config->TableMap['login']}` `lgn` " ."JOIN `{$Config->TableMap['place']}` `p`                   ON (`p`    .`mb_id_owner`=`lgn`.`mb_id`  ) " ."LEFT JOIN (" ."SELECT `plc_id`, MAX(`ubd_upto_timestamp`) `ubd_upto_timestamp`" ."FROM `{$Config->TableMap['bill_place']}` " ."NATURAL JOIN `{$Config->TableMap['unilar_bill_detail']}` " ."GROUP BY `plc_id` " .") `u` ON ( `p`.`plc_id`=`u`.`plc_id` ) " ."WHERE " ."`p`   .`plc_status` ='VALID' AND " ."(`u`.`ubd_upto_timestamp` IS NULL OR `u`.`ubd_upto_timestamp`<'$DDTesc') AND " .$eq_cond_str ."1 "; $sql_seat="SELECT " ."`lgn`.`mb_id` `mb_id`, NULL `clsr_id`, NULL `cs_id`, NULL `plc_id`, `s`.`st_id` `st_id` " ."FROM `{$Config->TableMap['login']}` `lgn` " ."JOIN `{$Config->TableMap['place']}` `sp`                  ON (`sp`   .`mb_id_owner`=`lgn`.`mb_id` ) " ."JOIN `{$Config->TableMap['seat']}` `s`                    ON (`s`    .`plc_id`     =`sp` .`plc_id`) " ."LEFT JOIN (" ."SELECT `st_id`, MAX(`ubd_upto_timestamp`) `ubd_upto_timestamp`" ."FROM `{$Config->TableMap['bill_seat']}` " ."NATURAL JOIN `{$Config->TableMap['unilar_bill_detail']}` " ."GROUP BY `st_id` " .") `u` ON ( `s`.`st_id`=`u`.`st_id` ) " ."WHERE " ."`s`   .`st_status`  ='VALID' AND " ."(`u`.`ubd_upto_timestamp` IS NULL OR `u`.`ubd_upto_timestamp`<'$DDTesc') AND " .$eq_cond_str ."1 "; $sql="SELECT " .implode(', ',$fields)." " ."FROM ( ( " .$sql_classroom.") UNION ( " .$sql_course .") UNION ( " .$sql_place .") UNION ( " .$sql_seat .") ) `lgn` " ._db_limit($limit); return $dbconn->query_allrows_assoc($sql); } function db_load_classroom_bill_factors($dbconn,$clsr_ids) { if (!$clsr_ids) return array(); global $Config; $sql="SELECT " ."`clsr_id`, LENGTH(`clsr_desc`) `clsr_desc_len`, COALESCE(MAX(`ubd_upto_timestamp`),`clsr_timestamp_initial`) `charge_since` " ."FROM `{$Config->TableMap['classroom']}` " ."LEFT JOIN `{$Config->TableMap['bill_classroom']}` USING (`clsr_id`) " ."LEFT JOIN `{$Config->TableMap['unilar_bill_detail']}` USING (`ubd_id`) " ."WHERE " ."`clsr_id` IN (".$dbconn->escape($clsr_ids).") " ."GROUP BY `clsr_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_course_bill_factors($dbconn,$cs_ids) { if (!$cs_ids) return array(); global $Config; if (!$cs_ids) return array(); global $Config; $sql="SELECT " ."`cs_id`, LENGTH(`cs_desc`) `cs_desc_len`, `cs_desc_type`, COALESCE(MAX(`ubd_upto_timestamp`),`cs_timestamp_initial`) `charge_since` " ."FROM `{$Config->TableMap['course']}` " ."NATURAL JOIN `{$Config->TableMap['course_desc']}` " ."LEFT JOIN `{$Config->TableMap['bill_course']}` USING (`cs_id`) " ."LEFT JOIN `{$Config->TableMap['unilar_bill_detail']}` USING (`ubd_id`) " ."WHERE " ."`cs_id` IN (".$dbconn->escape($cs_ids).") " ."GROUP BY `cs_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_place_bill_factors($dbconn,$plc_ids) { if (!$plc_ids) return array(); global $Config; $sql="SELECT " ."`plc_id`, COALESCE(MAX(`ubd_upto_timestamp`),`plc_timestamp_initial`) `charge_since` " ."FROM `{$Config->TableMap['place']}` " ."LEFT JOIN `{$Config->TableMap['bill_place']}` USING (`plc_id`) " ."LEFT JOIN `{$Config->TableMap['unilar_bill_detail']}` USING (`ubd_id`) " ."WHERE " ."`plc_id` IN (".$dbconn->escape($plc_ids).") " ."GROUP BY `plc_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_seat_bill_factors($dbconn,$st_ids) { if (!$st_ids) return array(); global $Config; $sql="SELECT " ."`st_id`, COALESCE(MAX(`ubd_upto_timestamp`),`st_timestamp_initial`) `charge_since` " ."FROM `{$Config->TableMap['seat']}` " ."LEFT JOIN `{$Config->TableMap['bill_seat']}` USING (`st_id`) " ."LEFT JOIN `{$Config->TableMap['unilar_bill_detail']}` USING (`ubd_id`) " ."WHERE " ."`st_id` IN (".$dbconn->escape($st_ids).") " ."GROUP BY `st_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_purchase_history($dbconn,$ph_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['purchase_history']}` " ."WHERE " ."`ph_id`=".$dbconn->escape($ph_id); return $dbconn->query_row_assoc($sql); } function db_load_purchase_history_paypal($dbconn,$txn_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['purchase_history']}` " ."WHERE " ."`txn_id_paypal`=".$dbconn->escape($txn_id,true); return $dbconn->query_row_assoc($sql); } function db_insert_purchase_history_paypal($dbconn,$mb_id,$ph_object,$txn_id) { global $Config; $sql="INSERT `{$Config->TableMap['purchase_history']}` (" ."`mb_id`, `ph_object`, `ph_timestamp_create`, `ph_status`, `txn_id_paypal`" .") VALUES (" .$dbconn->escape($mb_id,true).", " .$dbconn->escape($ph_object,true).", " ."UTC_TIMESTAMP(), " ."'VALID', " .$dbconn->escape($txn_id,true).") "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_complete_purchase_history($dbconn,$ph_id) { global $Config; $sql="UPDATE `{$Config->TableMap['purchase_history']}` " ."SET `ph_timestamp_complete`=UTC_TIMESTAMP() " ."WHERE `ph_id`=".$dbconn->escape($ph_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_insert_paypal_ipn_history($dbconn,$ph_id,$ipn_data) { if (!$ipn_data) return; global $Config; $sql="INSERT `{$Config->TableMap['paypal_ipn_history']}` (" ."`ph_id`, `key`, `value`" .") VALUES "; $first=true; foreach ($ipn_data as $key=>$value) { if ($first) $first=false; else $sql.=", "; $sql.="(".$dbconn->escape($ph_id,true).",".$dbconn->escape($key,true).",".$dbconn->escape($value,true).")"; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_load_address_from_zipcode($dbconn,$zc_country,$zc_zipcode) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['zipcode']}` " ."WHERE " ."`zc_country`=".$dbconn->escape($zc_country,true)." AND " ."`zc_zipcode`=".$dbconn->escape($zc_zipcode,true); return $dbconn->query_allrows_assoc($sql); } function db_load_zipcode_region($dbconn,$zc_country,$zc_prefecture=false,$zc_city=false,$zc_district=false,$bc_group_by_key=false,$mb_id_compere=false) { global $Config; if ($mb_id_compere) { $sql="SELECT `plc_state` `zc_prefecture`, `plc_city` `zc_city`, `plc_address` `zc_district` " ."FROM `{$Config->TableMap['place']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_compere)." AND " ."`plc_country`=".$dbconn->escape($zc_country,true)." " ."GROUP BY `plc_state`, `plc_city`, `plc_address` " ."ORDER BY `plc_state`, `plc_city`, `plc_address` "; return $dbconn->query_allrows_assoc($sql); } else if (!$zc_prefecture && !$zc_city && !$zc_district) { $sql="SELECT * " ."FROM `{$Config->TableMap['prefectures']}` " ."WHERE " ."`zc_country`=".$dbconn->escape($zc_country,true); return $dbconn->query_allrows_assoc($sql); } else { $sql="SELECT * " ."FROM `{$Config->TableMap['zipcode']}` " ."WHERE " ."`zc_country`=".$dbconn->escape($zc_country,true)." AND " .($zc_prefecture?"`zc_prefecture`=".$dbconn->escape($zc_prefecture,true)." AND ":'') .($zc_city?"`zc_city`=".$dbconn->escape($zc_city,true)." AND ":'') .($zc_district?"`zc_district`=".$dbconn->escape($zc_district,true)." AND ":'') ."1 " .($bc_group_by_key?"GROUP BY `".$dbconn->escape($bc_group_by_key)."` ":'') ."ORDER BY `zc_country`, `zc_prefecture`, `zc_city`, `zc_district` "; return $dbconn->query_allrows_assoc($sql); } } function _db_insert_file_history($dbconn,$fh_id_updates,$text,$brief) { global $Config; $sql="INSERT INTO `{$Config->TableMap['file_history']}` (" ."`fh_id_updates`, `fh_brief`, `fh_text`, `fh_timestamp`" .") VALUES (" .($fh_id_updates?$dbconn->escape($fh_id_updates):'NULL')."," .($brief?$dbconn->escape($brief,true):'NULL')."," .$dbconn->escape($text,true)."," ."UTC_TIMESTAMP())"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_insert_file($dbconn,$text,$brief=false) { global $Config; $fh_id=_db_insert_file_history($dbconn,false,$text,$brief); $sql="INSERT INTO `{$Config->TableMap['file']}` (" ."`fh_id`" .") VALUES (" .$fh_id .")"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_update_file($dbconn,$file_id,$text,$brief=false) { global $Config; $fh_id=_db_insert_file_history($dbconn,$file_id,$text,$brief); $sql="UPDATE `{$Config->TableMap['file']}` " ."SET `fh_id`=".$fh_id." " ."WHERE `file_id`=".$dbconn->escape($file_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_record_login_alias($dbconn,$mb_id,$mb_id_alias) { global $Config; $sql="REPLACE INTO `{$Config->TableMap['login_alias']}` (`mb_id`, `mb_id_alias`) VALUES (" .$dbconn->escape($mb_id).", " .$dbconn->escape($mb_id_alias).")"; $dbconn->real_query($sql,"error.db.insertfail"); } function db_insert_affiliator($dbconn,$afltr_name,$afltr_pcid) { global $Config; $sql="INSERT INTO `{$Config->TableMap['affiliator']}` (`afltr_name`, `afltr_pcid`, `afltr_timestamp`) VALUE (" .$dbconn->escape($afltr_name,true).", " .$dbconn->escape($afltr_pcid,true).", " ."UTC_TIMESTAMP() ) "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_load_affiliator($dbconn,$afltr_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['affiliator']}` " ."WHERE " ."`afltr_id`=".$dbconn->escape($afltr_id,true); return $dbconn->query_row_assoc($sql); } function db_load_affiliator_contribution($dbconn,$afltr_id,$limit=false,$offset=false) { global $Config; $sql="SELECT `mb_id_invited` " ."FROM `{$Config->TableMap['affiliate_history']}` " ."WHERE " ."`afltr_id`=".$dbconn->escape($afltr_id,true)." " ."ORDER BY `aflt_timestamp` DESC " ._db_limit($limit,$offset); return $dbconn->query_value_array($sql); } function db_count_affiliator_contribution_unique($dbconn,$afltr_id) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['affiliate_history']}` " ."WHERE " ."`afltr_id`=".$dbconn->escape($afltr_id,true)." AND " ."`mb_id_invited` IN (" ."SELECT `mb_id_invited` " ."FROM `{$Config->TableMap['affiliate_history']}` " ."WHERE " ."`afltr_id`=".$dbconn->escape($afltr_id,true)." " ."GROUP BY `ah_ip_invited` " .") AND " ."`mb_id_invited` IN (" ."SELECT `mb_id_invited` " ."FROM `{$Config->TableMap['affiliate_history']}` " ."WHERE " ."`afltr_id`=".$dbconn->escape($afltr_id,true)." " ."GROUP BY `ah_pcid_invited` " .") AND " ."`mb_id_invited` IN (" ."SELECT `mb_id` " ."FROM `{$Config->TableMap['member_notifiable']}` " ."GROUP BY `mb_email` " .") "; return $dbconn->query_value($sql); } ?>