<?php /*~ datetime.inc.php
.---------------------------------------------------------------------------.
|  Software: General Purpose Large Range Date Time Library                  |
|   Version: 0.1                                                            |
|   Contact: via http://www.uniwits.com/contact                             |
|      Info: http://www.uniwits.com/                                        |
|   Support: http://www.uniwits.com/support                                 |
| ------------------------------------------------------------------------- |
|     Admin: Yuxiang Mao (project admininistrator)                          |
|   Authors: Yuxiang Mao (Uniwits) contact@uniwits.com                      |
|   Founder: Yuxiang Mao                                                    |
| Copyright (c) 2010-2012, Yuxiang Mao. All Rights Reserved.                |
| ------------------------------------------------------------------------- |
|   License: Distributed under Uniwits Shareware License (USL)              |
|            http://www.uniwits.com/licenses/shareware/                     |
| This program is distributed as a part of software provided by Uniwits     |
| System WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                      |
| ------------------------------------------------------------------------- |
*/ function uniwits_time($unix_timestamp=null,$seconds_bias='0') { if (!$unix_timestamp) $unix_timestamp=time(); $seconds=datetime_to_seconds('1970-01-01 00:00:00')+$unix_timestamp; if (!empty($seconds_bias)) $seconds+=$seconds_bias; return $seconds; } function datetime_to_seconds($datetime=null,$seconds_bias='0') { if (!$datetime) return uniwits_time(null,$seconds_bias); $normalyearmonthbase=array(0,31,59,90,120,151,181,212,243,273,304,334); $leapyearmonthbase =array(0,31,60,91,121,152,182,213,244,274,305,335); list($date,$time)=explode(' ',$datetime); list($year,$month,$day)=explode('-',$date); list($hour,$minute,$second)=explode(':',$time); if ($date) { $year+=floor(($month-1)/12); $month=($month-1)%12+1; $years400=ceil($year/400); $years100=ceil($year/100); $years4=ceil($year/4); $leapyearcount=$years4-$years100+$years400; $seconds=$year*31536000; $seconds+=$leapyearcount*86400; $isleap=$year%100==0 || ( $year%100!=0 && $year%4==0 ); if ($isleap) $seconds+=$leapyearmonthbase[$month-1]*24*3600; else $seconds+=$normalyearmonthbase[$month-1]*24*3600; $seconds+=($day-1)*24*3600; } else $seconds='0'; $seconds+=$hour*3600+$minute*60+$second; $seconds-=$seconds_bias; return $seconds; } function seconds_to_datetime($seconds=null,$seconds_bias='0') { if (!$seconds) $seconds=uniwits_time(null); $seconds+=$seconds_bias; $secondsinday=fmod($seconds,24*3600); $days=$seconds/(24*3600); $years400=ceil($days/146097); $nonleapdays=$days-$years400; $years100=ceil($nonleapdays/36524); $nonleapdays+=$years100; $years4=ceil($nonleapdays/1461); $nonleapdays-=$years4; $year=floor($nonleapdays/365); $isleap=$year%400==0 || ( $year%100!=0 && $year%4==0 ); $yearbaseseconds=datetime_to_seconds(sprintf('%04d-01-01 00:00:00',$year)); $yearbasedays=floor($yearbaseseconds/(24*3600)); $daysinyear=$days-$yearbasedays; if ($isleap) $yearmonthbase=array(0,31,60,91,121,152,182,213,244,274,305,335); else $yearmonthbase=array(0,31,59,90,120,151,181,212,243,273,304,334); for ($monthidx=0;$monthidx<11;$monthidx++) if ($daysinyear<$yearmonthbase[$monthidx+1]) break; $month=$monthidx+1; $day=($daysinyear-$yearmonthbase[$monthidx])+1; $hour=floor($secondsinday/3600); $secrest=$secondsinday%3600; $minute=floor($secrest/60); $second=$secrest%60; return sprintf('%04d-%02d-%02d %02d:%02d:%02d',$year,$month,$day,$hour,$minute,$second); } function split_datetime($datetime,$seconds_bias='0') { if ($datetime && !empty($seconds_bias)) { $seconds=datetime_to_seconds($datetime); $datetime=seconds_to_datetime($seconds,$seconds_bias); } list($date,$time)=explode(' ',$datetime); list($year,$month,$day)=explode('-',$date); list($hour,$minute,$second)=explode(':',$time); return array( 'year'=>$year, 'month'=>$month, 'day'=>$day, 'hour'=>$hour, 'minute'=>$minute, 'second'=>$second ); } function datetime_datepart($datetime,$seconds_bias='0') { if (!empty($seconds_bias)) $datetime=bias_datetime($datetime,$seconds_bias); list($date,$time)=explode(' ',$datetime); return $date; } function datetime_timepart($datetime,$seconds_bias='0') { if (!empty($seconds_bias)) $datetime=bias_datetime($datetime,$seconds_bias); list($date,$time)=explode(' ',$datetime); return $time; } function combine_datetime($parts,$seconds_bias='0',$zerodefault=true) { $fields=array( 'year'=>'', 'month'=>'', 'day'=>'', 'hour'=>'', 'minute'=>'', 'second'=>'' ); foreach ($fields as $k=>&$v) { $v=''.$parts[$k]; if (!ctype_digit($v)) { if ($zerodefault) $v=$k=='year'?'0000':'00'; else return false; } } $datetime=$fields['year'].'-'.$fields['month'].'-'.$fields['day'].' ' .$fields['hour'].':'.$fields['minute'].':'.$fields['second']; $seconds=datetime_to_seconds($datetime,$seconds_bias); $datetime=seconds_to_datetime($seconds); return $datetime; } function seconds_to_date($seconds=null,$seconds_bias='0') { $datetime=seconds_to_datetime($seconds,$seconds_bias); list($date,$time)=explode(' ',$datetime); return $date; } function seconds_to_time($seconds=null,$seconds_bias='0') { $datetime=seconds_to_datetime($seconds,$seconds_bias); list($date,$time)=explode(' ',$datetime); return $time; } function seconds_set_time_in_day($seconds,$seconds_in_day,$seconds_bias='0') { $seconds+=$seconds_bias; $days=floor($seconds/(24*3600)); $daybound=$days*24*3600; $donetime=$daybound+$seconds_in_day; return $donetime; } function seconds_get_time_in_day($seconds,$seconds_bias='0') { $seconds+=$seconds_bias; return $seconds*24*3600; } function seconds_to_weekday($seconds,$seconds_bias='0') { $map=array(6,0,1,2,3,4,5); return $map[floor(($seconds+$seconds_bias)/(24*3600))%7]; } function datetime_to_weekday($datetime,$seconds_bias='0') { $seconds=datetime_to_seconds($datetime); return seconds_to_weekday($seconds,$seconds_bias); } function bias_datetime($datetime,$seconds_bias) { $seconds=datetime_to_seconds($datetime); return seconds_to_datetime($seconds,$seconds_bias); } function datetime_same_date($datetime1,$datetime2,$seconds_bias) { return datetime_datepart($datetime1,$seconds_bias)==datetime_datepart($datetime2,$seconds_bias); } ?>