<?php
/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable 
 *              to obtain it through the world-wide-web, please send a note to 
 *              license@php.net so we can mail you a copy immediately.  
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @authoe     Kazuo Ide [K&X inc.] UsagiProject
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/02/17] Ver1.1.0Nighty package
 * ======================================================================== 
 */

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8"/>
<title>Sample</title>
<script src="../googlemapsapi.php" type="text/javascript"></script>

<script type="text/javascript">

<?php
echo 'var latp = '.$_GET['lat'].';';
echo 'var lngp = '.$_GET['lon'].';';
echo 'var zmp = '.$_GET['zoom'].';';
echo 'var tp = '.$_GET['type'].';';
?>

var map;
var marker;
var point;

//ストリートビュー設定
var maxdiv = document.createElement('div');
maxdiv.style.width = "300px";
maxdiv.style.height = "200px";
var svp = new GStreetviewPanorama(maxdiv);
var svc = new GStreetviewClient();
var svm = null;
var before_drag;
var hlng;
var svicon = new GIcon();
svicon.image = "http://maps.google.co.jp/intl/ja_jp/mapfiles/cb/man_arrow-0.png";
svicon.transparent = "http://maps.google.com/intl/en_us/mapfiles/cb/man-pick.png";
svicon.iconSize = new GSize(49,52);
svicon.iconAnchor = new GPoint(25,35);
svicon.imageMap = [28,4, 28,35, 18,35, 18,4];

window.onload = function() {

    map = new GMap2(document.getElementById("gmap"));
    point = new GLatLng(latp,lngp);
    map.setCenter(new GLatLng(latp,lngp),zmp);
    map.setMapType(map.getMapTypes()[tp]);
    map.enableDoubleClickZoom();
    map.enableContinuousZoom();
    map.addControl(new GMapTypeControl());
    map.addControl(new GSmallMapControl());
    map.addControl(new GScaleControl());
    marker = new GMarker(point);
    map.addOverlay(marker);
    svc.getNearestPanorama(new GLatLng(latp, lngp), svcheckcallback);

    GEvent.addListener(
        map,
        "infowindowclose",
        function() {
            if(svm != null) {
                map.removeOverlay(svm);
                svm = null;
            }
            //IEでのエラー回避のためダミーエレメントを設置
            if(document.getElementById("panoflash1") == null) {
                var panoflash1 = document.createElement('div');
                panoflash1.id = "panoflash1";
                panoflash1.style.display = "none";
                document.getElementsByTagName("body").item(0).appendChild(panoflash1);
                document.getElementById("panoflash1").SetReturnValue = function(){};
            }
        }
    );

    GEvent.addListener(
        svp,
        "initialized",
        function(loc) {
            if(svm != null) {
                map.removeOverlay(svm);
                svm = null;
            }
            if(svm == null) {
                svm = new GMarker(loc.latlng,{icon:svicon, draggable:true, dragCrossMove:true});
                map.addOverlay(svm);
                addDragEvent();
            }
        }
    );

    GEvent.addListener(
        svp,
        "yawchanged",
        function(yaw) {
            var dir = Math.round(yaw/22.5);
            svicon.image = "http://maps.google.co.jp/intl/ja_jp/mapfiles/cb/man_arrow-" + dir + ".png";
            if(svm != null) {
                svm.setImage(svicon.image);
            }
        }
    );
}

function svcheckcallback(d) {
    if(d.code == 200) {
        map.addOverlay(new GStreetviewOverlay());
        GEvent.addListener(
            marker,
            "click",
            function() {
                marker.openInfoWindowHtml(maxdiv);
                maxdiv.innerHTML = '<div style="padding:5px;text-align:center"><img src="../skin/default/img/loading.gif"></div>';
                if(document.getElementById('panoflash1')) {
                    document.getElementsByTagName("body").item(0).removeChild(document.getElementById('panoflash1'));
                }
                svc.getNearestPanorama(new GLatLng(latp, lngp), svccallback);
            }
        );
    }
}

//投稿位置情報に最も近い地点をインフォウィンドウへ表示・マンマーカーをプロット
function svccallback(d) {
    if(d.code == 200) {
        svp.setLocationAndPOV(d.location.latlng);
        if(svm != null) {
            map.removeOverlay(svm);
            svm = null;
        }
    	if(svm == null) {
            svm = new GMarker(d.location.latlng,{icon:svicon, draggable:true, dragCrossMove:true});
            map.addOverlay(svm);
            addDragEvent();
        }
    } else {
        if(svm != null) {
            map.removeOverlay(svm);
            svm = null;
        }
    	if(svm == null) {
            svm = new GMarker(before_drag,{icon:svicon, draggable:true, dragCrossMove:true});
            map.addOverlay(svm);
            addDragEvent();
        }
    }
}

//ドラッグイベント登録
function addDragEvent() {
    GEvent.addListener(
        svm,
        "dragstart",
        function() {
            before_drag = svm.getPoint();
            svicon.image = "http://maps.google.co.jp/intl/ja_jp/mapfiles/cb/man-0.png";
	        if(svm != null) {
                svm.setImage(svicon.image);
            }
        }
    );
    GEvent.addListener(
        svm,
        "drag",
        function() {
            if (!hlng || hlng < svm.getLatLng().lng()) {
                svicon.image = "http://www.google.co.jp/intl/ja_jp/mapfiles/cb/man_fly_right.png";
    	        if(svm != null) {
                    svm.setImage(svicon.image);
                 }
            } else if (hlng > svm.getLatLng().lng()) {
                svicon.image = "http://www.google.co.jp/intl/ja_jp/mapfiles/cb/man_fly_left.png";
    	        if(svm != null) {
                    svm.setImage(svicon.image);
                }
            }
            hlng = svm.getLatLng().lng();
        }
    );
    GEvent.addListener(
        svm,
        "dragend",
        function() {
            svicon.image = "http://maps.google.co.jp/intl/ja_jp/mapfiles/cb/man_arrow-0.png";
	        if(svm != null) {
                svm.setImage(svicon.image);
            }
            svc.getNearestPanorama(svm.getPoint(), svccallback);
        }
    );
}

</script>

<style type="text/css">
body {
    margin: 0px ;
    padding: 0px ;
}
</style>
</head>
<body onunload="GUnload()">
<div id="gmap" style="width: 100%; height: 400px"></div>
</body>
</html>
