<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable
 *              to obtain it through the world-wide-web, please send a note to
 *              license@php.net so we can mail you a copy immediately.
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/02/17] Ver1.1.0Nighty package
 * ========================================================================
 */

/**
 * OpenPNE
 * @copyright 2005-2006 OpenPNE Project
 * @link      http://www.tejimaya.com/openpne.shtml
 *
 */

class pc_page_c_event_write_confirm extends OpenPNE_Action
{
    function execute($requests)
    {
        $u = $GLOBALS['AUTH']->uid();

        // --- リクエスト変数
        $c_commu_topic_id = $requests['target_c_commu_topic_id'];
        $body = $requests['body'];
        $button = $requests['button'];
        // ----------
        $upfile_obj1 = $_FILES['image_filename1'];
        $upfile_obj2 = $_FILES['image_filename2'];
        $upfile_obj3 = $_FILES['image_filename3'];

        $c_topic = c_event_detail_c_topic4c_commu_topic_id($c_commu_topic_id);
        $c_commu_id = $c_topic['c_commu_id'];

        //--- 権限チェック
        if (!p_common_is_c_commu_view4c_commu_idAc_member_id($c_commu_id, $u)) {
            handle_kengen_error();
        }
        //---


        //エラーチェック
        $err_msg = array();
        if (trim($body) == '')
        {
            $err_msg[] = '本文を入力してください';
        }
        if ($upfile_obj1['error'] !== UPLOAD_ERR_NO_FILE && ! empty($upfile_obj1))
        {
            if ( ! ($image = t_check_image($upfile_obj1)))
            {
                $err_msg[] = '画像1は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }
        if ($upfile_obj2['error'] !== UPLOAD_ERR_NO_FILE && ! empty($upfile_obj2))
        {
            if ( ! ($image = t_check_image($upfile_obj2)))
            {
                $err_msg[] = '画像2は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }
        if ($upfile_obj3['error'] !== UPLOAD_ERR_NO_FILE && ! empty($upfile_obj3))
        {
            if ( ! ($image = t_check_image($upfile_obj3)))
            {
                $err_msg[] = '画像3は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }

        if ($err_msg) {
            $_REQUEST['err_msg'] = $err_msg;
            $_REQUEST['body'] = $body;
            openpne_forward('pc', 'page', "c_event_detail");
            exit;
        }

        $sessid = session_id();
        t_image_clear_tmp($sessid);
        $tmpfile1 = t_image_save2tmp($upfile_obj1, $sessid, "tc_1");
        $tmpfile2 = t_image_save2tmp($upfile_obj2, $sessid, "tc_2");
        $tmpfile3 = t_image_save2tmp($upfile_obj3, $sessid, "tc_3");

        $this->set('inc_navi', fetch_inc_navi("c", $c_commu_id));
        $event_write['target_c_commu_id'] = $c_commu_id;
        $event_write['target_c_commu_topic_id'] = $c_commu_topic_id;
        $event_write['body'] = $body;
        $event_write['image_filename1_tmpfile'] = $tmpfile1;
        $event_write['image_filename2_tmpfile'] = $tmpfile2;
        $event_write['image_filename3_tmpfile'] = $tmpfile3;
        $event_write['image_filename1'] = $upfile_obj1["name"];
        $event_write['image_filename2'] = $upfile_obj2["name"];
        $event_write['image_filename3'] = $upfile_obj3["name"];

        if ($button == "イベントに参加する") {
            $event_write['add_event_member'] = 1;
        } elseif ($button == "参加をキャンセルする") {
            $event_write['add_event_member'] = -1;
        }

        $this->set('event_write', $event_write);
        return 'success';
    }
}

?>
