/*
 * Decompiled with CFR 0.152.
 */
package saccubus.net;

import java.util.Arrays;
import saccubus.net.Path;

public class BrowserInfo {
    private BrowserCookieKind validBrowser = BrowserCookieKind.NONE;
    private static final String NICOVIDEO_URL = "http://www.nicovideo.jp";

    public String getBrowserName() {
        if (this.validBrowser == BrowserCookieKind.NONE) {
            return "\u3055\u304d\u3085\u3070\u3059";
        }
        if (this.validBrowser == BrowserCookieKind.MSIE) {
            return "Internet Exploror";
        }
        return this.validBrowser.toString();
    }

    public String getUserSession(BrowserCookieKind browserKind) {
        String user_session = "";
        switch (browserKind) {
            case IE6: {
                user_session = this.GetUserSessionFromIE6(NICOVIDEO_URL);
                break;
            }
            case MSIE: {
                user_session = this.GetUserSessionFromMSIE();
                break;
            }
            case Firefox: {
                user_session = this.GetUserSessionFromFilefox4();
                if (!user_session.isEmpty()) break;
            }
            case Firefox3: {
                user_session = this.GetUserSessionFromFilefox3();
                break;
            }
            case Chrome: {
                user_session = this.GetUserSesionChrome();
                break;
            }
            case Opera: {
                user_session = this.GetUserSessionOpera();
            }
        }
        if (!user_session.isEmpty()) {
            this.validBrowser = browserKind;
        }
        return user_session;
    }

    private String GetUserSessionFromFilefox3() {
        String sqlist_filename;
        String user_session;
        block6: {
            String app_dir;
            block5: {
                user_session = "";
                try {
                    app_dir = System.getenv("APPDATA");
                    if (app_dir != null && !app_dir.isEmpty()) break block5;
                    return "";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return user_session;
                }
            }
            sqlist_filename = String.valueOf(app_dir) + "\\Mozilla\\Firefox\\Profiles\\cookies.sqlite";
            if (Path.isFile(sqlist_filename)) break block6;
            return "";
        }
        String dataStr = Path.ReadAllText(sqlist_filename, "US-ASCII");
        user_session = this.CutUserSession(dataStr);
        if (!user_session.isEmpty()) {
            System.out.println("Found cookie in " + sqlist_filename.replace("\\", "/"));
        }
        return user_session;
    }

    private String GetUserSessionFromFilefox4() {
        String app_dir;
        String user_session;
        block5: {
            user_session = "";
            app_dir = System.getenv("APPDATA");
            if (app_dir != null && !app_dir.isEmpty()) break block5;
            return "";
        }
        try {
            String[] userLists;
            String[] stringArray = userLists = Path.GetFiles(String.valueOf(app_dir) + "\\Mozilla\\Firefox\\Profiles\\");
            int n = userLists.length;
            int n2 = 0;
            while (n2 < n) {
                String dataStr;
                String user_dir = stringArray[n2];
                String sqlist_filename = String.valueOf(user_dir) + "\\cookies.sqlite";
                if (Path.isFile(sqlist_filename) && !(user_session = this.CutUserSession(dataStr = Path.ReadAllText(sqlist_filename, "US-ASCII"))).isEmpty()) {
                    System.out.println("Found cookie in " + sqlist_filename.replace("\\", "/"));
                    return user_session;
                }
                ++n2;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String GetUserSessionFromIE6(String url) {
        return this.CutUserSession(this.GetCookieFromIE6(url));
    }

    private String GetCookieFromIE6(String url) {
        int size = 4096;
        byte[] dummy = new byte[size];
        Arrays.fill(dummy, (byte)32);
        StringBuilder buff = new StringBuilder(new String(dummy));
        int[] ref_size = new int[]{size};
        return buff.toString().replace(';', ',');
    }

    private String GetUserSessionFromMSIE() {
        String user_session = "";
        String profile_dir = System.getenv("USERPROFILE");
        if (profile_dir == null || profile_dir.isEmpty()) {
            return "";
        }
        String search_dir = String.valueOf(profile_dir) + "\\AppData\\Roaming\\Microsoft\\Windows\\Cookies\\Low\\";
        user_session = this.GetUserSessionFromDirectory(search_dir);
        if (user_session.isEmpty()) {
            search_dir = String.valueOf(profile_dir) + "\\AppData\\Roaming\\Microsoft\\Windows\\Cookies\\";
            user_session = this.GetUserSessionFromDirectory(search_dir);
        }
        if (user_session.isEmpty()) {
            search_dir = String.valueOf(profile_dir) + "\\Cookies\\";
            user_session = this.GetUserSessionFromDirectory(search_dir);
        }
        return user_session;
    }

    private String GetUserSessionFromDirectory(String dir_name) {
        String user_session = "";
        if (Path.Exists(dir_name)) {
            try {
                String[] files;
                String[] stringArray = files = Path.GetFiles(dir_name);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String fullname = stringArray[n2];
                    user_session = this.CutUserSession(Path.ReadAllText(fullname, "MS932"));
                    if (!user_session.isEmpty()) {
                        System.out.println("Found cookie in " + fullname.replace("\\", "/"));
                        return user_session;
                    }
                    ++n2;
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private String GetUserSesionChrome() {
        String user_session = "";
        String cookie_file = "";
        try {
            String local_Appdir = System.getenv("LOCALAPPDATA");
            if (local_Appdir != null && !local_Appdir.isEmpty() && Path.isFile(cookie_file = String.valueOf(local_Appdir) + "\\Google\\Chrome\\User Data\\Default\\Cookies")) {
                String dataStr = Path.ReadAllText(cookie_file, "UTF-8");
                String string = user_session = this.CutUserSession(dataStr);
                return string;
            }
            String profile_dir = System.getenv("USERPROFILE");
            if (profile_dir != null && !profile_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(profile_dir) + "\\Local Settings\\Application Data\\Google\\Chrome\\User Data\\Default\\Cookies")) {
                String dataStr = Path.ReadAllText(cookie_file, "UTF-8");
                String string = user_session = this.CutUserSession(dataStr);
                return string;
            }
            String app_dir = System.getenv("APPDATA");
            if (app_dir != null && !app_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(app_dir) + "\\Google\\Chrome\\User Data\\Default\\Cookies")) {
                String dataStr = Path.ReadAllText(cookie_file, "UTF-8");
                String string = user_session = this.CutUserSession(dataStr);
                return string;
            }
            String string = user_session;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = user_session;
            return string;
        }
        finally {
            if (!user_session.isEmpty()) {
                System.out.println("Found cookie in " + cookie_file.replace("\\", "/"));
            }
        }
    }

    private String GetUserSessionOpera() {
        String user_session = "";
        String cookie_file = "";
        try {
            String dataStr;
            String app_dir = System.getenv("APPDATA");
            if (app_dir != null && !app_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(app_dir) + "\\Opera\\Opera\\cookies4.dat") && !(user_session = this.CutUserSession(dataStr = Path.ReadAllText(cookie_file, "UTF-8"))).isEmpty()) {
                System.out.println("Found cookie in " + cookie_file.replace("\\", "/"));
                return user_session;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String CutUserSession(String str) {
        int start = str.indexOf("user_session_");
        if (start >= 0) {
            int index = start + "user_session_".length();
            while (index < str.length() && ('0' <= str.charAt(index) && str.charAt(index) <= '9' || str.charAt(index) == '_')) {
                ++index;
            }
            return str.substring(start, index);
        }
        return "";
    }

    public static enum BrowserCookieKind {
        NONE,
        MSIE,
        IE6,
        Firefox3,
        Firefox,
        Chrome,
        Opera;

    }
}

