/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.routine_work.simple_battery_logger.util;

import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.routine_work.simple_battery_logger.db.DBConstants;
import org.routine_work.simple_battery_logger.service.CsvFileExporter;

/**
 *
 * @author sawai
 */
public class CsvFilenameFilter implements FilenameFilter
{
	private final SimpleDateFormat dateFormat = new SimpleDateFormat(DBConstants.DATE_FORMAT);

	public boolean accept(File dir, String name)
	{
		boolean result = false;

		if (name.endsWith(CsvFileExporter.CSV_FILE_SUFFIX))
		{
			String basename = name.substring(0, name.length() - 4);
			try
			{
				dateFormat.parse(basename);
				result = true;
			}
			catch (ParseException ex)
			{
			}
		}

		return result;
	}
}
