/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.routine_work.simple_battery_logger.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import org.routine_work.simple_battery_logger.R;

/**
 *
 * @author sawai
 */
public class PreferenceUtils
{

	private static final String LOG_TAG = "simple-battery-logger";

	public static boolean isLoggingServiceEnabled(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.logging_service_enabled_key);
		boolean defaultValue = resources.getBoolean(R.bool.logging_service_enabled_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "loggingServiceEnabled => " + value);
		return value;
	}

	public static boolean isIgnoreVoltageChangeOnly(Context context)
	{

		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.ignore_voltage_change_only_key);
		boolean defaultValue = resources.getBoolean(R.bool.ignore_voltage_change_only_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "ignoreVoltageChangeOnly => " + value);
		return value;
	}

	public static int getDataKeepingPeriod(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.data_keeping_period_key);
		String defaultValue = resources.getString(R.string.data_keeping_period_default_value);
		String valueString = sharedPreferences.getString(key, defaultValue);
		int dataKeepingPeriod = Integer.parseInt(valueString);

		Log.v(LOG_TAG, "dataKeepingPeriod => " + dataKeepingPeriod);
		return dataKeepingPeriod;
	}

	public static boolean isCsvAutoExportEnabled(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_auto_export_enabled_key);
		boolean defaultValue = resources.getBoolean(R.bool.csv_auto_export_enabled_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "csvAutoExportEnabled => " + value);
		return value;
	}

	public static String getCsvSortOrder(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_sort_order_key);
		String defaultValue = resources.getString(R.string.csv_sort_order_default_value);
		String value = sharedPreferences.getString(key, defaultValue);

		Log.v(LOG_TAG, "csvSortOrder => " + value);
		return value;
	}

	public static String getCsvExportDirectoryName(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_export_directory_key);
		String defaultValue = resources.getString(R.string.csv_export_directory_default_value);
		String value = sharedPreferences.getString(key, defaultValue);

		Log.v(LOG_TAG, "csvExportDirectory => " + value);
		return value;
	}
}
