
//-----------------------------
// Class c2scheduler
// Version : 0.5.1
// Auther : hitch
// created at 2012/09/09
// last updated at 2012/12/14
// Licensed under both MIT and GPL licenses
//-----------------------------

(function($) {

	// プラグインを設定 //
	// 「c2scheduler」はプラグイン名。
	//外部からアクセス可能なメソッドはjQuery.fnにアタッチする。最後のセミコロンは必要
	$.fn.c2scheduler = function(options){
		
		//テンプレートHTML読み込み入れ替え
		load_html_sync(this.find('td.c2-header-left'),'./jquery-c2scheduler/parts_html/c2_scheduler_fmt1.html');
		load_html_sync(this.find('td.c2-header-right'),'./jquery-c2scheduler/parts_html/c2_scheduler_fmt2.html');
		load_html_sync(this.find('div#c2scd_contents'),'./jquery-c2scheduler/parts_html/c2_scheduler_fmt3.html');

		var opt={};//引数optionsを格納するハッシュ

		//optのデフォルト値
		var opt_defaults={
				//container_id: "#scheduler_body",
				current_date: function(){//yyyymmddの文字列。"20120707"。デフォルトは本日。
						var today = new Date();
						return String(today.getFullYear) + ('00' + (today.getMonth+1)).slice(-2) + ('00' + (today.getDate)).slice(-2)//月は0～11なのでプラス1。
					}
				,width: 976 //スケジューラ中身（タイムライン）の幅。表示枠幅より大きい値の場合は横スクロールになる。
				,max_height: 250//スケジューラ表示枠の高さのMAX値。行が多くてこの高さ内に表示できない場合は縦スクロールになる。
				,label_col_width: 256
			};

		//引数optionsの中のNULLだった値のみをデフォルト値で上書き。
		opt = $.extend({},opt_defaults,options || {});//defaults自体も上書きされないよう、第一引数は{}にする。「 || {}」はoptionsのNUll時対策。
		
		//var xxx4=opt.current_date;
		//alert("first:" + opt.current_date);//スケ→カレ→スケに戻ってきた時、ここでは値正しい。しかしもう一度カレへ行く時、リンク処理の場所では値が反映されていない！
		
		$.fn.c2scheduler.config = $.extend(conf_defaults,$.fn.c2scheduler.set_config || {});//この行無意味？
		
		//セレクタをスケカレ間で受け渡すために格納しておく。
		$.fn.c2scheduler.config["selector"]=this.selector;
		//再度戻ってきた時にnullかどうか判断するため保存。
		$.fn.c2scheduler.config["option_values"]=options;
		
		//省略参照のため変数へ
		var conf = $.fn.c2scheduler.config;
		$.fn.c2scheduler.tgt = this;//calenderに渡すためにターゲットオブジェクトをここに格納しておく。
		//var tgt = this;//イベント設定内で参照するためにここで変数へ格納しておく。
		var tgt = $.fn.c2scheduler.tgt;//イベント設定内で参照するためにここで変数へ格納しておく。
		
		
		this.find('.c2-title.label.left').text(conf.title_label);
		
		init(this,opt,conf,cal_conf);
		
		//alert("2nd:" + opt.current_date);
		
		//=====イベント設定=====
		//カレンダーとの切り替え後も残るように、すべてliveで設定。
		//event_ready_flgでschedulerが実行されるたびにイベント設定が重複しないよう制御。
		//その代わり、2回目以降に呼ばれた時は変数の値が更新されないものがある（opt.current_date）。
		if ( ! cal_conf.event_ready_flg){
			
			//alert("3nd:" + opt.current_date);
			
			//ツールチップ bindは(ここが実行されるready時に)存在する要素にしかイベント設定できないのでlive。
			//移動時間のtimeframeは除外する。
			//クリックの場合はDOM要素生成時にカーソル変えるようにしておく。
			if (conf.tooltip_trigger == 'click'){//liveは他のメソッドを挟むと（.notなど）、うまくいかないらしい。
				this.find('div.c2scd_timeframe.open:not(".' + conf.mb_tf_name + '")').live('click', function(){//OK
				//this.find('div.c2scd_timeframe').not('.type90').live('click', function(){
					if($('body div.c2scd_tooltip#tooltip_' + $(this).attr('id')).size() >0 ){
						removeTooltip();
					}else{
						createTooltip(this,conf);
					}
				});
				$('body div.c2scd_tooltip').live('click', function(){//tooltipはbody内
					removeTooltip();
				})//ツールチップはまだこの時点では存在していないので、ここでカーソル変えられない。生成時に変える。
			}else if(conf.tooltip_trigger == 'mouseenter'){
				this.find('div.c2scd_timeframe.open:not(".' + conf.mb_tf_name + '")').live('mouseenter', function(){
					createTooltip(this,conf);
				});

				this.find('div.c2scd_timeframe.open').live('mouseleave', function(){
					removeTooltip();
				});
			}
			
			//スケールバー（縦）、エントリ名（横）スクロール追随固定
			//エントリ名列はテーブルの一部なので、列幅分の幅ゴーストDIVにテーブル複製して重ねている。
			this.find('div#c2scd_contents').scroll(function(){
			//this.find('div#c2scd_contents').live('scroll', function(){//これだと効かない！なぜ？
				//縦スクロール
				$('div#c2scd_header').css({'top': $(this).scrollTop()});
				//横スクロール
				$('div.c2scd_canvas_fixed_ghost').css({'left': $(this).scrollLeft()});
				$('div.header_date_bg').css({'left': $(this).scrollLeft()});
				
			});
			
			//ウインドウリサイズ。横幅
			$(window).resize(function(){
			//this.find('div#c2scd_contents').live('scroll', function(){//これだと効かない！なぜ？
				
				tgt.find('div#c2scd_contents').outerWidth(tgt.outerWidth());//幅を親DIVに合わせる。
				
				//$('#scheduler_body div#c2scd_contents').outerWidth($('#scheduler_body').outerWidth());//幅を親DIVに合わせる。
				//このイベントはWindowのイベントなのでスケとカレで分けられない。
				//以下はカレンダーの時に行うとNG
				if(tgt.find('table.timeline_data').length > 0){//スケジューラモードかどうかの判別(ゴースト含めて2つ存在する。)
					redraw_scheduler_byMode({},tgt,opt,conf,cal_conf);//第一引数のmode_confは不要。
				}
			});
			
			//====上部ボタン====
			//マウスダウン
			//this.find('.c2-button').mousedown(function(){
			this.find('.c2-button').live('mousedown', function(){
				$(this).addClass('c2-state-down');
			});
			//マウスアップ
			//this.find('.c2-button').mouseup(function(e){
			this.find('.c2-button').live('mouseup', function(){
				$(this).removeClass('c2-state-down');
				//$('.debug').html('x:' + e.pageX + 'y:' + e.pageY);
			});
			
			//e.pageX,e.pageY・・・ドキュメント内相対座標 （スクロールしても変わらない）
			//e.clientX,e.clientY・・・ウィンドウ内の座標（スクロールすると変わる）
			//e.offsetX,e.offsetY・・・イベントターゲット（クリックした要素)上の座標

			//マウスクリック
			//ボタンによる日付変更
			//this.find('.c2-button.c2-button-prev').click(function(){
			this.find('.c2-button.c2-button-prev.schd').live('click', function(){
				var tgt_date = cal_conf.startingDate;
				tgt_date.setDate(tgt_date.getDate() -1);
				redraw_scheduler_at(tgt_date,tgt,opt,conf,cal_conf);
			});
			//this.find('.c2-button.c2-button-next').click(function(){
			this.find('.c2-button.c2-button-next.schd').live('click', function(){
				var tgt_date = cal_conf.startingDate;
				tgt_date.setDate(tgt_date.getDate() +1);
				redraw_scheduler_at(tgt_date,tgt,opt,conf,cal_conf);
			});
			//this.find('.c2-button.c2-button-today').click(function(){
			this.find('.c2-button.c2-button-today.schd').live('click', function(){
				var tgt_date = new Date();
				tgt_date.setHours(0, 0, 0, 0);//一応時刻をクリアしておく。
				redraw_scheduler_at(tgt_date,tgt,opt,conf,cal_conf);
			});
			//モード切替
			//this.find('.c2-button.c2-button-mode1').click(function(){
			this.find('.c2-button.c2-button-mode1').live('click', function(){
				$('.c2-header-right .c2-button').removeClass('c2-state-active');//一旦ボタングループすべてからactive削除
				$(this).addClass('c2-state-active');//active追加
				redraw_scheduler_byMode($.fn.c2scheduler.set_mode1_config,tgt,opt,conf,cal_conf);
			});
			//this.find('.c2-button.c2-button-mode2').click(function(){
			this.find('.c2-button.c2-button-mode2').live('click', function(){
					$('.c2-header-right .c2-button').removeClass('c2-state-active');//一旦ボタングループすべてからactive削除
				$(this).addClass('c2-state-active');//active追加
				redraw_scheduler_byMode($.fn.c2scheduler.set_mode2_config,tgt,opt,conf,cal_conf);
			});
			//this.find('.c2-button.c2-button-mode3').click(function(){
			this.find('.c2-button.c2-button-mode3').live('click', function(){
					$('.c2-header-right .c2-button').removeClass('c2-state-active');//一旦ボタングループすべてからactive削除
				$(this).addClass('c2-state-active');//active追加
				redraw_scheduler_byMode($.fn.c2scheduler.set_mode3_config,tgt,opt,conf,cal_conf);
			});
			
			
			//c2calendarへのリンク（呼び出し）
			if (conf.calendar_link_flg){
				this.find('.c2-button.c2-button-mode_month').live('click', function(){
					//alert("here:" + opt.current_date);
					//alert($.formatDate(cal_conf.startingDate,'yyyyMMdd'));
					//ここでのopt.current_dateは一番最初にc2schedulerを実行した時の値のままになっている！
					//カレに行ってスケに戻ってきた時の再実行後のopt.current_dateはここ（のスコープ？）では反映されていない(値が異なる)！クロージャになってる？
					//とりあえず応急処置でcal_conf.startingDateからopt.current_dateを最新値に修正する。
					opt.current_date=$.formatDate(cal_conf.startingDate,'yyyyMMdd');
					changeTo_c2calendar( opt.current_date.slice(0,6) , 33);//division_idは仮
				});
			}else{
				this.find('.c2-button.c2-button-mode_month').hide();
				this.find('.c2-button.c2-button-mode3').addClass('c2-corner-right');
			}
			
			cal_conf.event_ready_flg = true;//イベント設定の完了済みフラグ。
		}
		
		return this;//メソッドチェーンを断ち切らないために、thisを返す。
	};///親ブロックここまで


	//config public 定義
	$.fn.c2scheduler.config ={};
	
	//$.fn.c2scheduler.configのデフォルト値
	var conf_defaults = {
		title_label:'Scheduler'//上部タイトル左端欄に表示する文言
		,selector: '#scheduler_body'//実行時にはoptionでもらうが、スケカレ間で渡すためにここに格納。
		,option_values:{}//最初のoption値を保存しておくため。
		,scale_step_minutes: 30
		,selecter_id: 16
		,range_start_no: 16
		,range_end_no: 40
		,min_width_to_time_labeling_only_at_flat: 50//100
		,disp_tooltip_duration: 45
		,entry_col_op_width: 25 //エントリ名右のアイコン用TD。0ならTD作成しない。
		//,mb_tf_type: 90 //移動時間のタイムフレームのクラスのtypeナンバー。"type●●"というクラスが追加される。
		,mb_tf_name: 'mobile' //移動時間のタイムフレームのクラスの名。指定クラスが追加される。
		,tooltip_trigger: 'click' //tooltipの表示トリガーイベント。'mouseenter' or 'click'
		,use_48clock: false //スケールバーに48時間表記（AM1時は25:00）を使用するか？デフォルトfalse。
		,use_strong_line: []//グリッド罫線に目立つ線を使用する時刻を「HH:MM」の文字列で指定(頭0埋め)。48時間表記かどうかはuse_48clock指定と合わせる。'24:00'は×。'00:00'を指定。0:00や午前午後の区切りで使用するのを想定。デフォルトなし。
		,load_y_entries_url:'./test_y_entries_data.xml' //y_entriesを読み込むxmlのURL。日付パラメータはオプションのcurrent_date
		,load_timeframes_url:'./test_timeframes_data.xml' //timeframesを読み込むxmlのURL。日付パラメータはオプションのcurrent_date
		,def_x_scroll_glidNo:0 //デフォルトの横スクロール位置。グリッド位置番号（1から）で指定。
		,use_scale_bar_date: false //スケールバーを2段表示で上に日付表示にするか
		,scale_bar_date_height:20//スケールバーを2段表示時の日付パートの高さ。
		,holidays:[]//祝日データ。デフォルトnull。
		,calendar_link_flg:true//c2calendarへのリンク（切り替え可）有無。デフォルトtrue。
		,cr_division_id:null//デフォルトnull。
		,load_required_flg:true//データの読み込みするか。デフォルトtrue。
		,scroll_inside_x_auto:false//スクロールの内側の幅を自動調整するか。
		,scroll_start_no: 16//スクロール時のデフォルト左端位置。単位グリッド番号（左から何番目）。scroll_inside_x_autoがtrueの時のみ有効。range_start_noとrange_end_noの間でないと×。
		,scroll_end_no: 40//スクロール時のデフォルト右端位置。単位グリッド番号（左から何番目）。scroll_inside_x_autoがtrueの時のみ有効。range_start_noとrange_end_noの間でないと×。
	};
	//モード1設定　00:00-24:00
	$.fn.c2scheduler.set_mode1_config = {
		scale_step_minutes: 60
		,range_start_no: 0
		,range_end_no: 24
		,use_48clock: false //スケールバーに48時間表記（AM1時は25:00）を使用するか？デフォルトfalse。
		,use_strong_line: ['12:00']//グリッド罫線に目立つ線を使用する時刻を「HH:MM」の文字列で指定(頭0埋め)。
		,def_x_scroll_glidNo:0 //デフォルトの横スクロール位置。グリッド位置番号（1から）で指定。未使用。
		,use_scale_bar_date: false //スケールバーを2段表示で上に日付表示にするか
		,scroll_inside_x_auto:false//スクロールの内側の幅を自動調整するか。
	};
	//モード2設定　08:00-18:00
	$.fn.c2scheduler.set_mode2_config = {
		scale_step_minutes: 30//スクロール固定なら30
		,range_start_no: 0//スクロール固定なら16
		,range_end_no: 48//スクロール固定なら36
		,use_48clock: false //スケールバーに48時間表記（AM1時は25:00）を使用するか？デフォルトfalse。
		,use_strong_line: ['12:00']//グリッド罫線に目立つ線を使用する時刻を「HH:MM」の文字列で指定(頭0埋め)。
		,def_x_scroll_glidNo:0 //デフォルトの横スクロール位置。グリッド位置番号（1から）で指定。未使用。
		,use_scale_bar_date: false //スケールバーを2段表示で上に日付表示にするか
		,scroll_inside_x_auto:true//スクロールの内側の幅を自動調整するか。
		,scroll_start_no: 16//スクロール時のデフォルト左端位置。単位グリッド番号（左から何番目）。scroll_inside_x_autoがtrueの時のみ有効。range_start_noとrange_end_noの間でないと×。
		,scroll_end_no: 36//スクロール時のデフォルト右端位置。単位グリッド番号（左から何番目）。scroll_inside_x_autoがtrueの時のみ有効。range_start_noとrange_end_noの間でないと×。
	};
	//モード3設定　00:00-24:00×3日
	$.fn.c2scheduler.set_mode3_config = {
		scale_step_minutes: 120
		,range_start_no: 0
		,range_end_no: 36
		,use_48clock: false //スケールバーに48時間表記（AM1時は25:00）を使用するか？デフォルトfalse。
		,use_strong_line: ['00:00','12:00']//グリッド罫線に目立つ線を使用する時刻を「HH:MM」の文字列で指定(頭0埋め)。
		,def_x_scroll_glidNo:0 //デフォルトの横スクロール位置。グリッド位置番号（1から）で指定。未使用。
		,use_scale_bar_date: true //スケールバーを2段表示で上に日付表示にするか
		,scroll_inside_x_auto:false//スクロールの内側の幅を自動調整するか。
	};

	//未使用。
	$.fn.c2scheduler.status = {
		flg_loaded_y_entries: false//ロード完了フラグ
		,flg_loaded_timeframes: false//ロード完了フラグ
	}

	//省略参照のため変数へ
	//var conf = $.fn.c2scheduler.config;

	var cal_conf ={};//private。計算結果の値を使いまわすために格納するハッシュ。configにまるっとハッシュをセットされてキーが消えないないようにconfigとは別ハッシュにしてprivateにしておく。
	//private
	function init(tgt,opt,conf,cal_conf) {

		//var conf = $.fn.c2scheduler.config;//記述簡略のため変数へ

		//処理が終わるまで一旦非表示して代わりにローディング画像を表示timeline_data
		tgt.find('div.c2scd_canvas table.timeline_data').hide().parent().prepend('<div id="loading"></div>');

		/*========サブ関数を実行==========*/
		
		get_style_conf_val(tgt,opt,conf,cal_conf);//サンプル行を一時的に加えてCSS数値を取得。
		
		var xxx2=opt.current_date
		
		adjust_conf_val(tgt,opt,conf,cal_conf);//設定値調整＆計算
		
		var xxx3=opt.current_date

		/* === 各種描画処理 === */
		draw_scale_bar(tgt,opt,conf,cal_conf);//スケールバー描画

		//tgt.find('div.c2scd_canvas table.timeline_data').delay(3000);
		
		if (conf.load_required_flg){
			//データロード処理&描画開始
			$.fn.c2scheduler.status.flg_loaded_y_entries = false;//現在未使用
			load_y_entries_data(conf.load_y_entries_url,opt.current_date, tgt, opt, conf, cal_conf);
		}else{
			
			//tgt.find('#c2scd_scale_bar_date').remove();//スケールバーDate削除
			//tgt.find('#c2scd_scale_bar').empty();//スケールバー中身削除
			//tgt.find('table.timeline_data tr').remove();//中身削除
			//処理が終わるまで一旦非表示して代わりにローディング画像を表示timeline_data
			//tgt.find('div.c2scd_canvas table.timeline_data').hide().parent().prepend('<div id="loading"></div>');
			// === 各種描画処理 ===
			draw_grid(tgt,opt,conf,cal_conf);//グリッド描画
			draw_timeframes(tgt,opt,conf,cal_conf);//タイムフレーム描画
			adjust_final(tgt,opt,conf,cal_conf);//最後の大きさ調整
			
		}
		
	};//end  init()
	
	//cr_dateObjで指定した日付で再描画。データロード・スタイル数値取得含まず（TFデータがなければTF描画されず）。
	//cr_dateObjはDateObj
	function redraw_scheduler_at(cr_dateObj,tgt,opt,conf,cal_conf) {
		opt.current_date = $.formatDate(cr_dateObj,'yyyyMMdd');
		
		tgt.find('#c2scd_scale_bar_date').remove();//スケールバーDate削除
		tgt.find('#c2scd_scale_bar').empty();//スケールバー中身削除
		tgt.find('table.timeline_data tr').remove();//中身削除
		//処理が終わるまで一旦非表示して代わりにローディング画像を表示timeline_data
		tgt.find('div.c2scd_canvas table.timeline_data').hide().parent().prepend('<div id="loading"></div>');
		adjust_conf_val(tgt,opt,conf,cal_conf);//設定値調整＆計算
		// === 各種描画処理 ===
		draw_scale_bar(tgt,opt,conf,cal_conf);//スケールバー描画
		draw_grid(tgt,opt,conf,cal_conf);//グリッド描画
		draw_timeframes(tgt,opt,conf,cal_conf);//タイムフレーム描画
		adjust_final(tgt,opt,conf,cal_conf);//最後の大きさ調整
		//デバッグ
		//alert($.formatDate(cal_conf.startingDate,'yyyyMMdd'));
	}
	
	//モード切替時の再描画。データロード・スタイル数値取得含まず。
	//mode_configの設定で再描画する。
	function redraw_scheduler_byMode(mode_config,tgt,opt,conf,cal_conf) {
		opt.current_date=$.formatDate(cal_conf.startingDate,'yyyyMMdd');
		
		$.fn.c2scheduler.config = $.extend($.fn.c2scheduler.config,mode_config);//左辺は第一引数と同じ。extendの第一引数は上書きされるので左辺は不要か？この行無意味？
		tgt.find('#c2scd_scale_bar_date').remove();//スケールバーDate削除
		tgt.find('#c2scd_scale_bar').empty();//スケールバー中身削除
		tgt.find('table.timeline_data tr').remove();//スケジューラ中身削除
		//処理が終わるまで一旦非表示して代わりにローディング画像を表示timeline_data
		tgt.find('div.c2scd_canvas table.timeline_data').hide().parent().prepend('<div id="loading"></div>');
		adjust_conf_val(tgt,opt,conf,cal_conf);//設定値調整＆計算
		// === 各種描画処理 ===
		draw_scale_bar(tgt,opt,conf,cal_conf);//スケールバー描画
		draw_grid(tgt,opt,conf,cal_conf);//グリッド描画
		draw_timeframes(tgt,opt,conf,cal_conf);//タイムフレーム描画
		adjust_final(tgt,opt,conf,cal_conf);//最後の大きさ調整
		
	}
	
	
	//timeline描画領域のtop・width・height
	//最後の配置・大きさ調整
	function adjust_final(tgt,opt,conf,cal_conf) {
		tgt.find('div.c2scd_canvas').outerWidth(cal_conf.contents_width)
			.css('top' , tgt.find('div#c2scd_header').outerHeight())
			.innerHeight(tgt.find('div.c2scd_canvas table.timeline_data').outerHeight());
		//固定用ゴーストの幅はエントリ名列に合わせる。それ以外は同じに。
		tgt.find('div.c2scd_canvas_fixed_ghost').outerWidth(cal_conf.set_label_col_width)
			.css('top' , tgt.find('div#c2scd_header').outerHeight())
			.innerHeight(tgt.find('div.c2scd_canvas table.timeline_data').outerHeight());
		//周辺領域
		var titleHeader_H = parseInt(tgt.find('table.c2-header').outerHeight()) || 10;//デバッグのために0ではなく10にしておく。
		var scaleHeader_H = parseInt(tgt.find('div#c2scd_header').outerHeight()) || 10;
		var canvas_H =  parseInt(tgt.find('div.c2scd_canvas').outerHeight()) || 10;
		var tmp_contents_H = scaleHeader_H + canvas_H + ((tgt.find('table.timeline_data').outerWidth() > tgt.outerWidth()) ? 17 : 0);//横スクロールバーがつく大きさなら、高さにスクロールバーの幅（17px）プラスする。
		var contents_H = (opt.max_height >= (titleHeader_H + tmp_contents_H)) ? tmp_contents_H : opt.max_height - titleHeader_H ;
		tgt.find('div#c2scd_contents').outerWidth(tgt.outerWidth()).outerHeight(contents_H);//幅調整&高さ調整。幅は親DIVに合わせる。
		tgt.outerHeight((titleHeader_H + contents_H));//'px'なしでよさげ。
		if(conf.scroll_inside_x_auto){//conf.scroll_inside_x_autoがtrueだったら
			tgt.find('div#c2scd_contents').scrollLeft(cal_conf.glid_width*conf.scroll_start_no);
		}
		
		
		//処理が終わったら最後に表示
		tgt.find('div#loading').remove();
		tgt.find('table.timeline_data').show();//ミリ秒指定。ゆっくり表示。引数なければ即表示。
	}
	
	//一時的にサンプル行をappendし、CSS属性を取得。
	//privateMethod 端数が出ないように幅の数値を調整して再設定
	function get_style_conf_val(tgt,opt,conf,cal_conf) {
		//CSSの設定値を取得するため、サンプル行を追加する。タイムフレームサンプルは通常のものを1番目に記述しないと取得の時に×。
		tgt.find('table.timeline_data').append('<tr class="c2scd_row_member" style="height:40px;"><td class="c2scd_entry_col member" style="width:181px; height:39px;"><div class="c2scd_label_name" style="width:166px;">エントリ名</div></td><td class="c2scd_entry_col_op" style="width:18px;"></td><td class="timeline_lane_cell"><div class="c2scd_lane_pool" style="width:782px; height:40px;"><div class="c2scd_timeframe sample" style=" left:80px; width:100px;">sampleタイムフレーム</div><div class="c2scd_timeframe ' + conf.mb_tf_name + ' sample" style=" left:20px; width:50px;">sample移動時間</div><table class="c2scd_grid_table" style="width:782px; height:40px;"><tbody><tr><td class="c2scd_grid_cell flat" style="width:31px"></td><td class="c2scd_grid_cell" style="width:31px"></td><td class="c2scd_grid_cell flat" style="width:31px"></td></tr></tbody></table></div></td></tr>');
		//サンプルの記述からCSS設定値を取得しておく。幅・高さの単位はpxとみなす。
		cal_conf.scaleHeaderBdrW_R = parseInt(tgt.find('div#c2scd_header').css('border-right-width')) || 0;//★未使用？
		//table.timeline_data
		cal_conf.tblBdrW_L = parseInt(tgt.find('table.timeline_data').css('border-left-width')) || 0;
		cal_conf.tblBdrW_R = parseInt(tgt.find('table.timeline_data').css('border-right-width')) || 0;
		cal_conf.td_TL_lane_cell_R = parseInt(tgt.find('table.timeline_data td.timeline_lane_cell').css('border-right-width')) || 0;//全体の幅計算に影響
		cal_conf.td_entry_diffW = (parseInt(tgt.find('tr.c2scd_row_member td.c2scd_entry_col').outerWidth())
			- parseInt(tgt.find('tr.c2scd_row_member td.c2scd_entry_col').width())) || 0;//★未使用？
		cal_conf.td_entry_label_diffW = (parseInt(tgt.find('tr.c2scd_row_member td.c2scd_entry_col div.c2scd_label_name').outerWidth())
			- parseInt(tgt.find('tr.c2scd_row_member td.c2scd_entry_col div.c2scd_label_name').width())) || 0;//エントリ名ラベル
		cal_conf.td_entry_op_diffW = (conf.entry_col_op_width > 0) ? ((parseInt(tgt.find('td.c2scd_entry_col_op').outerWidth())
			- parseInt(tgt.find('td.c2scd_entry_col_op').width())) || 0) : 0;//outerWidthとwidthの差
		cal_conf.tblGrid_diffW = (parseInt(tgt.find('table.c2scd_grid_table').outerWidth())
			- parseInt(tgt.find('table.c2scd_grid_table').width())) || 0;//outerWidthとwidthの差//★未使用？
		cal_conf.td_Lane_diffW = (parseInt(tgt.find('table.timeline_data td.timeline_lane_cell').outerWidth())
			- parseInt(tgt.find('table.timeline_data td.timeline_lane_cell').width())) || 0;//outerWidthとwidthの差
		//グリッドテンプレート用。サンプルの記述からCSS設定値を取得しておく。
		cal_conf.td_glid_cell_diffW = 1//テーブルがborder-collapse: collapseの場合のtdのborder-widthは隣同士で相殺しあうので、取得すると基本的に半分になるみたい。1ピクセルの場合はブラウザが交互に1としてカウントしたりしているらしく、正しい値をサンプルから取得するのは困難と判断し、1px決めで値設定することにした。
		//タイムフレーム用
		cal_conf.div_TF_diffW = (parseInt(tgt.find('div.c2scd_lane_pool div.c2scd_timeframe').outerWidth())
			- parseInt(tgt.find('div.c2scd_lane_pool div.c2scd_timeframe').width())) || 0;//outerWidthとwidthの差
		cal_conf.div_TF_mb_diffW = (parseInt(tgt.find('div.c2scd_lane_pool div.c2scd_timeframe.' + conf.mb_tf_name).outerWidth())
			- parseInt(tgt.find('div.c2scd_lane_pool div.c2scd_timeframe.' + conf.mb_tf_name).width())) || 0;//移動時間TFのouterWidthとwidthの差
		cal_conf.scaleBar_posTop = conf.use_scale_bar_date ? conf.scale_bar_date_height : 0;//スケールバーのPos Top
		
		cal_conf.header_pos_top = parseInt(tgt.find('div#c2scd_header').position().top) || 0;//スクロールバーの縦固定用。未使用。
		
		//サンプルのTRを削除する。
		tgt.find('table.timeline_data tr.c2scd_row_member').remove();
		
	}//end get_style_conf_val()()
	
	function set_startingDate(tgt,opt,conf,cal_conf) {
		
		if (opt.current_date.match(/^(\d{4})(\d{1,2})(\d{1,2})$/)){//yymmdd。
			cal_conf.startingDate = new Date(RegExp.$1,(RegExp.$2-1),RegExp.$3,0,0,0);//Dateオブジェクトに。時刻は0:00
			//getTime() 	1970年1月1日午前0時からの経過時間（経過ミリ秒数）を参照する
			//月は0～11なのでマイナス1。分に換算
			cal_conf.startingMin = cal_conf.startingDate.getTime() / (60*1000)
				+ (conf.scale_step_minutes*conf.range_start_no);//00：00を基点とした時のスケール開始時刻の分換算を足す。
			//スケジューラの最後の日時。getTimeの分換算。
			cal_conf.endingMin = cal_conf.startingDate.getTime() / (60*1000)
				+ (conf.scale_step_minutes*conf.range_end_no);//00：00を基点とした時のスケール終了時刻の分換算を足す。
			//スケジューラの最後の日時。DateObj。TF絞込みに使用。
			cal_conf.endingDate = new Date(cal_conf.endingMin*(60*1000));
			
		}else{
			//エラー表示
			tgt.find('div.c2scd_canvas').append('<div class="err_mes">カレント日付が正常に取得できません。（形式：yyyymmdd）<br />input:'+opt.current_date+'</div>');
		}
		
	};//end adjust_conf_val
	
	//一時的にサンプル行をappendし、CSS属性を取得。
	//privateMethod 端数が出ないように幅の数値を調整して再設定
	function adjust_conf_val(tgt,opt,conf,cal_conf) {
		
		cal_conf.tpl_glid ='';//glid用のテンプレート。draw_scale_bar()で先につくっておき、draw_grid()で利用。
		
		//var cr_date;
		if (opt.current_date.match(/^(\d{4})(\d{1,2})(\d{1,2})$/)){//yymmdd。
			cal_conf.startingDate = new Date(RegExp.$1,(RegExp.$2-1),RegExp.$3,0,0,0);//Dateオブジェクトに。時刻は0:00
			//getTime() 	1970年1月1日午前0時からの経過時間（経過ミリ秒数）を参照する
			//月は0～11なのでマイナス1。分に換算
			cal_conf.startingMin = cal_conf.startingDate.getTime() / (60*1000)
				+ (conf.scale_step_minutes*conf.range_start_no);//00：00を基点とした時のスケール開始時刻の分換算を足す。
			//スケジューラの最後の日時。getTimeの分換算。
			cal_conf.endingMin = cal_conf.startingDate.getTime() / (60*1000)
				+ (conf.scale_step_minutes*conf.range_end_no);//00：00を基点とした時のスケール終了時刻の分換算を足す。
			//スケジューラの最後の日時。DateObj。TF絞込みに使用。
			cal_conf.endingDate = new Date(cal_conf.endingMin*(60*1000));
			
		}else{
			//エラー表示
			tgt.find('div.c2scd_canvas').append('<div class="err_mes">カレント日付が正常に取得できません。（形式：yyyymmdd）<br />input:'+opt.current_date+'</div>');
		}
		//cal_conf.scroll_bar_width = (opt.width > tgt.outerWidth()) ? 17 : 0);//横スクロールバーがつく大きさなら、高さにスクロールバーの幅（17px）をセットする。
		cal_conf.view_width = tgt.outerWidth();//canvas表示部分の幅。外側と同じ値をセット。
		
		
		//(opt.label_col_width(tblBdrW_L含む) + cal_conf.timeline_width + cal_conf.td_TL_lane_cell_R) = opt.widthとなる
		cal_conf.glid_len = conf.range_end_no - conf.range_start_no;//グリッドの数//len
		if(conf.scroll_inside_x_auto){//conf.scroll_inside_x_autoがtrueだったら幅を再設定
			cal_conf.glid_inseide_len = conf.scroll_end_no - conf.scroll_start_no;//スクロール内側表示部分のみのグリッドの数
			cal_conf.glid_width = Math.floor((cal_conf.view_width - opt.label_col_width - cal_conf.td_TL_lane_cell_R - 17)/cal_conf.glid_inseide_len);//グリッド間隔。glid_inseide_lenで割る。全体幅からスクロールバーの幅（17px）マイナスする。
		}else{
			cal_conf.glid_width = Math.floor((cal_conf.view_width - opt.label_col_width - cal_conf.td_TL_lane_cell_R)/cal_conf.glid_len);//グリッド間隔（border含まず）
		}
		
		cal_conf.timeline_width = cal_conf.glid_width*cal_conf.glid_len + 1;//scaleBarWidth　timeline描画領域の幅。罫線片方分1プラス。
		
		//スクロール内側表示部分のtimeline領域の幅。
		if(conf.scroll_inside_x_auto){//conf.scroll_inside_x_autoがtrueだったら
			cal_conf.timeline_inside_width = cal_conf.glid_width*cal_conf.glid_inseide_len + 1;
		}else{
			cal_conf.timeline_inside_width = cal_conf.timeline_width;//timeline_widthと同じ。
		}
		
		//opt.label_col_width = opt.width - cal_conf.timeline_width - cal_conf.td_TL_lane_cell_R;//最左列の幅を調整して上書き
		//opt.label_col_width = cal_conf.view_width - cal_conf.timeline_inside_width - cal_conf.td_TL_lane_cell_R;//最左列の幅を調整して上書き
		cal_conf.set_label_col_width = cal_conf.view_width - cal_conf.timeline_inside_width - cal_conf.td_TL_lane_cell_R;//最左列の幅を調整して上書き
		cal_conf.contents_width = cal_conf.set_label_col_width + cal_conf.timeline_width + cal_conf.td_TL_lane_cell_R;//中身の全体幅。
		
		cal_conf.td1_w = cal_conf.set_label_col_width - cal_conf.tblBdrW_L - conf.entry_col_op_width - cal_conf.td_entry_op_diffW;
		cal_conf.td1_label_w = cal_conf.td1_w - cal_conf.td_entry_label_diffW;
		cal_conf.td2_w = conf.entry_col_op_width;
		cal_conf.div_lane_w = cal_conf.timeline_width - cal_conf.tblBdrW_R - cal_conf.td_Lane_diffW;
		cal_conf.pxPerMin = cal_conf.timeline_width/(cal_conf.glid_len*conf.scale_step_minutes);//1分あたりのピクセル数値
		cal_conf.pxPerDay = cal_conf.pxPerMin*60*24;//1日あたりのピクセル数値
		
		
	};//end adjust_conf_val

	//privateMethod　スケールバー描画
	function draw_scale_bar(tgt,opt,conf,cal_conf) {
		//1つのバーbox幅が規定値内か？　yesなら毎時0分しか時刻表示しない。
		var flg_flatOnly = !(cal_conf.glid_width > conf.min_width_to_time_labeling_only_at_flat);
		//headerのborder-left-widthを取得
		var headerBorderLeftWidth = parseInt(tgt.find('div#c2scd_header').css('border-left-width'));//"5px"などのstringで取得されるのでparseIntする。単位はpxとみなす。emとか指定することはまずないと思う。
		//↓for文のインクリメント部分でループ後に加算。
		var left_W_Px = cal_conf.set_label_col_width - headerBorderLeftWidth +1 ;//headerのborder-left★とグリッドテーブルのborder-left(tableは)を引く
		var curentMin = conf.scale_step_minutes*conf.range_start_no;//00：00基点のカレントの合計分
		
		//ヘッダーパートクラス設定
		//tgt.find('div#c2scd_header').outerHeight(tgt.find('div#c2scd_header').outerHeight() + cal_conf.scaleBar_posTop);
		tgt.find('div#c2scd_header').removeClass('mode2line');//初期化のために一旦ここで削除。2重追加防止。
		
		var strEnd_date = '';
		//2段表示時のスケールバー日付表示cal_conf.pxPerDay/left_W_Px
		if(conf.use_scale_bar_date){
			tgt.find('div#c2scd_header').addClass('mode2line');//クラス追加
			tgt.find('div#c2scd_scale_bar').before('<div id="c2scd_scale_bar_date" style="left:'
				+ left_W_Px + 'px;top0px;"></div>');//器DIVを追加。
			var barDateAry=new Array();
			var skip_leftPx = (curentMin*cal_conf.pxPerMin);//00：00基点とした場合のスタート時刻のpx換算（スキップ分）
			
			var tmpPosPx = 0, bd_left = 0, bd_width = 0;
			//これNG！→var tgt_date = cal_conf.startingDate;
			//Date変数を他の変数に代入すると参照渡しになるので元が上書きされる！よってこのような方法でコピー
			var tgt_dateObj = new Date(cal_conf.startingDate.getTime());
			for (k = 0; bd_left < cal_conf.timeline_width; bd_left = tmpPosPx,tgt_dateObj.setDate(tgt_dateObj.getDate() + 1), k++) {
				var tmpPosPx = Math.floor((cal_conf.pxPerDay - skip_leftPx) + cal_conf.pxPerDay*k);
				tmpPosPx = (tmpPosPx > cal_conf.timeline_width ? cal_conf.timeline_width : tmpPosPx);
				bd_width = tmpPosPx - bd_left;
				
				barDateAry.push('<div class="c2scd_scale_label date" style="width:'
					+ bd_width + 'px; height:' + conf.scale_bar_date_height + 'px;left:'
					+ bd_left + 'px; top: 0px;">'
					//+ htmlEscape($.formatDate(tgt_dateObj,'M/d (EEE)'))
					+ createStyleDateHTML(tgt_dateObj,true)
					+ '</div>');
			}
			tgt.find('div#c2scd_scale_bar_date').append(barDateAry.join(''));
			tgt_dateObj.setDate(tgt_dateObj.getDate() - 1);//1日戻す。
			strEnd_date = ' ～ ' + $.formatDate(tgt_dateObj,'MM/dd (EEE)')
		}
		
		//日付表示
		tgt.find('div#c2scd_header div.header_date_bg').outerWidth(left_W_Px);
		tgt.find('div#c2scd_header .c2scd_header_date').outerWidth(left_W_Px).html(
			createStyleDateHTML(cal_conf.startingDate,true)
			+ '<span class="end_date">' + strEnd_date + '</span>'
			);
		tgt.find('.c2-title.current_date').html(
			createStyleDateHTML(cal_conf.startingDate,true)
			+ '<span class="end_date">' + strEnd_date + '</span>'
			);
		//スケールバー親DIVの位置・幅設定
		tgt.find('div#c2scd_header div#c2scd_scale_bar')
			//.css({'left':left_W_Px , 'top':cal_conf.scaleBar_posTop})
			.css({'left':left_W_Px})
			.outerWidth(cal_conf.timeline_width);
		
		//間隔狭い時、時刻表示をいくつおきにするかを計算。
		var interval = Math.ceil(conf.min_width_to_time_labeling_only_at_flat/cal_conf.glid_width,0);
		
		var leftPx = 0;
		for (var strArr=new Array(),strArr2=new Array(),i = 0; i < cal_conf.glid_len; curentMin += conf.scale_step_minutes,leftPx +=cal_conf.glid_width,i++) {
			
			//時刻表示するか判別
			var flg_dispTime = (i % interval == 0) && (!flg_flatOnly || (curentMin%60) == 0);
			var timeStr = ('00' + Math.floor(conf.use_48clock ? curentMin/60 : (curentMin/60)%24) ).slice(-2)
					+ ':' + ('00' + curentMin%60).slice(-2);
			
			//罫線スタイルを判別
			var lineStyle='';//初期化
			//if($.inArray(i, conf.use_strong_line) >= 0){//$.inArrayは配列の中で見つかったインデックスを返す。なければ-1
			if($.inArray(timeStr, conf.use_strong_line) >= 0){//$.inArrayは配列の中で見つかったインデックスを返す。なければ-1
				lineStyle =' strong';//前の半角スペースも含む。
			}else if(! flg_dispTime){
				lineStyle = '';//時刻表示しない場合は点線。
			}else if(curentMin%60 == 0){
				lineStyle =' flat';//前の半角スペースも含む。
			}
			
			strArr.push('<div class="c2scd_scale_label'
				//+ (curentMin%60 == 0 ? ' flat' : '')
				+ lineStyle
				//+ '" style="width: ' + cal_conf.glid_width +'px;'//罫線は左側にしかないので、width指定する必要なし。
				+ '" style="height: 18px; left:' + leftPx + 'px; top: 0px;">'
				//+ '" style="height: 18px; left:' + leftPx + 'px; top: ' +cal_conf.scaleBar_posTop + 'px;">'
				+ (flg_dispTime ? timeStr : '' )
				+ '</div>'
				);
			//glid用のテンプレートもついでに作っておく
			strArr2.push(
				'<td class="c2scd_grid_cell'
				//+ (curentMin%60 == 0 ? ' flat' : '')
				+ lineStyle
				+ '" style="width:' + (cal_conf.glid_width - cal_conf.td_glid_cell_diffW) + 'px;"></td>'
				);
		}
		tgt.find('div#c2scd_header').outerWidth(cal_conf.contents_width).find('div#c2scd_scale_bar').append(strArr.join(''));
		cal_conf.tpl_glid = strArr2.join('')
	};//end draw_scale_bar

	//privateMethod　グリッド描画
	function draw_grid(tgt,opt,conf,cal_conf) {
		var entries = $.fn.c2scheduler.y_entries;
		//ソート
		//速度優先でDOM操作回数を最小限にするためにHTML作成してあとで一気に追加。
		for (var strArr = new Array(),strArr2 = new Array(),i = 0; i < entries.length; i++) {
			//速度優先で文字列結合を最小限にするため、配列にしてあとで一気にJOIN
			//section行処理
			var str1 = '<tr class="c2scd_row_section type' + entries[i].type + '" '
				+ 'id="c2scd_section-' + entries[i].section_id + '">' 
				+ '<td class="c2scd_entry_col section type' + entries[i].type + '" colspan="'
				+ (conf.entry_col_op_width > 0 ? 3 : 2) + '"><div class="c2scd_label_name">'
				+ entries[i].label+ '</div></td></tr>';
			strArr.push(str1);
			//ゴースト用。上記と同じ。
			strArr2.push(str1);
			//member行処理
			for (var j=0; j < entries[i].members.length; j++) {
				var str2_A = '<tr class="c2scd_row_member type' + entries[i].type 
					+ '" id="c2scd_member-' + entries[i].members[j].member_id + '">'
				var str2_A_ghost = '<tr class="c2scd_row_member type' + entries[i].type 
					+ ' member-' + entries[i].members[j].member_id + '">'//☆相違点。id重複を防ぐためクラス指定追加に変更。
				var str2_B = '<td class="c2scd_entry_col member" style="width:' + cal_conf.td1_w + 'px;">'
					+'<div class="c2scd_label_name" style="width:'+ cal_conf.td1_label_w + 'px;">'//このdivにW指定しないとつぶれる。
					+ htmlEscape(entries[i].members[j].label)
					+ '</div></td>'
					+ ((conf.entry_col_op_width > 0) ? 
						('<td class="c2scd_entry_col_op" style="width:' + cal_conf.td2_w + 'px;">' 
						+'<div class="entry_col_op" style="width:'+ cal_conf.td2_w + 'px;">'//このdivにW指定しないとつぶれる。
						+ createHtml($.fn.c2scheduler.templates.entry_col_op,entries[i].members[j])
						+'</div></td>') 
						: '')
					+ '<td class="timeline_lane_cell">'
					+ '<div class="c2scd_lane_pool" style="width:' + cal_conf.div_lane_w + 'px;">'
					+ '<table class="c2scd_grid_table"><tbody><tr>'
					+ cal_conf.tpl_glid
					+ '</tr></tbody></table></div></td></tr>';
				strArr.push(str2_A + str2_B);
				//ゴースト用。上記と同じだが、id指定のみ除外。
				strArr2.push(str2_A_ghost + str2_B);
			}
		}
		//tableタグ。c2scd_canvas、c2scd_canvas_fixed_ghostそれぞれの中に作る。
		tgt.find('div.c2scd_canvas table.timeline_data').append(strArr.join(''));
		tgt.find('div.c2scd_canvas_fixed_ghost table.timeline_data').append(strArr2.join(''));
		/*
		//tableタグ。親DIVを指定せず、c2scd_canvas_fixed_ghostの中にも作る。
		tgt.find('table.timeline_data').each(function(){
			$(this).append(strArr.join(''));
		});
		*/
	};

	//privateMethod　タイムフレーム描画
	function draw_timeframes(tgt,opt,conf,cal_conf) {
		var tfs = $.fn.c2scheduler.timeframes
		var entries = $.fn.c2scheduler.y_entries;
		for (var i=0; i < entries.length; i++) {
			//member行の描画対象TF数
			var entry_tf_count = 0;//section単位の描画対象TF数。他チームでかつ、描画対象TF数が0なら行ごと表示しない。
			//member行処理
			entries[i].members.sort(function(a,b){//ソート
				 return ((a.sort_no || 0) > (b.sort_no || 0));//sort_noがnullだと上に来る。
				});
			for (var j=0; j < entries[i].members.length; j++) {
				//カレントのメンバーのタイムフレームデータを収集
				//終了時刻がスケジューラ表示の開始時刻より前で開始時刻がスケジューラ表示の終了時刻より前であること。
				var m_id = entries[i].members[j].member_id;
				var mTfs = $.grep(tfs, function(val,key){
						return (val['member_id'] == m_id && formatDateStr2Date(val.end) > cal_conf.startingDate  && formatDateStr2Date(val.start) < cal_conf.endingDate );
					});
				entry_tf_count += mTfs.length;//section単位の描画対象TF数を加算。
				//開始時刻でソートする。昇順
				mTfs.sort(function(a,b){
					return formatDateStr2Date(a.start) > formatDateStr2Date(b.start);//DateObjに変換して。
				});
				
				//エントリ名OPカラムにルートMAPリンクをセット。本体とゴースト両方。
				//条件はstartが対象第一日中のもののみ。
				//対象日の0時0分
				var limit_startDate = new Date(cal_conf.startingDate.getFullYear(),
					cal_conf.startingDate.getMonth(),cal_conf.startingDate.getDate(),0,0,0);
				//翌日の0時0分
				var limit_endDate = new Date(limit_startDate.getTime() + 24*60*60*1000);
				var mTfs_map = $.grep(tfs, function(val,key){
						return (val['member_id'] == m_id && formatDateStr2Date(val.start) >= limit_startDate && formatDateStr2Date(val.start) < limit_endDate );
					});
				//ルートMAPリンク用のtf配列を開始時刻でソートする。昇順
				mTfs_map.sort(function(a,b){
					return formatDateStr2Date(a.start) > formatDateStr2Date(b.start);//DateObjに変換して。
				});
				if ($.fn.c2scheduler.createRouteMapURI(mTfs_map) != ''){
					//tooltip(titleタグ)の文章
					var tip_str = 'ClickするとGoogleのルートMAP検索ページを開きます。(' 
						+ $.formatDate(limit_startDate,'yyyy/MM/dd') + 'の予定の住所が対象)';
					//ルートMAPリンクを生成。
					var link_routeMap = '<a href="' + $.fn.c2scheduler.createRouteMapURI(mTfs_map) + '" target="_blank">'
					+ '<div class="routeMap gray-button" title = "' + tip_str + '"></div></a>';
					tgt.find('div.c2scd_canvas tr#c2scd_member-' + m_id +' .c2scd_entry_col_op .entry_col_op').html(link_routeMap);
					tgt.find('div.c2scd_canvas_fixed_ghost tr.member-' + m_id +' .c2scd_entry_col_op .entry_col_op').html(link_routeMap);//ゴースト
				}
				
				for (var k=0; k < mTfs.length; k++) {
					var val = mTfs[k];
					var cr_startM = formatDateStr2Date(val.start).getTime()/(60*1000) - cal_conf.startingMin;
					var cr_endM = formatDateStr2Date(val.end).getTime()/(60*1000) - cal_conf.startingMin;
					var cr_mbstartM = formatDateStr2Date(val.mb_start).getTime()/(60*1000) - cal_conf.startingMin;
					//px位置換算
					var cr_startPx = Math.floor(cal_conf.pxPerMin * cr_startM);
					var cr_endPx = Math.floor(cal_conf.pxPerMin * cr_endM);
					var cr_mbstartPx = Math.floor(cal_conf.pxPerMin * cr_mbstartM);
					//permissionの値による分岐
					var tpl = $.fn.c2scheduler.templates.timeframe, addClass = '';
					
					//tooltip用の1つ前のTFと現TFのルートマップリンクを生成し、データに格納しておく。
					val['routeMap_Uri'] = k > 0 ? $.fn.c2scheduler.createRouteMapURI([mTfs[k-1],mTfs[k]]) : '';
					if(val.permission == 'open'){
						tpl = $.fn.c2scheduler.templates.timeframe_open;
						addClass = ' open';//値の文字列は前の半角スペース含む
					}
					//移動時間
					if(cr_mbstartM < cr_startM){
						tgt.find('div.c2scd_canvas tr#c2scd_member-' + m_id +' div.c2scd_lane_pool').prepend(
						'<div class="c2scd_timeframe ' + conf.mb_tf_name + '" title="' 
						+ htmlEscape(val.transit_time) + '分' + '" style="left:'
						+ cr_mbstartPx + 'px; width:'
						+ (cr_startPx - cr_mbstartPx - cal_conf.div_TF_mb_diffW) + 'px;" tf_id="' + val.tf_id +'_mv">'
						+ htmlEscape(val.transit_time) + '分'
						+ '</div>'
						);
					}
					//通常タイムフレーム
					tgt.find('div.c2scd_canvas tr#c2scd_member-' + m_id +' div.c2scd_lane_pool').prepend(
						'<div class="c2scd_timeframe normal type' + val.type + addClass + '" id="tf_' + val.tf_id 
						+'" style="left:'+ cr_startPx + 'px; width:'
						+ (cr_endPx - cr_startPx - cal_conf.div_TF_diffW) + 'px;" tf_id="' +val.tf_id +'">'
						+ createHtml(tpl,val)
						+ '</div>'
						).children().first().data('tf',val);//追加したDOM要素(prependなのでchildrenのfirst)にtimeframeデータを関連付け
				};
				//他チームでかつ、描画対象TF数が0なら行ごと表示しない。ゴーストと両方。
				if (entries[i].type == 2 && mTfs.length < 1){
					//tgt.find('tr#c2scd_member-' + m_id,'tr.c2scd_row_member.member-' + m_id).addClass('hidden');なぜか2つ同時指定だとうまくいかないケースあり。
					tgt.find('tr#c2scd_member-' + m_id).addClass('hidden');//通常
					tgt.find('tr.c2scd_row_member.member-' + m_id).addClass('hidden');//ゴースト
				}
			}
			//他チームでかつ、描画対象TF数が0ならsection行を表示しない。ゴーストと両方。
			if (entries[i].type == 2 && entry_tf_count < 1){
				tgt.find('tr#c2scd_section-' + entries[i].section_id).addClass('hidden');
			}
		}
		//クリックの場合は全timeframe描画後にここでまとめてカーソル変える。
		if (conf.tooltip_trigger == 'click'){
			//tgt.find('div.c2scd_timeframe').not('.' + conf.mb_tf_name).css('cursor','pointer');//移動時間以外
			tgt.find('div.c2scd_timeframe.open').not('.' + conf.mb_tf_name).css('cursor','pointer');//移動時間以外
			tgt.find('div.c2scd_timeframe a').click(function(event){
				event.stopPropagation();//イベントバブリング（親要素へイベントが伝播すること）を中止。AタグクリックでTooltipも開くため。
			});
			$('body div.c2scd_tooltip').css('cursor','pointer');
		}
	};//end draw_timeframes
	
	//ツールチップ作成
	//private
	function createTooltip(tgt,conf){

		removeTooltip();//すでにあったら削除

		//append位置をBodyに変更。　var pos_top = Math.floor($(this).offset().top - this.offset().top + 50);
		//var pos_left = Math.floor($(this).offset().left - this.offset().left + 50);
		var pos_top = Math.floor($(tgt).offset().top);
		pos_top += ((parseInt(document.body.offsetHeight) - pos_top) < 100) ? -100 : 20;//位置によって上下調整。TFのTOPがウインドウ下より100px以内なら上の方に表示。
		var pos_left = Math.floor($(tgt).offset().left);
		pos_left += ((parseInt(document.body.offsetWidth) - pos_left) < 150) ? -250 : 30;//位置によって左右調整。TFのLeftがウインドウ右端より250px以内なら左の方に表示。
		var tf_id = $(tgt).attr('tf_id');
		var tf_val = $(tgt).data('tf');//DOM要素に関連付けておいたデータを取り出す。
		var routeMap_Link = '';
		if(tf_val.routeMap_Uri != ''){
			routeMap_Link = '<a href="' + tf_val.routeMap_Uri + '" target="_blank"><div class="tooltip_btn_routeMap gray-button" title="Clickすると、1つ前の予定とこの予定の住所間のGoogleのルートMAP検索ページを開きます。"><br /></div></a>'
		}
		//this内は領域が小さいのでBody内にappend。
		$('body').append('<div class="c2scd_tooltip" id="tooltip_tf_'+ tf_val.tf_id 
			+ '" style="visibility: visible; left: ' 
			+ pos_left + 'px; top: ' + pos_top + 'px;">'
			+ createHtml($.fn.c2scheduler.templates.tooltip,tf_val)
			//+ '<br />★$(tgt).offset().left:' + $(tgt).offset().left
			//+ '<br />★$(tgt).offset().left:' + $(tgt).offset().left
			//+ '<br />★$(tgt).css(left):' + $(tgt).css('left')
			+ '<div class="tooltip_menu" style="background-color:#FFF;">'
			//+ '<table class="tooltip_menu" style="background-color:#DDF;"><tbody><tr><td>'
			+ '<div class="tooltip_btn_txt gray-button release">解除</div>'
			+ '<div class="tooltip_btn_txt gray-button">ほげ</div>'
			+ routeMap_Link
			//+ '</td></tr></tbody></table>'//end tooltip_menu
			+ '</div>'//end tooltip_menu
			+ '</div>');//end tooltip
		if (conf.tooltip_trigger == 'click'){
			$('body div.c2scd_tooltip').css('cursor','pointer');//クリックの場合はカーソル変える。
		}
		$('body div.c2scd_tooltip .tooltip_menu').click(function(event){
			event.stopPropagation();//イベントバブリングを中止。クリックでTooltipを閉じるのとカブるため。
		});
	};//end createTooltip
	
	//ツールチップ消去
	function removeTooltip() {
		$('body div.c2scd_tooltip').remove();
	}

	//内部的に使用されるメソッドは、無名関数内で関数定義する。

	//エントリ配列定義
	$.fn.c2scheduler.y_entries = [];

	//timeframe配列定義
	$.fn.c2scheduler.timeframes = [];

	//データロード系メソッド=====
	//$.fn.c2scheduler.load_y_entries_data = function(url,yyyymmdd){
	//privateMethod　エントリy_entriesロード＆グリッド描画
	load_y_entries_data = function(url, yyyymmdd, tgt, opt, conf, cal_conf){
		$.ajax({
			url: url, //'test_y_entries_data.xml'
			dataType : 'xml',
			data: {}, //テスト時はパラメータ渡せない{date: opt.current_date , division_id : conf.cr_division_id }//'20120707'
			type: 'GET',
			success: function(data){
				//xml内を<y_entries>で囲っておく。抽出してJavasecipt配列に変換
				//$.fn.c2scheduler.y_entries = $.makeArray($('y_entries section',data));配列になるのは第一階層のみだったのでボツ。
				var org_entries = $.xml2json(data).section;//プラグインを利用してJSON形式に変換。
				//$.fn.c2scheduler.y_entries = $.xml2json(data).section;//プラグインを利用してJSON形式に変換。

				//要素が1つの場合、配列になっていないので配列へ。
				//まずsection
				var new_entries = new Array;
				if (!(org_entries instanceof Array)){
					new_entries[0] = org_entries;
					//alert("not instanceof Array");
				}else{
					new_entries = org_entries;
				}
				
				//ついでにソートしておく。
				new_entries.sort(function(a,b){
					return ((a.sort_no || 0) > (b.sort_no || 0));//sort_noがnullだと上に来る。
				});
				
				//members
				for (var i = 0; i < new_entries.length; i++) {
					var new_members = new Array;
					if (!(new_entries[i].members instanceof Array)){
						new_members[0] = new_entries[i].members;
						new_entries[i].members = new_members;
					}
					//ついでにソートしておく。
					new_entries[i].members.sort(function(a,b){//ソート
						return ((a.sort_no || 0) > (b.sort_no || 0));//sort_noがnullだと上に来る。
					});
				}
				
				$.fn.c2scheduler.y_entries = new_entries;
				$.fn.c2scheduler.status.flg_loaded_y_entries = true;//ロード完了フラグ
				
				
				draw_grid(tgt,opt,conf,cal_conf);//グリッド描画
				
				load_timeframes_data_xml(conf.load_timeframes_url,opt.current_date,tgt,opt,conf,cal_conf);//タイムフレーム描画
				
			}
		});
	};//end $.fn.c2scheduler.load_y_entries_data

	//privateMethod　タイムフレームロード＆描画
	load_timeframes_data_xml = function(url, yyyymmdd, tgt, opt, conf, cal_conf){
		$.ajax({
			url: url, 
			dataType : 'xml',
			data: {}, //テスト時はパラメータ渡せない{cr_date: yyyymmdd , cr_section_id : 1 }//'20120707'
			type: 'GET',
			success: function(data){
				var org_timeframes = $.xml2json(data).timeframe;//プラグインを利用してJSON形式に変換。
				//要素が1つの場合、配列になっていないので配列へ。
				//まずsection
				var new_timeframes = new Array;
				if (!(org_timeframes instanceof Array)){
					new_timeframes[0] = org_timeframes;
					//alert("not instanceof Array");
				}else{
					new_timeframes = org_timeframes;
				}
				
				$.fn.c2scheduler.timeframes = new_timeframes;
				$.fn.c2scheduler.status.flg_loaded_timeframes = true;//ロード完了フラグ
				
				draw_timeframes(tgt,opt,conf,cal_conf);//タイムフレーム描画
				adjust_final(tgt,opt,conf,cal_conf);//最後の大きさ調整
			}
		});
	};//end $.fn.c2scheduler.load_timeframes_data_xml
	
	//privateMethod　タイムフレームロード＆描画 JSON版
	load_timeframes_data_json = function(url, yyyymmdd, tgt, opt, conf, cal_conf){
		$.ajax({
			url: url, 
			dataType : 'json',
			data: {}, //テスト時はパラメータ渡せない{cr_date: yyyymmdd , cr_section_id : 1 }//'20120707'
			type: 'GET',
			success: function(data){
				$.fn.c2scheduler.timeframes = JSON.parse(data);
				$.fn.c2scheduler.status.flg_loaded_timeframes = true;//ロード完了フラグ
				
				draw_timeframes(tgt,opt,conf,cal_conf);//タイムフレーム描画
				adjust_final(tgt,opt,conf,cal_conf);//最後の大きさ調整
			}
		});
	};//end $.fn.c2scheduler.load_timeframes_data_json 
	
	//c2calendarの呼び出し
	function changeTo_c2calendar(current_date_str,division_id){
		
		//入れ替え部分を明示的に消しておく。そうしないとイベント設定が重複する？→live設定にしているものは入れ替えても残る。
		//$('#scheduler_body td.c2-header-left ,#scheduler_body td.c2-header-right ,#scheduler_body div#c2scd_contents').empty();
		
		//処理が終わるまでローディング画像を表示
		//$('#scheduler_body c2-view-month').append('<div id="loading"></div>');
		
		//config設定（一応）
		/*$.fn.c2calendar.set_config = {
			load_info_days_url:'./jquery-c2scheduler/c2calendar/test_calendar_data.xml' //日別情報を読み込むxmlのURL。
			,holidays:holidays//祝日データ。
			,scheduler_link_flg:true//c2schedulerへのリンク（切り替え可）有無。
			,cr_division_id:division_id//デフォルトnull。
			,load_required_flg: !($.fn.c2calendar.config.cr_division_id == division_id)//☆データの読み込みするか。division_id同じだったら不要。
		};
		*/
		
		//c2scheduler側でdivision_idをパラメータプロパティとして設定しないと、スケ・CAL間で行き来できないか。
		//$.fn.c2scheduler.set_config.load_y_entries_url = ''
		//$.fn.c2scheduler.set_config.load_timeframes_url = ''
		
		var cald_opt= $.extend({}//defaults自体も上書きされないよう、第一引数は{}にする。
				,{width: 970, max_height: 400, current_date: "20120907", holidays:holidays}
				,$.fn.c2calendar.config["option_values"] || {}	//「 || {}」はNUll時対策。
				,{current_yyyymm:current_date_str}	//年月をYYYYMM形式で渡す。
				);
			/*
			,current_date: "20120907"//yyyymmdd・・・不要？
			,width: 970//976スケジューラ中身（タイムライン）の幅。表示枠幅より大きい値の場合は横スクロールになる。
			,max_height: 400//スケジューラ表示枠の高さのMAX値。行が多くてこの高さ内に表示できない場合は縦スクロールになる。
			,holidays:holidays//祝日データ。
			*/
		
		//c2calendarの実行
		//$( '#scheduler_body' ).c2calendar({//calendarの階層を変更したので、このような呼び出し方は意味がなくなった。
		//$.fn.c2calendar({
		//$( $.fn.c2scheduler.config['selector'] ).c2calendar({//やっぱり分割する可能性があるので、復活。ただし、configで受け渡し。。
		$( $.fn.c2scheduler.config["selector"] ).c2calendar(cald_opt);
		
	}
	
	//テンプレートカスタマイズ系メソッド
	//publicMethod　タイムフレームのtypeを文字列に変換
	$.fn.c2scheduler.tf_type_decode = function(tf_type){
		
	};

	//テンプレート系プロパティ
	$.fn.c2scheduler.templates={};
	//{%プロパティ名%}という形式の文字列を埋め込むとそのプロパティで置換
	//{%プロパティ名 カスタム関数=opt カスタム関数=opt%}という形式でプロパティ名の後に半角スペースで関数名とそのオプション引数指定可能。
	//=の前後に半角スペースを入れてはならない。opt内に半角スペースを指定する場合は「\z」で暫定対応とした。（\sは正規表現とカブり、扱いづらいため。）。
	
	//タイムフレーム詳細権限なし用
	$.fn.c2scheduler.templates.timeframe = '{%title%}&nbsp;{%description%}&nbsp;{%lumping_count fmt=[集約$_件]%}<br />◆{%start%} ～ {%end%}';
	//詳細権限あり用
	$.fn.c2scheduler.templates.timeframe_open = '<a href="javascript:open_editwin(\'{%data1%}\');">{%title%}</a>&nbsp;{%description%} {%lumping_count fmt=[集約$_件]%}<br />◆{%start%}&nbsp;～&nbsp;{%end%}';

	//ツールチップ
	$.fn.c2scheduler.templates.tooltip = '{%title%}({%tf_id%})<br /><b>予定日:</b>{%start date_fmt=yyyy/MM/dd\z(EEE)%}<br /><b>時刻:</b>{%start date_fmt=HH:mm%} ～ {%end date_fmt=HH:mm%}<br /><b>移動時間:</b>{%transit_time%}分<br /><b>内容:</b>{%description%}<br /><b>住所:</b>{%adress%}<br />{%lumping_count fmt=<b>集約:</b>$_件 noesc%}';
	
	//エントリ名右opカラム。ここは複雑な情報をいれる可能性が高いので、プログラムで入れる。一応定義のみ。
	$.fn.c2scheduler.templates.entry_col_op = '';
	
	//テンプレート　置換カスタムユーティリティ関数登録。createHTML関数でcallされる。
	$.fn.c2scheduler.util = {};
	
	//第一引数はオプション指定の引数（例えばfmt=($_)なら右辺の「($_)」）
	//第二引数は加工元のオブジェクト。第三引数はこの関数が呼ばれた時のkeyString
	//第四引数は最初ならvalObj[keyString]と同じだが、2番目以降の関数指定の場合、前の結果が渡される。
	//例えば{%item func1=opt func2=opt%}の場合、func2の第四引数valにはfunc1の計算結果が渡される。
	$.fn.c2scheduler.util.fmt = function(funcArg,valObj,keyString,val){
		if (valObj[keyString] != ''){//空じゃなかったら
			var pre_val_re = new RegExp('\\$_', 'g');//gオプションつけ。$_は2回分エスケープが必要。
			return (funcArg || '').replace(pre_val_re,val);
		}
		return val;
	}
	
	$.fn.c2scheduler.util.date_fmt = function(funcArg,valObj,keyString,val){
		if (valObj[keyString] != ''){//空じゃなかったら
			return $.formatDate(formatDateStr2Date(val),funcArg);//プラグインを使用して日付フォーマット変更。
		}
		return val;
	}

	/*=======private ユーティリティ関数=======*/
	//"yyyy-mm-dd hh:mm"（分までor 日付のみ）の形式の日時文字列をDateオブジェクトに変換して返す。
	//日付区切りは-./ or 区切りなしのどれでもよい。yearは4桁のみ。月日は1桁でもよい。
	//時刻は半角スペースはさんで"hh:mm"のみ(1桁でもよい。マッチしなければ時刻は無視される)。
	function formatDateStr2Date(dateStr){
		//if (dateStr.match(/^(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})/)){
		if (dateStr.match(/^(\d{4})[\-\./]?(\d{1,2})[\-\./]?(\d{1,2}) (\d{1,2}):(\d{1,2})/)){//時:分あり。
			return new Date(RegExp.$1,(RegExp.$2 - 1),RegExp.$3,RegExp.$4,RegExp.$5);//月は0～11なのでマイナス1。
		}else if (dateStr.match(/^(\d{4})[\-\./]?(\d{2})[\-\./]?(\d{2})/)){//日付のみ
			return new Date(RegExp.$1,(RegExp.$2 - 1),RegExp.$3);//月は0～11なのでマイナス1。
		}
		return null;
	};
	//Dateオブジェクトをその日の0時からの分換算数値にして返す。日付無視。最初使用していたが、使用しなくなった。
	function time2Min(dateObj){
		if (!(dateObj === null) && dateObj instanceof Date){
			return dateObj.getHours() * 60 + dateObj.getMinutes();
		}
		return null;
	};

	//templateに埋め込まれた{%プロパティ名%}という形式の文字列をobjのプロパティ値で置換したテキストを返す。
	//置換のVal値は特定文字をHTMLエスケープして置換する。
	function createHtml(template,obj){
		var result = template;
		var tpl_re = new RegExp(/\{%([^%{}]+)%\}/);
		var m;
		
		var loop_count = 0;//無限ループ回避用
		//while(tpl_re.test(result) && loop_count < 10){//RegExp#testは真偽を返す
		while(((m = result.match(/\{%([^%{}]+)%\}/)) != null) && loop_count < 500){//RegExp.$1のような表記は互換性が低い(?)ので配列へ。
			//var paramAry = RegExp.$1.split(' ');//半角スペースで区切って配列へ。1番目要素名。それ以降はオプション指定
			var paramAry = m[1].split(' ') || null;//半角スペースで区切って配列へ。1番目要素名。それ以降はオプション指定
			var keyString = paramAry[0];
			//var re = new RegExp(m[0], "g");//replaceは最初にマッチしたものしか置換しないのでRegExpを生成してgオプションつけ
			var val = obj[keyString].toString() || '';//nullなら空文字
				
			
			
			//オプション指定処理
			for (var i = 1; i < paramAry.length; i++) {//オプション指定処理。添え字0はスルー
				var funcAry = (paramAry[i].split('=') || []);//funcAry[0]に関数名（左辺）、funcAry[1]にオプション引数（右辺）
				var funcArg = (funcAry.length > 1 ? funcAry[1].replace(/\z/g, " ") : '');//半角スペースを置換
				//if(funcAry[0] != 'noesc' || typeof $.fn.c2scheduler.util[funcAry[0]] == 'undefined'){//指定関数が見つからなければスルー
				if(typeof $.fn.c2scheduler.util[funcAry[0]] != 'undefined'){//指定関数が見つからなければスルー
					val = ($.fn.c2scheduler.util[funcAry[0]].call(this,funcArg,obj,keyString,val) || val);//call関数の第一引数は現在のオブジェクトを指定するらしい。
				}
			}
			
			//val値のHTMLエスケープ処理（一般的なHMTLメタ文字6字）
			//XMLエスケープと2重エスケープにはなっていない模様。
			if($.inArray('noesc',paramAry.slice(1)) < 0){//最初の要素を除いた配列の中に'noesc'がいなかったら
				val = htmlEscape(val);
			}
			
			//result = result.replace(re,val);//置換。valがnullでも置換しないと無限ループになる。
			//split & joinで置換。
			//replaceは検索文字内の特殊文字をエスケープしなくてはならない、全置換のためにreオブジェクトでgオプション使う必要あり、ので面倒。
			result = result.split(m[0]).join(val);
			
			loop_count += 1;
		}
		//alert(loop_count);
		//$('.debug').html($('.debug').html() + '<br />m[0]:' + (m[0] || '') + '<br />val:' + (val || '') + loop_count);
		//$('.debug').html($('.debug').html() + ' | ' + loop_count);
		
		return result;
	};
	
	//HTMLエスケープ処理（一般的なHMTLメタ文字6字）
	function htmlEscape(str) {
		var result = str;
		
		//2重エスケープ防止のため、逆置換して先に一旦戻しておく。
		result = result.replace(/&amp;/g,"&");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/&quot;/g,'"');//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/&#039;/g,"'");//ちなみにXMLのエスケープ文字は「&apos;」。XMLと異なる。
		result = result.replace(/&apos;/g,"'");//XMLのエスケープ文字対応。
		result = result.replace(/&lt;/g,"<");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/&gt;/g,">");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/&nbsp;/g," ");//半角スペース
			
		//本置換
		result = result.replace(/&/g,"&amp;");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/"/g,"&quot;");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/'/g,"&#039;");//ちなみにXMLのエスケープ文字は「&apos;」。XMLと異なる。
		result = result.replace(/</g,"&lt;");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/>/g,"&gt;");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/ /g,"&nbsp;");//半角スペース
		return result;
	}
	//ルートMAPリンクURIを生成。
	//引数はタイムフレームの配列　後ろに括弧つきでdescriptionを付加。
	//外から使えるように外部公開へ変更。
	$.fn.c2scheduler.createRouteMapURI=function(tfAry) {
		var adressAry = $.map(tfAry,function(value,key){
			return (value.adress != '' && value.permission == 'open') ? encodeURI( htmlEscape(value.adress) + '(' + htmlEscape(value.description) + ')') : null;
			//return (value.adress != '' && value.permission == 'open') ? htmlEscape(encodeURI( value.adress + '(' + value.description + ')')) : null;
		});
		if(adressAry.length < 2 ) return '';
		return 'https://www.google.co.jp/maps?ie=UTF8&f=d&dirflg=d&saddr='
			+ adressAry[0] + (adressAry.length > 1 ? '&daddr=' + adressAry.slice(1).join('+to:') : '') ;
	}
	
	///テンプレートHTML(urlで指定)を同期通信でロードし、selecter_strの要素のHMTLに挿入する。
	function load_html_sync(selecter_str,url){
		//テンプレートHTML読み込み入れ替え
		//$( '#scheduler_body div#c2scd_contents' ).load('./sg_scheduler_fmt.html');//loadは非同期なのでボツ。
		$.ajax({
			async:false, //同期通信。defaultはtrue(非同期)。
			ifModified:true, //前回と変更があった時のみ更新。defaultはfalse。
			url: url, 
			dataType : 'html',
			//data: {}, //パラメータ不要。
			type: 'GET',
			success: function(data){
				$( selecter_str ).html(data);
			}
		});
	}
	
	//スタイル付き日付HMTLを生成
	//addCommentはboolean。祝日の文字列を追加する場合はtrue。
	function createStyleDateHTML(dateObj,addComment) {
		if(dateObj == null) return '';
		//holidayデータからカレント日付のデータを探す。
		var holidays_match = $.grep($.fn.c2scheduler.config.holidays, function(val,key){
			return ($.formatDate(dateObj,'yyyy/M/d') == val.Date);
		});
		var strComment = '',dayStyle='';
		if(addComment && holidays_match.length > 0) strComment = '<span class="comment">' + htmlEscape(holidays_match[0].Name1) + '</span>';
		if(dateObj.getDay() == 0 || (holidays_match.length > 0)){//日曜 or 祝日
			dayStyle=' holiday';//前の半角スペース含む。
		}else if(dateObj.getDay() == 6){//土曜。
			dayStyle=' sat';//前の半角スペース含む。
		}
		return '<span class="date">'
			+ $.formatDate(dateObj,'yyyy/MM/dd')
			//+ cal_conf.startingDate.getFullYear() + '/' + (cal_conf.startingDate.getMonth()+1) + '/' + cal_conf.startingDate.getDate()
			+ '<span class="day' + dayStyle + '">'
			+ $.formatDate(dateObj,'(EEE)')
			//+ '(' + ['日','月','火','水','木','金','土'][cal_conf.startingDate.getDay()] + ')'
			+ '</span>' + strComment + '</span>'
	}
	
	
	//スリープ処理　未使用
	function sleep(time) {
		var d1 = new Date().getTime();
		var d2 = new Date().getTime();
		while (d2 < d1 + time) {
			d2 = new Date().getTime();
		}
		return;
	}


})(jQuery);


