﻿// Copyright (C) 2017  Mocchi (mocchi_2003@yahoo.co.jp)
// License: Boost Software License   See LICENSE.txt for the full license.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace pdf_pp {
	public partial class MainForm : Form {
		public string Status {
			set {
				textBox_status.Text = value;
			}
		}
		public MainForm(string input_pdffilename) {
			InitializeComponent();
			if (string.IsNullOrEmpty(input_pdffilename)) return;
			foreach (Control ctrl in tabControl_pp.Controls) {
				DividePDFForm spf = ctrl as DividePDFForm;
				if (spf == null) continue;
				spf.InputPDFFileName = input_pdffilename;
			}
		}
	}
}
