/*
 * Decompiled with CFR 0.152.
 */
package blackjack;

import blackjack.Deck;
import blackjack.Player;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlackJack {
    Deck deck;
    Player player;
    Player dealer;

    public BlackJack() {
        this.player = new Player(this.deck);
        this.dealer = new Player(this.deck);
    }

    private void display(String message) {
        System.out.println(message);
    }

    private boolean confirm(String message) {
        System.out.print(message + " [y/N]:");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            line = br.readLine();
        }
        catch (IOException e) {
            Logger.getLogger(BlackJack.class.getName()).log(Level.SEVERE, null, e);
        }
        return line != null && line.toLowerCase().startsWith("y");
    }

    private void displayScores() {
        this.display("\u30d7\u30ec\u30fc\u30e4\u30fc\uff1a" + this.player.suits() + " = " + this.player.score());
        this.display("\u30c7\u30a3\u30fc\u30e9\u30fc\uff1a" + this.dealer.suits());
    }

    private void displayResult() {
        switch (this.player.match(this.dealer)) {
            case WIN: {
                this.display("\u3042\u306a\u305f\u306e\u52dd\u3061\u3067\u3059\uff01");
                break;
            }
            case DRAW: {
                this.display("\u5f15\u304d\u5206\u3051\u3067\u3059\u3002");
                break;
            }
            case LOST: {
                this.display("\u3042\u306a\u305f\u306e\u8ca0\u3051\u3067\u3059\uff01");
            }
        }
    }

    private void init() {
        this.deck.init().shuffle();
        this.player.init().hit().hit();
        this.dealer.init().hit();
        this.displayScores();
        this.dealer.hit();
    }

    private void play() {
        this.init();
        while (!this.player.isBust() && this.confirm("\u3082\u3046\uff11\u679a\u30ab\u30fc\u30c9\u3092\u5f15\u304d\u307e\u3059\u304b\uff1f")) {
            this.player.hit();
            this.display("\u30d7\u30ec\u30a4\u30e4\u30fc\uff08\u3042\u306a\u305f\uff09: " + this.player.suits() + " = " + this.player.score());
        }
        if (this.player.isBust()) {
            this.display("\u3042\u306a\u305f\u306f\u3001\u30d0\u30b9\u30c8\u3057\u307e\u3057\u305f...");
        }
        while (this.dealer.score() < 17) {
            this.dealer.hit();
            this.display("\u30c7\u30a3\u30fc\u30e9\u30fc\uff1a\u30d2\u30c3\u30c8 " + this.dealer.suits() + " = " + this.dealer.score());
        }
        this.displayScores();
        this.displayResult();
    }

    public void start() {
        do {
            this.play();
        } while (this.confirm("\u3082\u3046\u4e00\u5ea6\u30d7\u30ec\u30a4\u3057\u307e\u3059\u304b\uff1f"));
    }

    public static void main(String[] args) {
        BlackJack blackjack = new BlackJack();
        blackjack.start();
    }
}

