/*
 * Decompiled with CFR 0.152.
 */
package blackjack;

import blackjack.Deck;
import blackjack.Hand;

public class Player {
    Deck deck;
    Hand hand;

    public Player(Deck deck) {
        this.deck = deck;
        this.init();
    }

    public Player init() {
        this.hand = new Hand();
        return this;
    }

    public Player hit() {
        this.hand.add(this.deck.pull());
        return this;
    }

    public boolean isBust() {
        return this.hand.score() > 21;
    }

    public int score() {
        return this.hand.score();
    }

    public String suits() {
        return this.hand.suits();
    }

    public Result match(Player opponent) {
        if (this.isBust() && opponent.isBust()) {
            return Result.DRAW;
        }
        if (this.isBust() && !opponent.isBust()) {
            return Result.LOST;
        }
        if (opponent.isBust()) {
            return Result.WIN;
        }
        if (this.score() == opponent.score()) {
            if (this.isBlackJack() && opponent.isBlackJack()) {
                return Result.DRAW;
            }
            if (!this.isBlackJack() && opponent.isBlackJack()) {
                return Result.LOST;
            }
            if (this.isBlackJack() && !opponent.isBlackJack()) {
                return Result.WIN;
            }
            return Result.DRAW;
        }
        if (this.score() < opponent.score()) {
            return Result.LOST;
        }
        return Result.WIN;
    }

    public boolean isBlackJack() {
        return this.hand.isBlackJack();
    }

    public static enum Result {
        WIN,
        DRAW,
        LOST;

    }
}

