package blackjack;

import java.util.ArrayList;
import java.util.List;

public class Hand {
    private List<Cards> cards;

    public Hand() {
        cards = new ArrayList<>();
    }

    public Hand add(Cards card) {
        cards.add(card);
        return this;
    }

    private int countAces() {
        int aces = 0;
        for (Cards card: cards) {
            if(card.getScore() == 1){
                aces += 1;
            }
        }
        return aces;
    }

    public String suits(){
        String cardshow = "";
        
        for (Cards card: cards) {
            cardshow = cardshow += card.getCard() + " + ";
        }

        return cardshow;
    }
    
    public int score() {
        int total = 0;

        for (Cards card: cards) {
            total += card.getScore();
        }

        for (int i = 0, aces = countAces(); i < aces; i++) {
            if (total > 21) {
                total -= 10;
            }
        }

        return total;
    }

    public boolean isBlackJack() {
        return cards.size() == 2 && countAces() == 1 && score() == 21;
    }
}
