package com.sun.tools.ant;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Get;

import java.io.File;
import java.io.StringWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/**
 * The extended get task that attempts to download from multiple locations before it fails.
 *
 * @author Kohsuke Kawaguchi
 */
public class FailSafeGetTask extends Task {
    private File dest;
    private boolean usetimestamp;

    private final List sources = new ArrayList();

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setUsetimestamp(boolean usetimestamp) {
        this.usetimestamp = usetimestamp;
    }

    public void addConfiguredSource(Source src) {
        sources.add(src);
    }

    public void execute() throws BuildException {
        if( sources.size()==0 )
            throw new BuildException("no source is specified");
        if( dest==null )
            throw new BuildException("Missing @dest");

        for (int i = 0; i < sources.size(); i++) {
            Source source = (Source) sources.get(i);
            if(!source.isActive(getProject())) {
                log("Skipping "+source.getUrl(),Project.MSG_VERBOSE);
                continue;
            }

            log("Trying "+source.getUrl(),Project.MSG_VERBOSE);

            Get gettask = (Get)getProject().createTask("get");
            gettask.setDest(dest);
            gettask.setUseTimestamp(usetimestamp);
            gettask.setSrc(source.getUrl());

            try {
                gettask.perform();
                return; // if one of the locations is successful, we are done.
            } catch( BuildException e ) {
                log(source.getUrl()+" failed: "+e.getMessage(),Project.MSG_INFO);

                // report the details
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                log(sw.toString(),Project.MSG_VERBOSE);
                // try the next one
            }
        }

        throw new BuildException("Every attempt to download to "+dest+" failed.");
    }
}
