/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import java.util.List;

// import java content classes generated by binding compiler
import example.*;

public class Main {
    
    // This sample application demonstrates how to modify a collection
    // in a java content tree and marshal it back to xml data
    
    public static void main( String[] args ) {
        try {
            // create a JAXBContext capable of handling classes generated into
            // the example package
            JAXBContext jc = JAXBContext.newInstance( "example" );
            
            // create an Unmarshaller
            Unmarshaller u = jc.createUnmarshaller();
            
            // unmarshal a FooBar instance document into a tree of Java content
            // objects composed of classes from the example package.
            FooBar fb = 
                (FooBar)u.unmarshal( new FileInputStream( "example.xml" ) );

	    // read and write unnamed model group bound to Java content interface
	    FooBar.PhoneNumberOrSpeedDial numOrSD = 
					fb.getPhoneNumberOrSpeedDial();
	    System.out.println("PhoneNumberOrSpeedDial value:" + numOrSD.getContent()+
		               " isPhoneNumber:" + numOrSD.isSetPhoneNumber() + 
		               " isSpeedDial:" + numOrSD.isSetSpeedDial());
            numOrSD.setSpeedDial(22);
	    
	    // read and write model group def.bound to Java content interface
            ModelGroupChoice mgc = fb.getModelGroupChoice();
	    System.out.println("ModelGroupChoice value:" + mgc.getContent()+
		               " isBool:" + mgc.isSetBool() + 
		               " isComment:" + mgc.isSetComment() + 
		               " isValue:" + mgc.isSetValue());
	    mgc.setBool(false);
	     
            // create a Marshaller and marshal to a file
            Marshaller m = jc.createMarshaller();
            m.setProperty( Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE );
            m.marshal( fb, System.out );
            
        } catch( JAXBException je ) {
            je.printStackTrace();
        } catch( IOException ioe ) {
            ioe.printStackTrace();
        }
    }
}
