/*
 * @(#)$Id: Name.java,v 1.1 2002/11/02 22:30:21 kk122374 Exp $
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.sun.relaxng.javadt;

import java.util.HashSet;

public class Name {
    
    /**
     * Checks if a given string is usable as a Java identifier.
     */
    public static boolean isJavaIdentifier( String token ) {
        
        if( token.length()==0 )  return false;
        
        if( reservedKeywords.contains(token) )  return false;
        
        if(!Character.isJavaIdentifierStart(token.charAt(0)))   return false;
        
        for (int i = 1; i < token.length(); i++)
            if (!Character.isJavaIdentifierPart(token.charAt(i)))
                return false;
                
        return true;
    }

    /**
     * Checks if the given string is a valid Java package name.
     */
    public static boolean isJavaPackageName(String s) {
        while(s.length()!=0) {
            int idx = s.indexOf('.');
            if(idx==-1) idx=s.length();
            if( !isJavaIdentifier(s.substring(0,idx)) )
                return false;
            
            s = s.substring(idx);
            if(s.length()!=0)    s = s.substring(1);    // remove '.'
        }
        return true;
    }


    /** All reserved keywords of Java. */
    private static HashSet reservedKeywords = new HashSet();
    
    static {
        // see http://java.sun.com/docs/books/tutorial/java/nutsandbolts/_keywords.html
        String[] words = new String[]{
            "abstract",
            "boolean",
            "break",
            "byte",
            "case",
            "catch",
            "char",
            "class",
            "const",
            "continue",
            "default",
            "do",
            "double",
            "else",
            "extends",
            "final",
            "finally",
            "float",
            "for",
            "goto",
            "if",
            "implements",
            "import",
            "instanceof",
            "int",
            "interface",
            "long",
            "native",
            "new",
            "package",
            "private",
            "protected",
            "public",
            "return",
            "short",
            "static",
            "strictfp",
            "super",
            "switch",
            "synchronized",
            "this",
            "throw",
            "throws",
            "transient",
            "try",
            "void",
            "volatile",
            "while",
            
            // technically these are not reserved words but they cannot be used as identifiers.
            "true",
            "false",
            "null",
            
            // and I believe assert is also a new keyword
            "assert"
            };
        for( int i=0; i<words.length; i++ )
            reservedKeywords.add(words[i]);
    }
}
