/*
 *  The MIT License
 *
 *  Copyright 2011 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.widget.Toast;
import org.routine_work.simple_battery_logger.R;

/**
 *
 * @author sawai
 */
public class ExportOneDayDataCsvFileCompletedReceiver extends BroadcastReceiver
{
	// broadcast
	public static final String EXPORT_ONE_DAY_DATA_CSV_FILE_COMPLETED_ACTION = "EXPORT_ONE_DAY_DATA_CSV_FILE_COMPLETED";
	public static final String EXTRA_RESULT = "Result";

	@Override
	public void onReceive(Context context, Intent intent)
	{
		boolean result = intent.getBooleanExtra(EXTRA_RESULT, true);

		Resources resources = context.getResources();
		String message;
		if (result)
			message = resources.getString(R.string.export_csv_file_succeeded);
		else
			message = resources.getString(R.string.export_csv_file_failed);

		Toast.makeText(context, message, Toast.LENGTH_LONG).show();

	}
}