/*
 * Decompiled with CFR 0.152.
 */
package nekora.cwn.mix;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;
import nekora.cwn.mix.MixOut;
import nekora.cwn.paper.InputPaper;

public class MixOut2in1
extends MixOut {
    public MixOut2in1(InputPaper ip, Point baseSize, int borderPixel, Logger logger) {
        super(ip, baseSize, borderPixel, logger);
        logger.info("start");
        this.ip.computeLR(this.baseSize.x, this.baseSize.y);
        logger.info("end");
    }

    @Override
    public String make(String outputFileName, String leftFileName, String rightFileName) {
        String ret;
        block25: {
            String baseSizeText = String.valueOf(this.baseSize.x) + "x" + this.baseSize.y;
            ret = String.valueOf(leftFileName) + " + " + rightFileName + " \u21d2 " + outputFileName + " (" + baseSizeText + ")";
            this.logger.info("start=" + ret);
            MagickImage leftImage = null;
            MagickImage cropImageL = null;
            MagickImage rightImage = null;
            MagickImage cropImageR = null;
            MagickImage baseImage = null;
            MagickImage cropImageALL = null;
            try {
                try {
                    ImageInfo leftInfo = new ImageInfo(leftFileName);
                    leftImage = new MagickImage(leftInfo);
                    cropImageL = leftImage.cropImage(this.ip.getCropL());
                    this.logger.info("\u5de6\u753b\u50cf\u6e96\u5099\u5b8c\u4e86");
                    ImageInfo rightInfo = new ImageInfo(rightFileName);
                    rightImage = new MagickImage(rightInfo);
                    cropImageR = rightImage.cropImage(this.ip.getCropR());
                    this.logger.info("\u53f3\u753b\u50cf\u6e96\u5099\u5b8c\u4e86");
                    ImageInfo baseInfo = new ImageInfo("xc:white");
                    baseInfo.setSize(baseSizeText);
                    baseInfo.setColorspace(2);
                    baseImage = new MagickImage(baseInfo);
                    this.logger.info("\u30d9\u30fc\u30b9\u753b\u50cf\u6e96\u5099\u5b8c\u4e86");
                    baseImage.compositeImage(20, cropImageL, this.ip.getPutL().x, this.ip.getPutL().y);
                    baseImage.compositeImage(20, cropImageR, this.ip.getPutR().x, this.ip.getPutR().y);
                    this.logger.info("\u5408\u6210\u51e6\u7406\u5b8c\u4e86");
                    if (this.borderPixel > 0) {
                        Rectangle cropALL = new Rectangle(this.borderPixel, this.borderPixel, this.baseSize.x - this.borderPixel * 2, this.baseSize.y - this.borderPixel * 2);
                        cropImageALL = baseImage.cropImage(cropALL);
                        cropImageALL.setCompression(8);
                        cropImageALL.setFileName(outputFileName);
                        cropImageALL.writeImage(new ImageInfo());
                    } else {
                        baseImage.setCompression(8);
                        baseImage.setFileName(outputFileName);
                        baseImage.writeImage(new ImageInfo());
                    }
                }
                catch (MagickException e) {
                    String msg = e.getLocalizedMessage();
                    this.logger.log(Level.WARNING, "\u51e6\u7406\u5931\u6557 ERROR=" + msg, e);
                    e.printStackTrace();
                    if (cropImageALL != null) {
                        cropImageALL.destroyImages();
                        cropImageALL = null;
                    }
                    if (baseImage != null) {
                        baseImage.destroyImages();
                        baseImage = null;
                    }
                    if (cropImageR != null) {
                        cropImageR.destroyImages();
                        cropImageR = null;
                    }
                    if (rightImage != null) {
                        rightImage.destroyImages();
                        rightImage = null;
                    }
                    if (cropImageL != null) {
                        cropImageL.destroyImages();
                        cropImageL = null;
                    }
                    if (leftImage != null) {
                        leftImage.destroyImages();
                        leftImage = null;
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (cropImageALL != null) {
                    cropImageALL.destroyImages();
                    cropImageALL = null;
                }
                if (baseImage != null) {
                    baseImage.destroyImages();
                    baseImage = null;
                }
                if (cropImageR != null) {
                    cropImageR.destroyImages();
                    cropImageR = null;
                }
                if (rightImage != null) {
                    rightImage.destroyImages();
                    rightImage = null;
                }
                if (cropImageL != null) {
                    cropImageL.destroyImages();
                    cropImageL = null;
                }
                if (leftImage != null) {
                    leftImage.destroyImages();
                    leftImage = null;
                }
                throw throwable;
            }
            if (cropImageALL != null) {
                cropImageALL.destroyImages();
                cropImageALL = null;
            }
            if (baseImage != null) {
                baseImage.destroyImages();
                baseImage = null;
            }
            if (cropImageR != null) {
                cropImageR.destroyImages();
                cropImageR = null;
            }
            if (rightImage != null) {
                rightImage.destroyImages();
                rightImage = null;
            }
            if (cropImageL != null) {
                cropImageL.destroyImages();
                cropImageL = null;
            }
            if (leftImage != null) {
                leftImage.destroyImages();
                leftImage = null;
            }
        }
        this.logger.info("\u7d42\u4e86=" + ret);
        return ret;
    }
}

