/*
 * Decompiled with CFR 0.152.
 */
package nekora.cwn;

import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import nekora.cwn.ExtCmdProcessKicker;
import nekora.cwn.align.PageAlign;
import nekora.cwn.ext.ExtCmd;
import nekora.cwn.mix.MixOut;
import nekora.cwn.paper.InputPaper;

class MDPSTask
extends Task<String> {
    private PageAlign pa;
    private String outputDirName;
    private InputPaper ip;
    private Point baseSize;
    private int dpi;
    private String outsizeName;
    private int borderPixel;
    private ExtCmd cmd;
    private Logger logger;
    private final String WORK_EXT = ".tif";

    MDPSTask(PageAlign pa, String outputDirName, InputPaper ip, Point baseSize, int dpi, int borderPixel, String outsize, ExtCmd cmd, Logger logger) {
        this.pa = pa;
        this.outputDirName = outputDirName;
        this.ip = ip;
        this.baseSize = baseSize;
        this.dpi = dpi;
        this.borderPixel = borderPixel;
        this.outsizeName = outsize;
        this.cmd = cmd;
        this.logger = logger;
    }

    protected String call() throws Exception {
        this.logger.info("start " + Thread.currentThread().getName());
        this.updateMessage("\u958b\u59cb");
        this.logger.info("Before pa.exec " + this.pa);
        List<File> alignList = this.pa.exec();
        int max = alignList.size();
        this.logger.info("Before updateProgress");
        this.updateProgress(0L, max);
        File workDir = new File(this.outputDirName);
        ExecutorService exec = Executors.newFixedThreadPool(1);
        ArrayList<Future<String>> resultList = new ArrayList<Future<String>>();
        this.logger.info("Before createMixOut");
        MixOut mx = this.pa.createMixOut(this.ip, this.baseSize, max, this.logger);
        int pagenum = 1;
        this.logger.info("Before for loop. size=" + alignList.size());
        int i = 0;
        while (i < alignList.size()) {
            String outputFilePre = String.valueOf(this.outputDirName) + File.separator + this.outsizeName + "_" + this.pa.getFileName(pagenum);
            File file = new File(String.valueOf(outputFilePre) + this.cmd.getExt());
            File fL = alignList.get(i);
            File fR = alignList.get(i + 1);
            String msg = String.valueOf(fL.getName()) + " , " + fR.getName() + "\u3000\u21d2\u3000" + this.pa.getFileName(pagenum) + this.cmd.getExt();
            this.logger.info(String.valueOf(msg) + " \u3092\u51e6\u7406\u4e2d\u2026");
            this.updateMessage(String.valueOf(msg) + " \u3092\u51e6\u7406\u4e2d\u2026");
            if (file.lastModified() > fL.lastModified() && file.lastModified() > fR.lastModified()) {
                this.logger.info(String.valueOf(msg) + "\u3000\u6700\u7d42\u30d5\u30a1\u30a4\u30eb\u304c\u65b0\u3057\u3044\u306e\u3067\u30b9\u30ad\u30c3\u30d7");
            } else {
                String outputFileName = String.valueOf(outputFilePre) + this.cmd.getTmpExt();
                mx.make(outputFileName, fL.getCanonicalPath(), fR.getCanonicalPath());
                ProcessBuilder pb = this.cmd.getProcessBuilder(this.dpi, outputFileName);
                if (pb != null) {
                    resultList.add(exec.submit(new ExtCmdProcessKicker(pb, workDir, this.logger)));
                    this.logger.info("\u5b50\u30d7\u30ed\u30bb\u30b9\u8d77\u52d5\u958b\u59cb\u6e08 " + outputFileName);
                } else {
                    this.logger.info("\u5b50\u30d7\u30ed\u30bb\u30b9\u8d77\u52d5\u306a\u3057");
                }
            }
            this.updateProgress(i + 1, max);
            ++pagenum;
            i += 2;
        }
        exec.shutdown();
        this.updateMessage("\u6700\u7d42\u51e6\u7406\u5b8c\u4e86\u5f85\u3061\u2026");
        int num = 1;
        int listsize = resultList.size();
        for (Future future : resultList) {
            try {
                String msg = "\u6700\u7d42\u51e6\u7406\u4e2d... " + num + " / " + listsize;
                this.logger.info(msg);
                this.updateMessage(msg);
                future.get();
                ++num;
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "\u30b3\u30de\u30f3\u30c9\u7d42\u4e86\u5f85\u3061\u4e2d\u306bInterrupt", e.getLocalizedMessage());
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                this.logger.log(Level.WARNING, "\u30b3\u30de\u30f3\u30c9\u7d42\u4e86\u5f85\u3061\u4e2d\u306b\u5b9f\u884c\u6642\u30a8\u30e9\u30fc(\u3057\u304b\u3057\u51e6\u7406\u306f\u7d9a\u884c)", e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (this.cmd.getExt().equalsIgnoreCase(".tif")) {
            this.logger.info("TIF\u30d5\u30a1\u30a4\u30eb\u524a\u9664\u306f\u3057\u306a\u3044 " + this.outputDirName);
        } else {
            this.logger.info("\u4f5c\u696d\u7528TIF\u30d5\u30a1\u30a4\u30eb\u524a\u9664 " + this.outputDirName);
        }
        this.updateProgress(max, max);
        this.updateMessage("\u5168\u90e8\u5b8c\u4e86");
        this.logger.info("end");
        return "Done";
    }
}

