/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.internal.ConcurrentSoftHashMap;
import jp.syuriken.snsw.twclient.internal.NullStatus;
import jp.syuriken.snsw.twclient.internal.NullUser;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

public class CacheManager {
    protected static final User ERROR_USER = new NullUser();
    protected static final Status ERROR_STATUS = new NullStatus();
    protected static final int MAX_USERS_PER_LOOKUP_REQUEST = 100;
    protected final ConcurrentSoftHashMap<Long, Status> statusCacheMap;
    protected final ConcurrentSoftHashMap<Long, User> userCacheMap;
    protected final ConcurrentLinkedQueue<Long> userCacheQueue;
    protected final AtomicInteger userCacheQueueLength;
    protected final Twitter twitter;
    protected final ClientConfiguration configuration;

    public CacheManager(ClientConfiguration configuration) {
        this.configuration = configuration;
        ClientProperties properties = configuration.getConfigProperties();
        int concurrency = properties.getInteger("core.cache.data.concurrency");
        float loadFactor = properties.getFloat("core.cache.data.load_factor");
        int initialCapacity = properties.getInteger("core.cache.data.initial_capacity");
        this.statusCacheMap = new ConcurrentSoftHashMap(configuration, concurrency, loadFactor, initialCapacity);
        this.userCacheMap = new ConcurrentSoftHashMap(configuration, concurrency, loadFactor, initialCapacity);
        this.userCacheQueue = new ConcurrentLinkedQueue();
        this.userCacheQueueLength = new AtomicInteger();
        this.twitter = configuration.getTwitterForRead();
    }

    public void cacheStatus(Status status) {
        if (status == null) {
            throw new NullPointerException();
        }
        this.statusCacheMap.put(status.getId(), status);
    }

    public Status cacheStatusIfAbsent(Status status) {
        if (status == null) {
            throw new NullPointerException();
        }
        return this.statusCacheMap.putIfAbsent(status.getId(), status);
    }

    public void cacheUser(User user) {
        if (user == null) {
            throw new NullPointerException();
        }
        this.userCacheMap.put(user.getId(), user);
    }

    public User cacheUserIfAbsent(User user) {
        if (user == null) {
            throw new NullPointerException();
        }
        return this.userCacheMap.putIfAbsent(user.getId(), user);
    }

    private Status extract(Status status) {
        if (status == ERROR_STATUS) {
            return null;
        }
        return status;
    }

    private User extract(User user) {
        if (user == ERROR_USER) {
            return null;
        }
        return user;
    }

    public Status getCachedStatus(long statusId) {
        return this.extract(this.statusCacheMap.get(statusId));
    }

    public User getCachedUser(long userId) {
        return this.extract(this.userCacheMap.get(userId));
    }

    public Status getStatus(long statusId) {
        Status status = this.statusCacheMap.get(statusId);
        if (status == null) {
            new StatusFetcher(statusId).run();
            status = this.statusCacheMap.get(statusId);
        }
        return this.extract(status);
    }

    public Collection<Status> getStatusSet() {
        return this.statusCacheMap.values();
    }

    public User getUser(long userId) {
        User user = this.userCacheMap.get(userId);
        if (user == null) {
            this.userCacheQueue.add(userId);
            int len = this.userCacheQueueLength.incrementAndGet();
            do {
                this.runUserFetcher(len, false);
            } while ((len = this.userCacheQueueLength.get()) > 0);
            user = this.userCacheMap.get(userId);
        }
        return this.extract(user);
    }

    public Collection<User> getUserSet() {
        return this.userCacheMap.values();
    }

    public boolean isCachedStatus(long statusId) {
        return this.statusCacheMap.containsKey(statusId);
    }

    public boolean isCachedUser(long userId) {
        return this.userCacheMap.containsKey(userId);
    }

    public void queueFetchingStatus(long statusId) {
        this.configuration.addJob(new StatusFetcher(statusId));
    }

    public void queueFetchingUser(long userId) {
        if (this.userCacheMap.containsKey(userId)) {
            return;
        }
        this.userCacheQueue.offer(userId);
        int len = this.userCacheQueueLength.incrementAndGet();
        if (len > 100) {
            this.runUserFetcher(len, true);
        }
    }

    public void removeCachedStatus(long statusId) {
        this.statusCacheMap.remove(statusId);
    }

    public void removeCachedUser(long userId) {
        this.userCacheMap.remove(userId);
    }

    protected boolean runUserFetcher(int expectedLength, boolean intoQueue) {
        Long userId;
        int i;
        int newLength = expectedLength - 100;
        if (newLength < 0) {
            newLength = 0;
        }
        if (!this.userCacheQueueLength.compareAndSet(expectedLength, newLength)) {
            return false;
        }
        int len = expectedLength - newLength;
        long[] arr = new long[len];
        for (i = 0; i < len && (userId = this.userCacheQueue.poll()) != null; ++i) {
            arr[i] = userId;
        }
        if (i != len) {
            arr = Arrays.copyOf(arr, i);
        }
        UserFetcher userFetcher = new UserFetcher(arr, intoQueue);
        if (intoQueue) {
            this.configuration.addJob(userFetcher);
        } else {
            userFetcher.run();
        }
        return true;
    }

    private class UserFetcher
    extends TwitterRunnable
    implements ParallelRunnable {
        private final Logger logger;
        private long[] userIds;

        public UserFetcher(long[] userIds, boolean intoQueue) {
            super(intoQueue);
            this.logger = LoggerFactory.getLogger(UserFetcher.class);
            Arrays.sort(userIds);
            this.userIds = userIds;
        }

        @Override
        protected void access() throws TwitterException {
            ResponseList users = CacheManager.this.twitter.lookupUsers(this.userIds);
            for (User user : users) {
                CacheManager.this.cacheUser(user);
            }
            for (long userId : this.userIds) {
                if (CacheManager.this.isCachedUser(userId)) continue;
                this.logger.info("not found: userId={}", (Object)userId);
                CacheManager.this.userCacheMap.put(userId, ERROR_USER);
            }
        }

        @Override
        protected ClientConfiguration getConfiguration() {
            return CacheManager.this.configuration;
        }
    }

    protected class StatusFetcher
    extends TwitterRunnable
    implements ParallelRunnable {
        private final Logger logger = LoggerFactory.getLogger(StatusFetcher.class);
        private long statusId;

        public StatusFetcher(long statusId) {
            this.statusId = statusId;
        }

        @Override
        protected void access() throws TwitterException {
            CacheManager.this.cacheStatus(CacheManager.this.twitter.showStatus(this.statusId));
        }

        @Override
        protected ClientConfiguration getConfiguration() {
            return CacheManager.this.configuration;
        }

        @Override
        protected void handleException(TwitterException ex) {
            if (ex.getStatusCode() == 404) {
                this.logger.info("not found: statusId={}", (Object)this.statusId);
                CacheManager.this.statusCacheMap.put(this.statusId, ERROR_STATUS);
            }
        }
    }
}

