/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Random;
import java.util.Stack;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jp.syuriken.snsw.twclient.ActionHandler;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientFrameApi;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.ClientTab;
import jp.syuriken.snsw.twclient.ImageCacher;
import jp.syuriken.snsw.twclient.SortedPostListPanel;
import jp.syuriken.snsw.twclient.StatusData;
import jp.syuriken.snsw.twclient.StatusPanel;
import jp.syuriken.snsw.twclient.TabRenderer;
import jp.syuriken.snsw.twclient.TwitterClientFrame;
import jp.syuriken.snsw.twclient.TwitterStatus;
import jp.syuriken.snsw.twclient.Utility;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import jp.syuriken.snsw.twclient.filter.TeeFilter;
import jp.syuriken.snsw.twclient.internal.ScrollUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.HashtagEntity;
import twitter4j.MediaEntity;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserMentionEntity;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public abstract class DefaultClientTab
implements ClientTab {
    protected static final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    protected static final Random random = new Random();
    static final int PADDING_OF_POSTLIST = 1;
    public static final ImageIcon IMG_FAV_OFF;
    public static final ImageIcon IMG_FAV_ON;
    public static final ImageIcon IMG_FAV_HOVER;
    private static final Dimension OPERATION_PANEL_SIZE;
    public static final ImageIcon IMG_TWITTER_LOGO;
    protected final ClientFrameApi frameApi;
    protected final SortedPostListPanel sortedPostListPanel;
    protected final ClientConfiguration configuration;
    protected final ImageCacher imageCacher;
    protected final PostListListener postListListenerSingleton = new PostListListener();
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ClientProperties configProperties;
    protected final String uniqId;
    protected Stack<StatusPanel> inReplyToStack = new Stack();
    public StatusPanel selectingPost;
    protected FontMetrics fontMetrics;
    protected int fontHeight;
    protected Dimension linePanelSizeOfSentBy;
    protected Dimension iconSize;
    protected TreeMap<String, ArrayList<StatusPanel>> listItems = new TreeMap();
    protected TreeMap<Long, StatusPanel> statusMap = new TreeMap();
    protected JScrollPane postListScrollPane;
    protected LinkedList<StatusPanel> postListAddQueue = new LinkedList();
    protected JPopupMenu tweetPopupMenu;
    protected ScrollUtility scroller;
    protected Utility utility;
    protected JPanel tweetViewOperationPanel;
    protected JLabel tweetViewFavoriteButton;
    protected JLabel tweetViewRetweetButton;
    protected JLabel tweetViewReplyButton;
    protected JLabel tweetViewOtherButton;
    protected TabRenderer teeFilter;

    protected static StringBuilder escapeHTML(CharSequence text) {
        return DefaultClientTab.escapeHTML(text, new StringBuilder(text.length() * 2));
    }

    protected static StringBuilder escapeHTML(CharSequence text, StringBuilder appendTo) {
        int len = text.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    appendTo.append("&amp;");
                    continue block9;
                }
                case '>': {
                    appendTo.append("&gt;");
                    continue block9;
                }
                case '<': {
                    appendTo.append("&lt;");
                    continue block9;
                }
                case '\"': {
                    appendTo.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    appendTo.append("&#39;");
                    continue block9;
                }
                case '\n': {
                    appendTo.append("<br>");
                    continue block9;
                }
                case ' ': {
                    appendTo.append("&nbsp;");
                    continue block9;
                }
                default: {
                    appendTo.append(c);
                }
            }
        }
        return appendTo;
    }

    protected DefaultClientTab(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.configProperties = configuration.getConfigProperties();
        this.imageCacher = configuration.getImageCacher();
        this.frameApi = configuration.getFrameApi();
        this.utility = configuration.getUtility();
        this.sortedPostListPanel = new SortedPostListPanel();
        this.uniqId = this.getTabId() + "_" + Integer.toHexString(random.nextInt());
        this.init(configuration);
    }

    protected DefaultClientTab(ClientConfiguration configuration, JSONObject serializedJson) throws JSONException {
        this.configuration = configuration;
        this.configProperties = configuration.getConfigProperties();
        this.imageCacher = configuration.getImageCacher();
        this.frameApi = configuration.getFrameApi();
        this.utility = configuration.getUtility();
        this.sortedPostListPanel = new SortedPostListPanel();
        this.uniqId = serializedJson.getString("uniqId");
        this.init(configuration);
    }

    protected DefaultClientTab(ClientConfiguration configuration, String serializedJson) throws JSONException {
        this(configuration, new JSONObject(serializedJson));
    }

    public void addStatus(Status originalStatus) {
        JLabel statusText;
        String screenName;
        Status twitterStatus = originalStatus instanceof TwitterStatus ? originalStatus : new TwitterStatus(this.configuration, originalStatus);
        StatusData statusData = new StatusData(twitterStatus, twitterStatus.getCreatedAt(), twitterStatus.getId());
        Status status = twitterStatus.isRetweet() ? twitterStatus.getRetweetedStatus() : twitterStatus;
        User user = status.getUser();
        if (this.configProperties.getBoolean("core.id_strict_match")) {
            if (user.getId() == this.frameApi.getLoginUser().getId()) {
                statusData.foregroundColor = Color.BLUE;
            }
        } else if (user.getScreenName().startsWith(this.frameApi.getLoginUser().getScreenName())) {
            statusData.foregroundColor = Color.BLUE;
        }
        JLabel icon = new JLabel();
        this.imageCacher.setImageIcon(icon, status.getUser());
        icon.setHorizontalAlignment(0);
        statusData.image = icon;
        statusData.user = screenName = user.getScreenName();
        if (screenName.length() > 11) {
            screenName = screenName.substring(0, 9) + "..";
        }
        JLabel sentBy = new JLabel(screenName);
        sentBy.setFont(TwitterClientFrame.DEFAULT_FONT);
        statusData.sentBy = sentBy;
        statusData.data = statusText = new JLabel(status.getText());
        statusData.popupMenu = this.tweetPopupMenu;
        if (twitterStatus.isRetweet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Retweeted by @").append(twitterStatus.getUser().getScreenName());
            statusData.tooltip = stringBuilder.toString();
        }
        if (twitterStatus.isRetweet()) {
            statusData.foregroundColor = Color.GREEN;
        } else {
            UserMentionEntity[] userMentionEntities = status.getUserMentionEntities();
            if (this.isMentioned(userMentionEntities)) {
                statusData.foregroundColor = Color.RED;
            }
        }
        this.addStatus(statusData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusPanel addStatus(StatusData statusData) {
        StatusPanel linePanel = new StatusPanel(statusData);
        BoxLayout layout = new BoxLayout(linePanel, 0);
        linePanel.setLayout(layout);
        linePanel.setAlignmentX(0.0f);
        statusData.image.setInheritsPopupMenu(true);
        statusData.image.setFocusable(false);
        statusData.image.setMinimumSize(this.iconSize);
        statusData.image.setMaximumSize(this.iconSize);
        linePanel.add(statusData.image);
        linePanel.add(Box.createHorizontalStrut(3));
        statusData.sentBy.setInheritsPopupMenu(true);
        statusData.sentBy.setFocusable(false);
        statusData.sentBy.setMinimumSize(this.linePanelSizeOfSentBy);
        statusData.sentBy.setMaximumSize(this.linePanelSizeOfSentBy);
        statusData.sentBy.setFont(this.frameApi.getDefaultFont());
        linePanel.add(statusData.sentBy);
        linePanel.add(Box.createHorizontalStrut(3));
        statusData.data.setInheritsPopupMenu(true);
        statusData.data.setFocusable(false);
        statusData.data.setFont(this.frameApi.getDefaultFont());
        int dataWidth = this.fontMetrics.stringWidth(statusData.data.getText());
        linePanel.add(statusData.data);
        linePanel.setComponentPopupMenu(statusData.popupMenu);
        linePanel.setForeground(statusData.foregroundColor);
        linePanel.setBackground(statusData.backgroundColor);
        int height = this.iconSize.height + 1;
        Dimension minSize = new Dimension(this.iconSize.width + this.linePanelSizeOfSentBy.width + dataWidth + 6, height);
        linePanel.setMinimumSize(minSize);
        linePanel.setPreferredSize(minSize);
        linePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
        linePanel.setFocusable(true);
        linePanel.setToolTipText(statusData.tooltip);
        linePanel.addMouseListener(this.postListListenerSingleton);
        linePanel.addFocusListener(this.postListListenerSingleton);
        linePanel.addKeyListener(this.postListListenerSingleton);
        statusData.image.setForeground(statusData.foregroundColor);
        statusData.sentBy.setForeground(statusData.foregroundColor);
        statusData.data.setForeground(statusData.foregroundColor);
        Cloneable cloneable = this.listItems;
        synchronized (cloneable) {
            this.statusMap.put(statusData.id, linePanel);
            ArrayList<StatusPanel> list = this.listItems.get(statusData.user);
            if (list == null) {
                list = new ArrayList();
                this.listItems.put(statusData.user, list);
            }
            list.add(linePanel);
        }
        cloneable = this.postListAddQueue;
        synchronized (cloneable) {
            this.postListAddQueue.add(linePanel);
        }
        return linePanel;
    }

    public JPanel addStatus(StatusData statusData, int deletionDelay) {
        StatusPanel status = this.addStatus(statusData);
        this.removeStatus(statusData, deletionDelay);
        return status;
    }

    protected void focusGainOfLinePanel(FocusEvent e) throws IllegalArgumentException, NumberFormatException {
        if (this.selectingPost != null) {
            this.selectingPost.setBackground(this.selectingPost.getStatusData().backgroundColor);
        }
        this.selectingPost = (StatusPanel)e.getComponent();
        this.selectingPost.setBackground(Utility.blendColor(this.selectingPost.getStatusData().backgroundColor, this.configProperties.getColor("gui.color.list.focus")));
        StatusData statusData = this.selectingPost.getStatusData();
        if (statusData.tag instanceof TwitterStatus) {
            TwitterStatus originalStatus = (TwitterStatus)statusData.tag;
            TwitterStatus status = originalStatus.isRetweet() ? originalStatus.getRetweetedStatus() : originalStatus;
            String text = status.getText();
            StringBuilder stringBuilder = new StringBuilder(text.length() * 2);
            HashtagEntity[] hashtagEntities = status.getHashtagEntities();
            int entitiesLen = hashtagEntities == null ? 0 : hashtagEntities.length;
            URLEntity[] urlEntities = status.getURLEntities();
            entitiesLen += urlEntities == null ? 0 : urlEntities.length;
            MediaEntity[] mediaEntities = status.getMediaEntities();
            entitiesLen += mediaEntities == null ? 0 : mediaEntities.length;
            UserMentionEntity[] mentionEntities = status.getUserMentionEntities();
            Object[] entities = new Object[entitiesLen += mentionEntities == null ? 0 : mentionEntities.length];
            if (entitiesLen != 0) {
                int copyOffset = 0;
                if (hashtagEntities != null) {
                    System.arraycopy(hashtagEntities, 0, entities, copyOffset, hashtagEntities.length);
                    copyOffset += hashtagEntities.length;
                }
                if (urlEntities != null) {
                    System.arraycopy(urlEntities, 0, entities, copyOffset, urlEntities.length);
                    copyOffset += urlEntities.length;
                }
                if (mediaEntities != null) {
                    System.arraycopy(mediaEntities, 0, entities, copyOffset, mediaEntities.length);
                    copyOffset += mediaEntities.length;
                }
                if (mentionEntities != null) {
                    System.arraycopy(mentionEntities, 0, entities, copyOffset, mentionEntities.length);
                }
            }
            Arrays.sort(entities, new EntityComparator());
            int offset = 0;
            for (Object entity : entities) {
                String url;
                String replaceText;
                int end;
                int start;
                if (entity instanceof HashtagEntity) {
                    HashtagEntity hashtagEntity = (HashtagEntity)entity;
                    start = TwitterStatus.getEntityStart(hashtagEntity);
                    end = TwitterStatus.getEntityEnd(hashtagEntity);
                    replaceText = null;
                    url = "http://command/hashtag!" + hashtagEntity.getText();
                } else if (entity instanceof URLEntity) {
                    URLEntity urlEntity = (URLEntity)entity;
                    url = urlEntity.getURL();
                    start = TwitterStatus.getEntityStart(urlEntity);
                    end = TwitterStatus.getEntityEnd(urlEntity);
                    replaceText = urlEntity.getDisplayURL();
                } else if (entity instanceof UserMentionEntity) {
                    UserMentionEntity mentionEntity = (UserMentionEntity)entity;
                    start = TwitterStatus.getEntityStart(mentionEntity);
                    end = TwitterStatus.getEntityEnd(mentionEntity);
                    replaceText = null;
                    url = "http://command/userinfo!" + mentionEntity.getScreenName();
                } else {
                    throw new AssertionError();
                }
                String insertText = "<a href=\"" + url + "\">" + DefaultClientTab.escapeHTML(replaceText == null ? text.substring(start, end) : replaceText) + "</a>";
                stringBuilder.append((CharSequence)DefaultClientTab.escapeHTML(text.substring(offset, start)));
                stringBuilder.append(insertText);
                offset = end;
            }
            DefaultClientTab.escapeHTML(text.substring(offset), stringBuilder);
            String tweetText = stringBuilder.toString();
            String createdBy = MessageFormat.format("@{0} ({1})", status.getUser().getScreenName(), status.getUser().getName());
            String source = status.getSource();
            int tagIndexOf = source.indexOf(62);
            int tagLastIndexOf = source.lastIndexOf(60);
            String createdAtToolTip = MessageFormat.format("from {0}", source.substring(tagIndexOf + 1, tagLastIndexOf == -1 ? source.length() : tagLastIndexOf));
            String createdAt = Utility.getDateString(status.getCreatedAt(), true);
            String overlayString = originalStatus.isRetweet() ? "<html><span style='color:#33cc33;'>Retweeted by @" + originalStatus.getUser().getScreenName() + " (" + originalStatus.getUser().getName() + ")</span>" : null;
            if (status.isFavorited()) {
                this.getTweetViewFavoriteButton().setIcon(IMG_FAV_ON);
            } else {
                this.getTweetViewFavoriteButton().setIcon(IMG_FAV_OFF);
            }
            Icon userProfileIcon = ((JLabel)statusData.image).getIcon();
            this.frameApi.clearTweetView();
            this.frameApi.setTweetViewCreatedAt(createdAt, createdAtToolTip, 3);
            this.frameApi.setTweetViewCreatedBy(userProfileIcon, createdBy, null, 3);
            this.frameApi.setTweetViewText(tweetText, overlayString, 2);
            this.frameApi.setTweetViewOperationPanel(this.getTweetViewOperationPanel());
        } else if (statusData.tag instanceof Exception) {
            Exception ex = (Exception)statusData.tag;
            Throwable handlingException = ex;
            StringBuilder stringBuilder = new StringBuilder(ex.getLocalizedMessage()).append("<br><br>");
            while (null != (handlingException = handlingException.getCause())) {
                stringBuilder.append("Caused by ").append(handlingException.toString()).append("<br>");
            }
            StringBuilder escaped = DefaultClientTab.escapeHTML(stringBuilder);
            this.frameApi.clearTweetView();
            this.frameApi.setTweetViewText(escaped.toString(), null, 0);
            this.frameApi.setTweetViewCreatedAt(Utility.getDateFormat().format(statusData.date), null, 0);
            this.frameApi.setTweetViewCreatedBy(((JLabel)statusData.image).getIcon(), ex.getClass().getName(), null, 0);
        } else {
            this.frameApi.clearTweetView();
            this.frameApi.setTweetViewText(statusData.data.getText(), null, 0);
            this.frameApi.setTweetViewCreatedAt(Utility.getDateFormat().format(statusData.date), null, 0);
            this.frameApi.setTweetViewCreatedBy(((JLabel)statusData.image).getIcon(), statusData.user, null, 0);
        }
    }

    @Override
    public void focusGained() {
        if (this.selectingPost != null) {
            this.selectingPost.requestFocusInWindow();
        }
    }

    public abstract TabRenderer getActualRenderer();

    protected JComponent getChildComponent() {
        return this.getSortedPostListPanel();
    }

    @Override
    public TabRenderer getRenderer() {
        if (this.teeFilter == null) {
            try {
                this.teeFilter = new TeeFilter(this.configuration, this.uniqId, this.getActualRenderer());
            }
            catch (IllegalSyntaxException e) {
                this.logger.error("TeeFilter\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093\u3002filter query\u306f\u7121\u8996\u3055\u308c\u307e\u3059", (Throwable)e);
                this.teeFilter = this.getActualRenderer();
            }
        }
        return this.teeFilter;
    }

    protected JScrollPane getScrollPane() {
        if (this.postListScrollPane == null) {
            this.postListScrollPane = new JScrollPane(){

                @Override
                protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                    switch (ks.getKeyCode()) {
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: {
                            return false;
                        }
                    }
                    return super.processKeyBinding(ks, e, condition, pressed);
                }

                @Override
                protected void processKeyEvent(KeyEvent e) {
                    DefaultClientTab.this.logger.trace("jscrollpane#processKeyEvent: {}", (Object)e);
                }
            };
            this.postListScrollPane.getViewport().setView(this.getChildComponent());
            this.postListScrollPane.getVerticalScrollBar().setUnitIncrement(this.configProperties.getInteger("gui.list.scroll"));
        }
        return this.postListScrollPane;
    }

    @Override
    public String getSerializedData() {
        try {
            return new JSONObject().put("twitterId", (Object)"reader").put("uniqId", (Object)this.getUniqId()).put("tabId", (Object)this.getTabId()).put("extended", this.getSerializedExtendedData()).toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Object getSerializedExtendedData() throws JSONException;

    protected SortedPostListPanel getSortedPostListPanel() {
        return this.sortedPostListPanel;
    }

    public StatusData getStatus(long statusId) {
        StatusPanel statusPanel = this.statusMap.get(statusId);
        return statusPanel == null ? null : statusPanel.getStatusData();
    }

    @Override
    public JComponent getTabComponent() {
        return this.getScrollPane();
    }

    protected JLabel getTweetViewFavoriteButton() {
        if (this.tweetViewFavoriteButton == null) {
            this.tweetViewFavoriteButton = new JLabel(IMG_FAV_OFF, 0);
            this.tweetViewFavoriteButton.setBorder(new LineBorder(Color.GRAY, 1));
            this.tweetViewFavoriteButton.setMinimumSize(OPERATION_PANEL_SIZE);
            this.tweetViewFavoriteButton.setMaximumSize(OPERATION_PANEL_SIZE);
            this.tweetViewFavoriteButton.setPreferredSize(OPERATION_PANEL_SIZE);
            this.tweetViewFavoriteButton.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    this.ancestorMoved(event);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    if (DefaultClientTab.this.selectingPost != null && DefaultClientTab.this.selectingPost.getStatusData().tag instanceof Status) {
                        Status status = (Status)DefaultClientTab.this.selectingPost.getStatusData().tag;
                        if (status.isFavorited()) {
                            DefaultClientTab.this.tweetViewFavoriteButton.setIcon(IMG_FAV_ON);
                        } else {
                            DefaultClientTab.this.tweetViewFavoriteButton.setIcon(IMG_FAV_OFF);
                        }
                    }
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    this.ancestorMoved(event);
                }
            });
            this.tweetViewFavoriteButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.mouseExited(e);
                    DefaultClientTab.this.handleAction("fav");
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    DefaultClientTab.this.tweetViewFavoriteButton.setIcon(IMG_FAV_HOVER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Status status = (Status)DefaultClientTab.this.selectingPost.getStatusData().tag;
                    if (status.isFavorited()) {
                        DefaultClientTab.this.tweetViewFavoriteButton.setIcon(IMG_FAV_ON);
                    } else {
                        DefaultClientTab.this.tweetViewFavoriteButton.setIcon(IMG_FAV_OFF);
                    }
                }
            });
        }
        return this.tweetViewFavoriteButton;
    }

    protected JPanel getTweetViewOperationPanel() {
        if (this.tweetViewOperationPanel == null) {
            this.tweetViewOperationPanel = new JPanel();
            this.tweetViewOperationPanel.setPreferredSize(new Dimension(76, 76));
            this.tweetViewOperationPanel.setMinimumSize(new Dimension(76, 76));
            GroupLayout layout = new GroupLayout(this.tweetViewOperationPanel);
            layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.getTweetViewReplyButton(), 32, 32, 32).addComponent(this.getTweetViewRetweetButton(), 32, 32, 32)).addGroup(layout.createSequentialGroup().addComponent(this.getTweetViewFavoriteButton(), 32, 32, 32).addComponent(this.getTweetViewOtherButton(), 32, 32, 32)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.getTweetViewReplyButton(), 32, 32, 32).addComponent(this.getTweetViewRetweetButton(), 32, 32, 32)).addGroup(layout.createParallelGroup().addComponent(this.getTweetViewFavoriteButton(), 32, 32, 32).addComponent(this.getTweetViewOtherButton(), 32, 32, 32)));
        }
        return this.tweetViewOperationPanel;
    }

    protected JLabel getTweetViewOtherButton() {
        if (this.tweetViewOtherButton == null) {
            this.tweetViewOtherButton = new JLabel("\uff1f", 0);
            this.tweetViewOtherButton.setBorder(new LineBorder(Color.GRAY, 1));
            this.tweetViewOtherButton.setToolTipText("\u30e6\u30fc\u30b6\u30fc\u60c5\u5831\u3092\u898b\u308b");
            this.tweetViewOtherButton.setMinimumSize(OPERATION_PANEL_SIZE);
            this.tweetViewOtherButton.setMaximumSize(OPERATION_PANEL_SIZE);
            this.tweetViewOtherButton.setPreferredSize(OPERATION_PANEL_SIZE);
            this.tweetViewOtherButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultClientTab.this.handleAction("userinfo");
                }
            });
        }
        return this.tweetViewOtherButton;
    }

    protected JLabel getTweetViewReplyButton() {
        if (this.tweetViewReplyButton == null) {
            this.tweetViewReplyButton = new JLabel("Re", 0);
            this.tweetViewReplyButton.setBorder(new LineBorder(Color.GRAY, 1));
            this.tweetViewReplyButton.setToolTipText("@\u8fd4\u4fe1\u3092\u884c\u3046");
            this.tweetViewReplyButton.setMinimumSize(OPERATION_PANEL_SIZE);
            this.tweetViewReplyButton.setMaximumSize(OPERATION_PANEL_SIZE);
            this.tweetViewReplyButton.setPreferredSize(OPERATION_PANEL_SIZE);
            this.tweetViewReplyButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultClientTab.this.handleAction("reply");
                }
            });
        }
        return this.tweetViewReplyButton;
    }

    protected JLabel getTweetViewRetweetButton() {
        if (this.tweetViewRetweetButton == null) {
            this.tweetViewRetweetButton = new JLabel("RT", 0);
            this.tweetViewRetweetButton.setBorder(new LineBorder(Color.GRAY, 1));
            this.tweetViewRetweetButton.setToolTipText("\u516c\u5f0f\u30ea\u30c4\u30a4\u30fc\u30c8");
            this.tweetViewRetweetButton.setMinimumSize(OPERATION_PANEL_SIZE);
            this.tweetViewRetweetButton.setMaximumSize(OPERATION_PANEL_SIZE);
            this.tweetViewRetweetButton.setPreferredSize(OPERATION_PANEL_SIZE);
            this.tweetViewRetweetButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultClientTab.this.handleAction("rt");
                }
            });
        }
        return this.tweetViewRetweetButton;
    }

    @Override
    public String getUniqId() {
        return this.uniqId;
    }

    @Override
    public void handleAction(String command) {
        this.frameApi.handleAction(command, this.selectingPost == null ? null : this.selectingPost.getStatusData());
    }

    private void init(ClientConfiguration configuration) {
        this.fontMetrics = this.getSortedPostListPanel().getFontMetrics(this.frameApi.getDefaultFont());
        int str12width = this.fontMetrics.stringWidth("0123456789abc");
        this.fontHeight = this.fontMetrics.getHeight();
        int height = Math.max(18, this.fontHeight);
        this.linePanelSizeOfSentBy = new Dimension(str12width, height);
        this.iconSize = new Dimension(64, height);
        configuration.getTimer().schedule((TimerTask)new PostListUpdater(), this.configProperties.getInteger("gui.interval.list_update"), (long)this.configProperties.getInteger("gui.interval.list_update"));
        this.tweetPopupMenu = ((TwitterClientFrame)this.frameApi).generatePopupMenu(new TweetPopupMenuListener());
        this.tweetPopupMenu.addPopupMenuListener(new TweetPopupMenuListener());
        this.scroller = new ScrollUtility(this.getScrollPane(), new ScrollUtility.BoundsTranslator(){

            @Override
            public Rectangle translate(JComponent component) {
                if (!(component instanceof StatusPanel)) {
                    throw new AssertionError();
                }
                return DefaultClientTab.this.sortedPostListPanel.getBoundsOf((StatusPanel)component);
            }
        }, configuration.getConfigProperties().getBoolean("gui.scrool.momentumEnabled"));
    }

    @Override
    public void initTimeline() {
        StatusData statusData = new StatusData(null, new Date(Long.MAX_VALUE));
        statusData.user = "!twitter";
        statusData.backgroundColor = Color.DARK_GRAY;
        statusData.foregroundColor = Color.WHITE;
        statusData.image = new JLabel(IMG_TWITTER_LOGO);
        statusData.sentBy = new JLabel();
        statusData.data = new JLabel("All data is from twitter...");
        this.addStatus(statusData);
    }

    protected boolean isMentioned(UserMentionEntity[] userMentionEntities) {
        return this.configuration.isMentioned(userMentionEntities);
    }

    public void removeStatus(StatusData statusData) {
        StatusPanel panel = this.statusMap.get(statusData.id);
        if (panel != null) {
            this.getSortedPostListPanel().remove(panel);
        }
    }

    public void removeStatus(final StatusData statusData, int delay) {
        this.configuration.getTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                DefaultClientTab.this.removeStatus(statusData);
            }
        }, delay);
    }

    static {
        OPERATION_PANEL_SIZE = new Dimension(32, 32);
        try {
            IMG_FAV_OFF = new ImageIcon(ImageIO.read(DefaultClientTab.class.getResource("img/fav_off32.png")));
            IMG_FAV_ON = new ImageIcon(ImageIO.read(DefaultClientTab.class.getResource("img/fav_on32.png")));
            IMG_FAV_HOVER = new ImageIcon(ImageIO.read(DefaultClientTab.class.getResource("img/fav_hover32.png")));
        }
        catch (IOException e) {
            throw new AssertionError((Object)"\u5fc5\u8981\u306a\u30ea\u30bd\u30fc\u30b9 img/fav_{off,on,hover}32.png \u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        try {
            IMG_TWITTER_LOGO = new ImageIcon(ImageIO.read(DefaultClientTab.class.getResource("/com/twitter/twitter-bird-white-on-blue.png")));
        }
        catch (IOException e) {
            throw new AssertionError((Object)"\u5fc5\u8981\u306a\u30ea\u30bd\u30fc\u30b9 Twitter\u306e\u30ed\u30b4 \u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f");
        }
    }

    protected class TweetPopupMenuListener
    implements PopupMenuListener,
    ActionListener {
        protected TweetPopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusData statusData = DefaultClientTab.this.selectingPost == null ? null : DefaultClientTab.this.selectingPost.getStatusData();
            DefaultClientTab.this.frameApi.handleAction(e.getActionCommand(), statusData);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent arg0) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
            Component[] components;
            if (DefaultClientTab.this.selectingPost == null) {
                DefaultClientTab.this.getSortedPostListPanel().requestFocusFirstComponent();
            }
            JPopupMenu popupMenu = (JPopupMenu)arg0.getSource();
            for (Component component : components = popupMenu.getComponents()) {
                JMenuItem menuItem = (JMenuItem)component;
                StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                if (statusData == null) {
                    menuItem.setEnabled(false);
                    continue;
                }
                ActionHandler actionHandler = DefaultClientTab.this.configuration.getActionHandler(menuItem.getActionCommand());
                if (actionHandler != null) {
                    actionHandler.popupMenuWillBecomeVisible(menuItem, statusData, DefaultClientTab.this.frameApi);
                    continue;
                }
                DefaultClientTab.this.logger.warn("ActionHandler is not found: {}", (Object)menuItem.getActionCommand());
                menuItem.setEnabled(false);
            }
        }
    }

    public class PostListUpdater
    extends TimerTask {
        @Override
        public void run() {
            final DefaultClientTab this$dct = DefaultClientTab.this;
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LinkedList<StatusPanel> postListAddQueue;
                    LinkedList<StatusPanel> linkedList = postListAddQueue = this$dct.postListAddQueue;
                    synchronized (linkedList) {
                        int size = postListAddQueue.size();
                        JScrollPane postListScrollPane = this$dct.postListScrollPane;
                        postListScrollPane.invalidate();
                        Point viewPosition = postListScrollPane.getViewport().getViewPosition();
                        if (viewPosition.y < this$dct.fontHeight) {
                            postListScrollPane.getViewport().setViewPosition(new Point(viewPosition.x, 0));
                        } else {
                            postListScrollPane.getViewport().setViewPosition(new Point(viewPosition.x, viewPosition.y + (this$dct.iconSize.height + 1) * size));
                        }
                        this$dct.getSortedPostListPanel().add(postListAddQueue);
                        postListScrollPane.validate();
                    }
                }
            });
        }
    }

    protected class PostListListener
    implements MouseListener,
    FocusListener,
    KeyListener {
        protected PostListListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            boolean scroll = e.getOppositeComponent() == null && DefaultClientTab.this.selectingPost != null;
            DefaultClientTab.this.focusGainOfLinePanel(e);
            if (!scroll) {
                DefaultClientTab.this.scroller.scrollTo(DefaultClientTab.this.selectingPost);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            DefaultClientTab.this.logger.trace("{}", (Object)e);
            DefaultClientTab.this.frameApi.handleShortcutKey("list", e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            DefaultClientTab.this.frameApi.handleShortcutKey("list", e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            e.getComponent().requestFocusInWindow();
            if (e.getClickCount() == 2) {
                StatusPanel panel = (StatusPanel)e.getComponent();
                DefaultClientTab.this.frameApi.handleAction("reply", panel.getStatusData());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public abstract class DefaultRenderer
    implements TabRenderer {
        protected int getInfoSurviveTime() {
            return DefaultClientTab.this.frameApi.getInfoSurviveTime();
        }

        public void onBlock(User source, User blockedUser) {
        }

        @Override
        public void onChangeAccount(boolean forWrite) {
        }

        public void onCleanUp() {
        }

        @Override
        public void onClientMessage(String name, Object arg) {
            switch (name) {
                case "request focus tabComponent": {
                    if (DefaultClientTab.this.selectingPost == null) {
                        DefaultClientTab.this.getSortedPostListPanel().requestFocusInWindow();
                        break;
                    }
                    DefaultClientTab.this.selectingPost.requestFocusInWindow();
                    break;
                }
                case "request focus nextComponent": {
                    if (DefaultClientTab.this.selectingPost == null) {
                        DefaultClientTab.this.getSortedPostListPanel().requestFocusInWindow();
                        break;
                    }
                    DefaultClientTab.this.getSortedPostListPanel().requestFocusNextOf(DefaultClientTab.this.selectingPost);
                    break;
                }
                case "request focus prevComponent": {
                    if (DefaultClientTab.this.selectingPost == null) {
                        DefaultClientTab.this.getSortedPostListPanel().requestFocusInWindow();
                        break;
                    }
                    DefaultClientTab.this.getSortedPostListPanel().requestFocusPreviousOf(DefaultClientTab.this.selectingPost);
                    break;
                }
                case "request focus userPrevComponent": {
                    if (DefaultClientTab.this.selectingPost == null) {
                        DefaultClientTab.this.getSortedPostListPanel().requestFocusInWindow();
                        break;
                    }
                    ArrayList<StatusPanel> arrayList = DefaultClientTab.this.listItems.get(DefaultClientTab.this.selectingPost.getStatusData().user);
                    int indexOf = arrayList.indexOf(DefaultClientTab.this.selectingPost);
                    if (indexOf < 0 || indexOf >= arrayList.size() - 1) break;
                    arrayList.get(indexOf + 1).requestFocusInWindow();
                    break;
                }
                case "request focus userNextComponent": {
                    if (DefaultClientTab.this.selectingPost == null) {
                        DefaultClientTab.this.getSortedPostListPanel().requestFocusInWindow();
                        break;
                    }
                    ArrayList<StatusPanel> arrayList = DefaultClientTab.this.listItems.get(DefaultClientTab.this.selectingPost.getStatusData().user);
                    int indexOf = arrayList.indexOf(DefaultClientTab.this.selectingPost);
                    if (indexOf <= 0) break;
                    arrayList.get(indexOf - 1).requestFocusInWindow();
                    break;
                }
                case "request focus firstComponent": {
                    DefaultClientTab.this.getSortedPostListPanel().requestFocusFirstComponent();
                    break;
                }
                case "request focus windowFirstComponent": {
                    DefaultClientTab.this.getSortedPostListPanel().getComponentAt(0, DefaultClientTab.this.getScrollPane().getViewport().getViewPosition().y).requestFocusInWindow();
                    break;
                }
                case "request focus windowLastComponent": {
                    JViewport viewport = DefaultClientTab.this.getScrollPane().getViewport();
                    DefaultClientTab.this.getSortedPostListPanel().getComponentAt(0, viewport.getViewPosition().y + viewport.getHeight()).requestFocusInWindow();
                    break;
                }
                case "scroll as window last": {
                    if (DefaultClientTab.this.selectingPost == null) {
                        DefaultClientTab.this.getSortedPostListPanel().requestFocusInWindow();
                        break;
                    }
                    Rectangle bounds = DefaultClientTab.this.getSortedPostListPanel().getBoundsOf(DefaultClientTab.this.selectingPost);
                    JViewport viewport = DefaultClientTab.this.getScrollPane().getViewport();
                    int x = viewport.getViewPosition().x;
                    int y = bounds.y - (viewport.getHeight() - bounds.height);
                    viewport.setViewPosition(new Point(x, y));
                    break;
                }
                case "request focus inReplyTo": {
                    if (DefaultClientTab.this.selectingPost == null) {
                        DefaultClientTab.this.getSortedPostListPanel().requestFocusInWindow();
                        break;
                    }
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    if (!(statusData.tag instanceof Status)) break;
                    Status tag = (Status)statusData.tag;
                    DefaultClientTab.this.inReplyToStack.push(DefaultClientTab.this.selectingPost);
                    StatusPanel statusPanel = DefaultClientTab.this.statusMap.get(tag.getInReplyToStatusId());
                    if (statusPanel == null) break;
                    statusPanel.requestFocusInWindow();
                    break;
                }
                case "request focus back inReplyTo": {
                    if (DefaultClientTab.this.selectingPost == null) {
                        DefaultClientTab.this.getSortedPostListPanel().requestFocusInWindow();
                        break;
                    }
                    if (DefaultClientTab.this.inReplyToStack.isEmpty()) break;
                    DefaultClientTab.this.inReplyToStack.pop().requestFocusInWindow();
                    break;
                }
                case "copy": {
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    StringSelection stringSelection = new StringSelection(statusData.data.getText());
                    clipboard.setContents(stringSelection, stringSelection);
                    break;
                }
                case "copy url": {
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    if (!(statusData.tag instanceof Status)) break;
                    Status status = (Status)statusData.tag;
                    status = status.isRetweet() ? status.getRetweetedStatus() : status;
                    String url = "http://twitter.com/" + status.getUser().getScreenName() + "/status/" + status.getId();
                    StringSelection stringSelection = new StringSelection(url);
                    clipboard.setContents(stringSelection, stringSelection);
                    break;
                }
                case "copy userid": {
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    StringSelection stringSelection = new StringSelection(statusData.user);
                    clipboard.setContents(stringSelection, stringSelection);
                    break;
                }
                case "browser user home": {
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    if (!(statusData.tag instanceof Status)) break;
                    Status status = (Status)statusData.tag;
                    status = status.isRetweet() ? status.getRetweetedStatus() : status;
                    String url = "http://twitter.com/" + status.getUser().getScreenName();
                    DefaultClientTab.this.utility.openBrowser(url);
                    break;
                }
                case "browser status": 
                case "browser permalink": 
                case "event createdAt clicked": {
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    if (!(statusData.tag instanceof Status)) break;
                    Status status = (Status)statusData.tag;
                    status = status.isRetweet() ? status.getRetweetedStatus() : status;
                    String url = "http://twitter.com/" + status.getUser().getScreenName() + "/status/" + status.getId();
                    DefaultClientTab.this.utility.openBrowser(url);
                    break;
                }
                case "broser inReplyTo": {
                    Status status;
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    if (!(statusData.tag instanceof Status) || (status = (Status)statusData.tag).getInReplyToStatusId() == -1L) break;
                    String url = "http://twitter.com/" + status.getInReplyToScreenName() + "/status/" + status.getInReplyToStatusId();
                    DefaultClientTab.this.utility.openBrowser(url);
                    break;
                }
                case "browser urls": {
                    URLEntity[] urlEntities;
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    if (!(statusData.tag instanceof Status)) break;
                    Status status = (Status)statusData.tag;
                    for (URLEntity urlEntity : urlEntities = status.getURLEntities()) {
                        DefaultClientTab.this.utility.openBrowser(urlEntity.getURL());
                    }
                    break;
                }
                case "event createdBy clicked": {
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    if (!(statusData.tag instanceof Status)) break;
                    Status status = (Status)statusData.tag;
                    if (status.isRetweet()) {
                        status = status.getRetweetedStatus();
                    }
                    DefaultClientTab.this.handleAction("userinfo!" + status.getUser().getScreenName());
                    break;
                }
                case "event overlaylabel clicked": {
                    Status status;
                    if (DefaultClientTab.this.selectingPost == null) break;
                    StatusData statusData = DefaultClientTab.this.selectingPost.getStatusData();
                    if (!(statusData.tag instanceof Status) || !(status = (Status)statusData.tag).isRetweet()) break;
                    DefaultClientTab.this.handleAction("userinfo!" + status.getUser().getScreenName());
                }
            }
        }

        public void onConnect() {
        }

        public void onDeletionNotice(long directMessageId, long userId) {
        }

        public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
        }

        public void onDirectMessage(DirectMessage directMessage) {
        }

        public void onDisconnect() {
        }

        public void onException(Exception ex) {
        }

        public void onFavorite(User source, User target, Status favoritedStatus) {
        }

        public void onFollow(User source, User followedUser) {
        }

        public void onFriendList(long[] friendIds) {
        }

        public void onScrubGeo(long userId, long upToStatusId) {
        }

        public void onStallWarning(StallWarning warning) {
        }

        public void onStatus(Status originalStatus) {
            DefaultClientTab.this.addStatus(originalStatus);
        }

        public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
        }

        public void onUnblock(User source, User unblockedUser) {
        }

        public void onUnfavorite(User source, User target, Status unfavoritedStatus) {
        }

        public void onUserListCreation(User listOwner, UserList list) {
        }

        public void onUserListDeletion(User listOwner, UserList list) {
        }

        public void onUserListMemberAddition(User addedMember, User listOwner, UserList list) {
        }

        public void onUserListMemberDeletion(User deletedMember, User listOwner, UserList list) {
        }

        public void onUserListSubscription(User subscriber, User listOwner, UserList list) {
        }

        public void onUserListUnsubscription(User subscriber, User listOwner, UserList list) {
        }

        public void onUserListUpdate(User listOwner, UserList list) {
        }

        public void onUserProfileUpdate(User updatedUser) {
        }
    }

    private static final class EntityComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 8166780199866981253L;

        private EntityComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return TwitterStatus.getEntityStart(o1) - TwitterStatus.getEntityStart(o2);
        }
    }
}

