/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.config;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import jp.syuriken.snsw.twclient.config.ConfigFrame;
import jp.syuriken.snsw.twclient.config.ConfigType;

public class IntegerConfigType
implements ConfigType {
    private final int minimum;
    private final int maximum;
    private final int multiplier;

    public IntegerConfigType(int maximum, int minimum) {
        this(maximum, minimum, 1);
    }

    public IntegerConfigType(int minimum, int maximum, int multiplier) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.multiplier = multiplier;
    }

    @Override
    public JComponent getComponent(String configKey, String nowValue, ConfigFrame listener) {
        try {
            JSpinner spinner = new JSpinner(new SpinnerNumberModel(Integer.parseInt(nowValue) / this.multiplier, this.minimum, this.maximum, 1));
            spinner.addFocusListener(new FocusAdapterExtension(configKey, spinner, listener));
            return spinner;
        }
        catch (NumberFormatException e) {
            JTextArea textArea = new JTextArea("[\u4e0d\u6b63\u306a\u5024:\u6570\u5024\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059] " + nowValue);
            textArea.addFocusListener(new FocusAdapterExtension(configKey, textArea, listener));
            return textArea;
        }
    }

    @Override
    public String getValue(JComponent component) {
        if (component instanceof JSpinner) {
            return String.valueOf(((JSpinner)component).getValue());
        }
        if (component instanceof JLabel) {
            return String.valueOf(Integer.parseInt(((JLabel)component).getText().trim()));
        }
        throw new AssertionError();
    }

    @Override
    public boolean isPreferedAsMultiline() {
        return false;
    }

    @Override
    public boolean isValid(JComponent component) {
        if (component instanceof JSpinner) {
            return true;
        }
        if (component instanceof JLabel) {
            try {
                Integer.parseInt(((JLabel)component).getText().trim());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new AssertionError();
    }

    private final class FocusAdapterExtension
    extends FocusAdapter {
        private final String configKey;
        private final JComponent component;
        private final ConfigFrame listener;

        private FocusAdapterExtension(String configKey, JComponent component, ConfigFrame listener) {
            this.configKey = configKey;
            this.component = component;
            this.listener = listener;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.listener.setValue(this.configKey, String.valueOf(IntegerConfigType.this.getValue(this.component)));
        }
    }
}

