/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.JobQueue;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentSoftHashMap<K, V>
implements ConcurrentMap<K, V> {
    static final Logger logger = LoggerFactory.getLogger(ConcurrentSoftHashMap.class);
    protected final ClientConfiguration configuration;
    protected final ConcurrentHashMap<K, SoftReferenceUtil<K, V>> hashMap;
    protected final ReferenceQueue<V> referenceQueue;
    protected final ReferenceCleaner referenceCleaner = new ReferenceCleaner();
    protected transient Set<K> keySet;
    protected transient EntrySet entrySet;
    protected transient Values values;

    public ConcurrentSoftHashMap(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.hashMap = new ConcurrentHashMap();
        this.referenceQueue = new ReferenceQueue();
    }

    public ConcurrentSoftHashMap(ClientConfiguration configuration, int initialCapacity) {
        this.configuration = configuration;
        this.hashMap = new ConcurrentHashMap(initialCapacity);
        this.referenceQueue = new ReferenceQueue();
    }

    public ConcurrentSoftHashMap(ClientConfiguration configuration, int initialCapacity, float loadFactor) {
        this.configuration = configuration;
        this.hashMap = new ConcurrentHashMap(initialCapacity, loadFactor);
        this.referenceQueue = new ReferenceQueue();
    }

    public ConcurrentSoftHashMap(ClientConfiguration configuration, int initialCapacity, float loadFactor, int concurrencyLevel) throws IllegalArgumentException {
        this.configuration = configuration;
        this.hashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        this.referenceQueue = new ReferenceQueue();
    }

    @Override
    public void clear() {
        this.hashMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this.hashMap.entrySet());
        }
        return this.entrySet;
    }

    protected V expandReference(SoftReferenceUtil<K, V> reference) {
        if (reference == null) {
            return null;
        }
        Object obj = reference.get();
        if (obj == null) {
            this.queueCleaner();
        }
        return (V)obj;
    }

    @Override
    public V get(Object key) {
        return this.expandReference(this.hashMap.get(key));
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = this.hashMap.keySet();
        }
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        return this.expandReference(this.hashMap.put(key, this.wrapReference(key, value)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.hashMap.put(e.getKey(), this.wrapReference(e.getKey(), e.getValue()));
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.expandReference(this.hashMap.putIfAbsent(key, this.wrapReference(key, value)));
    }

    private void queueCleaner() {
        this.referenceCleaner.queue();
    }

    @Override
    public V remove(Object key) {
        this.queueCleaner();
        return this.expandReference(this.hashMap.remove(key));
    }

    @Override
    public boolean remove(Object key, Object value) throws ClassCastException {
        if (value == null) {
            return false;
        }
        this.queueCleaner();
        return this.hashMap.remove(key, this.wrapReference(key, value));
    }

    @Override
    public V replace(K key, V value) {
        return this.expandReference(this.hashMap.replace(key, this.wrapReference(key, value)));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.hashMap.replace(key, this.wrapReference(key, oldValue), this.wrapReference(key, newValue));
    }

    @Override
    public int size() {
        return this.hashMap.size();
    }

    public Values values() {
        if (this.values == null) {
            this.values = new Values(this.hashMap.values());
        }
        return this.values;
    }

    private SoftReferenceUtil<K, V> wrapReference(K key, V obj) {
        return new SoftReferenceUtil<K, V>(obj, this.referenceQueue, key);
    }

    public class WrapEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, SoftReferenceUtil<K, V>> entry;

        public WrapEntry(Map.Entry<K, SoftReferenceUtil<K, V>> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return ConcurrentSoftHashMap.this.expandReference(this.entry.getValue());
        }

        @Override
        public V setValue(V value) {
            return ConcurrentSoftHashMap.this.expandReference(this.entry.setValue(ConcurrentSoftHashMap.this.wrapReference(this.getKey(), value)));
        }
    }

    public class Values
    extends AbstractCollection<V> {
        private Collection<SoftReferenceUtil<K, V>> values;

        public Values(Collection<SoftReferenceUtil<K, V>> values) {
            this.values = values;
        }

        public ValueIterator iterator() {
            return new ValueIterator(this.values.iterator());
        }

        @Override
        public int size() {
            return this.values.size();
        }
    }

    public class ValueIterator
    implements Iterator<V> {
        private Iterator<SoftReferenceUtil<K, V>> iterator;

        public ValueIterator(Iterator<SoftReferenceUtil<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return ConcurrentSoftHashMap.this.expandReference(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    protected class ReferenceCleaner
    implements ParallelRunnable {
        private volatile boolean isQueued = false;

        protected ReferenceCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void queue() {
            ReferenceCleaner referenceCleaner = this;
            synchronized (referenceCleaner) {
                if (!this.isQueued) {
                    ConcurrentSoftHashMap.this.configuration.addJob(JobQueue.Priority.LOW, this);
                    this.isQueued = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Reference ref;
            while ((ref = ConcurrentSoftHashMap.this.referenceQueue.poll()) != null) {
                logger.trace("remove {}", ref);
                if (ref instanceof SoftReferenceUtil) {
                    ConcurrentSoftHashMap.this.hashMap.remove(((SoftReferenceUtil)ref).key);
                    continue;
                }
                throw new AssertionError((Object)"ref must be SoftReferenceUtil");
            }
            ReferenceCleaner referenceCleaner = this;
            synchronized (referenceCleaner) {
                this.isQueued = false;
            }
        }
    }

    public class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, SoftReferenceUtil<K, V>>> set;

        public EntrySet(Set<Map.Entry<K, SoftReferenceUtil<K, V>>> entrySet) {
            this.set = entrySet;
        }

        public EntryIterator iterator() {
            return new EntryIterator(this.set.iterator());
        }

        @Override
        public int size() {
            return this.set.size();
        }
    }

    public class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, SoftReferenceUtil<K, V>>> iterator;

        public EntryIterator(Iterator<Map.Entry<K, SoftReferenceUtil<K, V>>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new WrapEntry(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    protected static class SoftReferenceUtil<K, V>
    extends SoftReference<V> {
        private final int hashCode;
        protected final K key;

        public SoftReferenceUtil(V referent, K key) {
            super(referent);
            this.key = key;
            this.hashCode = referent.hashCode();
        }

        public SoftReferenceUtil(V referent, ReferenceQueue<V> referenceQueue, K key) {
            super(referent, referenceQueue);
            this.key = key;
            this.hashCode = referent.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SoftReferenceUtil) {
                SoftReferenceUtil reference = (SoftReferenceUtil)obj;
                return this.hashCode == reference.hashCode && this.key.equals(reference.key);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "SoftReferenceUtil{hash=" + this.hashCode + ",key=" + this.key + "}";
        }
    }
}

