/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu;

import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.omegat.core.Core;
import org.omegat.plugin.foldermenu.L10n;
import org.omegat.plugin.foldermenu.Menu;
import org.omegat.plugin.foldermenu.Submenu;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

public class MenuManager {
    private Menu menu = new Menu();
    private JMenu projectRoot;

    public MenuManager() {
        try {
            this.projectRoot = Submenu.create(L10n.getProjectRootMenuLabel(), this.menu.getMenu());
        }
        catch (IOException ex) {
            Log.log(ex);
            return;
        }
        try {
            File confDir = new File(StaticUtils.getConfigDir());
            Submenu.create(confDir, L10n.getUserConfigMenuLabel(), this.menu.getMenu());
        }
        catch (IOException ex) {
            Log.log(ex);
        }
        JMenuBar mainMenuBar = (JMenuBar)Core.getMainWindow().getMainMenu().getOptionsMenu().getParent();
        this.menu.setParent(mainMenuBar, mainMenuBar.getMenuCount() - 1);
    }

    public void createProjectItems() {
        File rootDir = new File(Core.getProject().getProjectProperties().getProjectRoot());
        try {
            Submenu.associate(this.projectRoot, rootDir);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    public void removeAllProjectItems() {
        Submenu.removeChildren(this.projectRoot);
    }
}

