package landminecraft.api.block;

import landminecraft.api.tileentity.TileEntityLandMine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public abstract class LandMineBase extends BlockContainer
{

	public LandMineBase(int id)
	{
		this(id, Material.rock);
	}

	public LandMineBase(int id, Material material)
	{
		super(id, material);
		this.setHardness(3.0F);
		this.setStepSound(soundStoneFootstep);
		this.setCreativeTab(CreativeTabs.tabRedstone);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public Icon getBlockTexture(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5)
	{
		Block block = this.getBlock(par1IBlockAccess, par2, par3, par4);
		return block != null ? block.getIcon(par5, this.getDamage(par1IBlockAccess, par2, par3, par4)) : this.blockIcon;
	}

	@Override
	public int damageDropped(int par1)
	{
		return par1;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4)
	{
		Block block = this.getBlock(par1IBlockAccess, par2, par3, par4);
		return block != null ? block.colorMultiplier(par1IBlockAccess, par2, par3, par4) : 0xffffff;
	}

	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileEntityLandMine();
	}

	public TileEntityLandMine getTileEntity(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
		return (TileEntityLandMine) par1IBlockAccess.getBlockTileEntity(par2, par3, par4);
	}

	public Block getBlock(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
		return Block.blocksList[this.getTileEntity(par1IBlockAccess, par2, par3, par4).id];
	}

	public int getDamage(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
		return this.getTileEntity(par1IBlockAccess, par2, par3, par4).metadata;
	}

}
