package landminecraft.api.block;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public abstract class LandMineWalked extends LandMineBase
{

	public LandMineWalked(int id) {
		super(id);
	}

	public LandMineWalked(int id, Material material) {
		super(id, material);
	}

	@Override
	public void onEntityWalking(World par1World, int par2, int par3, int par4, Entity par5Entity)
	{
		if (!par1World.isRemote) {
			this.onWalked(par1World, par2, par3, par4, par5Entity, par1World.getBlockMetadata(par2, par3, par4));
		}
	}

	protected abstract void onWalked(World par1World, int par2, int par3, int par4, Entity par5Entity, int par6);

}
