#pragma once

#include "ofMain.h"

class ofxSimpleButton;

typedef enum ofxSimpleButtonEventType {
	BUTTON_PRESSED,
	BUTTON_RELEASED,
} ofxSimpleButtonEventType;

struct ofxSimpleButtonEvent {
	ofxSimpleButton *button;
	ofxSimpleButtonEventType type;
};

class ofxSimpleButtonListener {
public:
	virtual void buttonNotify(ofxSimpleButtonEvent event) = 0;
};

class ofxSimpleButton {
public:
	void setup(int x, int y, int w, int h, bool fill);
	void draw(ofEventArgs& event);
	
	void mousePressed(ofMouseEventArgs& event);
	void mouseReleased(ofMouseEventArgs& event);

	void setOnColor(ofColor &color) { this->onColor = color; }
	void setOffColor(ofColor &color) { this->offColor = color; }

	bool getState() { return state; }

	void addListener(ofxSimpleButtonListener *listener);
	void removeListner(ofxSimpleButtonListener *listener);
	
private:
	int x, y, w, h;
	bool fill, state;
	ofColor onColor, offColor;
	
	vector<ofxSimpleButtonListener *> listeners;
	
	void sendNotify(ofxSimpleButtonEventType type);
};
