#include "testApp.h"

#define AUDIO_BUFFER_SIZE 1024
#define NUM_BUTTONS 28

static const string buttonName[NUM_BUTTONS] = {
	"BandedWG",
	"BeeThree",
	"BlowBotl",
	"BlowHole",
	"Bowed",
	"Brass",
	"Clarinet",
	"Drummer",
	"Flute",
	"FMVoices",

	"HevyMetl",
	"Mandolin",
	"Mesh2D",
	"ModalBar",
	"Moog",
	"PercFlut",
	"Plucked",
	"Resonate",
	"Rhodey",
	"Saxofony",
	
	"Shakers",
	"Simple",
	"Sitar",
	"StifKarp",
	"TubeBell",
	"Wurley",
	"VoicForm",
	"Whistle",
};

//--------------------------------------------------------------
void testApp::setup(){
	// init parameter
	sigAreaX = (int)(0.3 * ofGetWidth());
	sigAreaY = (int)(0.05 * ofGetHeight());
	sigAreaW = (int)(0.65 * ofGetWidth());
	sigAreaH = (int)(0.90 * ofGetHeight());

	buttonX = (int)(0.05 * ofGetWidth());
	buttonY = (int)(0.05 * ofGetHeight());
	buttonSize = (int)(0.018 * ofGetHeight());
	
	// setup of
    ofBackground(50, 50, 50);

	// setup buttons
	buttons.resize(NUM_BUTTONS);
	for(int i = 0; i < NUM_BUTTONS; i++) {
		buttons[i].setup(buttonX, buttonY + (buttonSize << 1) * i,
						 buttonSize, buttonSize, true);
		buttons[i].addListener(this);
	}
    
    // audio setup
    ofSoundStreamSetup(2, 0, this, 44100, AUDIO_BUFFER_SIZE, 4);
	lrAudio.assign(AUDIO_BUFFER_SIZE, 0.0);
    
    // STK
    insts.resize(NUM_BUTTONS);

	insts[0] = &mBandedWG;
	insts[1] = &mBeeThree;
	insts[2] = &mBlowBotl;
	insts[3] = &mBlowHole;
	insts[4] = &mBowed;
	insts[5] = &mBrass;
	insts[6] = &mClarinet;
	insts[7] = &mDrummer;
	insts[8] = &mFlute;
	insts[9] = &mFMVoices;
	
	insts[10] = &mHevyMetl;
	insts[11] = &mMandolin;
	insts[12] = &mMesh2D;
	insts[13] = &mModalBar;
	insts[14] = &mMoog;
	insts[15] = &mPercFlut;
	insts[16] = &mPlucked;
	insts[17] = &mResonate;
	insts[18] = &mRhodey;
	insts[19] = &mSaxofony;
	
	insts[20] = &mShakers;
	insts[21] = &mSimple;
	insts[22] = &mSitar;
	insts[23] = &mStifKarp;
	insts[24] = &mTubeBell;
	insts[25] = &mWurley;
	insts[26] = &mVoicForm;
	insts[27] = &mWhistle;
    
    mVoicForm.noteOff(0);
}

//--------------------------------------------------------------
void testApp::update(){

}

//--------------------------------------------------------------
void testApp::draw(){
	ofPushStyle();
	ofNoFill();

	// draw buttons
	{
		for(int i = 0; i < NUM_BUTTONS; i++) {
			ofDrawBitmapString(buttonName[i],
							   buttonX + (buttonSize << 1),
							   buttonY + (buttonSize * 0.8) + (buttonSize << 1) *i);
		}
	}
	
	// draw rect
	{
		ofColor(100, 100, 100); 
		ofRect(sigAreaX, sigAreaY, sigAreaW, sigAreaH);
	}

	// draw signal
	{
		int hh = sigAreaH >> 1;
		ofPushMatrix();
		ofTranslate(sigAreaX, sigAreaY);
		ofColor(150, 150, 10);
		ofBeginShape();
		for(int i = 0; i < AUDIO_BUFFER_SIZE; i++)
		{
			double x = ofMap(i, 0, AUDIO_BUFFER_SIZE, 0, sigAreaW);
			double y = hh + (sigAreaH * lrAudio[i]);
			ofVertex(x, y);
		}
		ofEndShape();
		ofPopMatrix();
	}
	
	ofPopStyle();
}

void testApp::audioOut(float *output, int size, int channels)
{
    for(int i = 0; i < size; i++) {
        double v = 0.0;
		for(int i = 0; i < NUM_BUTTONS; i++) {
            v += insts[i]->tick();
		}
        output[i * channels] = v;
        output[i * channels + 1] = v;

		lrAudio[i] = v;
    }
}

void testApp::buttonNotify(ofxSimpleButtonEvent event)
{
	for(int i = 0; i < NUM_BUTTONS; i++) {
		if(event.button == &buttons[i]) {
			if(event.type == BUTTON_PRESSED) {
				insts[i]->noteOn(220, 0.5);
			} else if(event.type == BUTTON_RELEASED) {
				insts[i]->noteOff(0.5);
			}
		}
	}
}

//--------------------------------------------------------------
void testApp::keyPressed(int key){

}

//--------------------------------------------------------------
void testApp::keyReleased(int key){

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){

}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::windowResized(int w, int h){

}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg){

}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo){ 

}
