/*static char sccsid[]="%Z% %M% %I% %E% %U%";*/
/************************************************************************/
/*																		*/
/*	akxmemtool.h														*/
/*																		*/
/*		Coded by Akito Kobayashi										*/
/*																		*/
/************************************************************************/
#ifndef _AKXMEMTOOL_H
#define _AKXMEMTOOL_H

#define  MEMTOOL

/**************************************************************************
 *                            MACRO                                       *
 **************************************************************************/
#undef Malloc
#undef Free  
#undef Realloc

#ifdef MEMTOOL
#define	Meminit(a)		akxm_mem_init(a)
#define	Malloc(a)		akxm_malloc(a,__FILE__,__LINE__)
#define	Realloc(a,b)	akxm_realloc(a,b,__FILE__,__LINE__)
#define	Free(a)			akxm_free(a,__FILE__,__LINE__)
#define	Nofree(a)		akxm_no_free(a)
#define	Strdup(a)		akxm_strdup(a,__FILE__,__LINE__)
#define	Strndup(a,b)	akxmnStrdup(a,b,__FILE__,__LINE__)
#define	Memdup(a,b)		akxm_memdup(a,b,__FILE__,__LINE__)
#define	Memndup(a,b,c)	akxm_memndup(a,b,c,__FILE__,__LINE__)
#define	MRealloc(a,b)	akxm_mrealloc(a,b,__FILE__,__LINE__)
#else
#define	Meminit(a)
#define	Malloc(a)		malloc(a)
#define	Realloc(a,b)	realloc(a,b)
#define	Free(a)			free(a)
#define	Nofree(a)		(-1)
#define	Strdup(a)		strdup(a)
#define	Strndup(a,b)	(NULL)
#define	Memdup(a,b)		(NULL)
#define	Memndup(a,b,c)	(NULL)
#define	MRealloc(a,b)	(NULL)
#endif

extern	int 	akxm_mem_init();
extern	char	*akxm_malloc();
extern	char	*akxm_realloc();
extern	void	akxm_free();
extern	int 	akxm_no_free();
extern	char	*akxm_strdup();
extern	char	*akxm_strndup();
extern	char	*akxm_memdup();
extern	char	*akxm_memndup();
extern	char	*akxm_mrealloc();
extern	void	akxm_mem_sdump(/*pi,n,buf*/);

#define AKX_CNBD_SIZE	8192

typedef struct tdtNewCnCB {			/*** 萔ǗubN *****/
	struct	tdtNewCnCB	*nextNewCnCB;		/* 萔ǗubN	  */
	char			*BD;				/* 萔̈̃AhX	@*/
	int 			lUsedLen;
	int 			lRemLen;
} tdtNewCnCB;

typedef struct {					/*** 萔Ǘe[u *****/
	tdtNewCnCB		*pNewCnCB;			/* 萔ǗubN̐擪 */
	tdtNewCnCB		*pcrNewCnCB;		/* 萔ǗubN̍Ō */
	int				iCnBDSize;
} tdtConstCt;

tdtConstCt *akxm_cct_mem_new();
void akxm_cct_mem_free();
char *akxm_cct_malloc(/* pConstCt,len */);

#endif	/* _AKXMEMTOOL_H */
