#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

# ver.1.2
# - Zbg{^ǉB
# - t@C܂̓tH_ǉœǂݍ񂾂Ƃɔ񐔂
#   smɂȂoOi񐔂P]ɃJEgĂ܂ĂjCB
# - hbOhbvɑΉBʏD&D͒ʏ́ACtrl+D&D͒ǉ́B
 
# ver.1.1
# - oOC

package require Tktable
package require tkdnd

set pause "/"
set unitList {
                 
                     
                   
                     
                 
  

      ɂ Ђ ݂     т ҂ 
      ɂ Ђ ݂     т ҂ 
      ɂ Ђ ݂     т ҂ 
      ɂ Ђ ݂ 肥    т ҂ 

      ʂ ӂ ނ 䂟 邟       Â Ԃ Ղ Ă ł
      ʂ ӂ ނ 䂡 邡       Â Ԃ Ղ Ă ł
      ʂ ӂ ނ 䂥 邥       Â Ԃ Ղ 
      ʂ ӂ ނ 䂧 邧       Â Ԃ Ղ 
  ӂ

  Ă ł 

  Ƃ ǂ 

  A J T ^ i n }    K U _ o p 
  C L V ` j q ~        M W a r s 
  E N X c k t       O Y d u v 
  G P Z e l w         Q [ f x y 
  I R \ g m z     S ] h { | 
   

  C L V ` j q ~  M W a r s 
  C L V ` j q ~  M W a r s 
  C L V ` j q ~  M W a r s 
  CF LF VF `F jF qF ~F F MF WF aF rF sF 

  E@ N@ X@ c@ k@ t@ @ @ @    @ O@ Y@ d@ u@ v@ e@ f@
  EB NB XB cB kB tB B B B    B OB YB dB uB vB eB fB
  EF NF XF cF kF tF F F F    F OF YF dF uF vF 
  EH NH XH cH kH tH H H H    H OH YH dH uH vH 
  t

  eB fB 
  e f 

  gD hD 
}

# joinToPreceding...O̕ɐڍĈꃂ[ɂׂ
set joinToPreceding {
          
  J K 
     @ B D F H 
}

# vowelList...[sꉹɕϊ邽߂̕ϐ
array unset vowelList
set vowelList(vowel) {a i u e o n}
lappend vowelList(vowel) $pause
set vowelList(a) {                  
                  A J T ^ i n }    K U _ o p  @  }
set vowelList(i) {                          
                  C L V ` j q ~        M W a r s    B }
set vowelList(u) {                      
                  E N X c k t       O Y d u v  D }
set vowelList(e) {                          
                  G P Z e l w         Q [ f x y    F }
set vowelList(o) {                    
                  I R \ g m z     S ] h { |  H }
set vowelList(n) { }
lappend vowelList($pause) $pause

#---------------------------------------------------
# ϐ
#
set appname pCov
set version 1.2
set lyrics ""
set loadedFiles ""
set lyricsFile ""
array unset prof
  # prof(combNum)  .... gݍ킹
  # prof(uttNum)   .... 
  # prof(uttMoraNum) .... [
  # prof(coveredNum) .... Jo[gݍ킹
  # prof(notCoveredNum) .... Jo[ĂȂgݍ킹
array unset histo

#---------------------------------------------------
# ݒt@Cǂݍ
#
if {[info exists ::starkit::topdir]} {
  set topdir [file dirname [info nameofexecutable]]
} else {
  set topdir [file dirname $argv0]
}
set initFile "$topdir/$appname-init.tcl"
if {[file exists $initFile]} {
  source $initFile
}

set prof(combNum) [expr [llength $unitList] * [llength $vowelList(vowel)]]

#---------------------------------------------------
# AXL[t@CǂݍށBsƂ""Ԃ
#
proc readFile {fn {encode ""}} {
  if [catch {open $fn r} in] {
    tk_messageBox -message "t@Cǂݍ݂Ɏs܂" \
      -title "error" -icon warning
    return ""
  }
  if {$encode != ""} {
    fconfigure $in -encoding $encode
  }
  set data ""
  if [catch {set data [read -nonewline $in]}] {
    tk_messageBox -message "t@Cǂݍ݂Ɏs܂" \
      -title "error" -icon warning
  }
  close $in
  return $data
}

#---------------------------------------------------
# xmlt@C̃GR[hwT
#
proc guessEncode {data} {
  set encode ""
  set xmlTag ""
  regexp -nocase {<?xml [^>]+>} $data xmlTag
  regexp -nocase {encoding="([^"]+)"} $xmlTag dummy encode   ;#"
 
  return $encode
}

#---------------------------------------------------
# ͑Ώۃt@Cǂݍ
#
proc readLyrics {args} {
  global v pause lyricsFile

  set fn ""
  if {[llength $args] == 0} {
    if {$lyricsFile != ""} {
      # Oǂ񂾃t@CȂ
      if [file isdirectory $lyricsFile] {
        set initDir $lyricsFile
      } else {
        set initDir [file dirname $lyricsFile]
      }
      set fn [tk_getOpenFile \
              -title "t@CJ" -defaultextension "txt" \
              -initialdir $initDir \
              -filetypes { {{related files} {.txt .ust .wav .xml}} \
                           {{text file} {.txt}} {{UTAU ust file}  {.ust}}  \
                           {{wav file}  {.wav}} {{MusicXML file}  {.xml}}  \
                           {{All Files} {*}   } }]
    } else {
      # Oǂ񂾃t@CȂȂ
      set fn [tk_getOpenFile \
              -title "t@CJ" -defaultextension "txt" \
              -filetypes { {{related files} {.txt .ust .wav .xml}} \
                           {{text file} {.txt}} {{UTAU ust file}  {.ust}}  \
                           {{wav file}  {.wav}} {{MusicXML file}  {.xml}}  \
                           {{All Files} {*}   } }]
    }
  } else {
    set fn [lindex $args 0]
  }
  if {$fn == ""} {return ""}
  set lyricsFile $fn

  set result ""
  if [regexp -nocase {\.txt$} $lyricsFile] {
    # t@Ctxtt@CȂ
    set data [readFile $lyricsFile]
    if {$data == ""} {return ""}

    set result " $data "
    regsub -all {[[:space:]]+} $result $pause result
    return $result

  } elseif [regexp -nocase {\.wav$} $lyricsFile] {
    # t@Cwavt@CȂ
    regsub -nocase {\.wav$} $lyricsFile "" result  ;# gq
    regsub -all {_} $result "" result              ;# UTAUAwav`_
    return $result

  } elseif [regexp -nocase {\.ust$} $lyricsFile] {
    # t@Custt@CȂ
    set data [readFile $lyricsFile]
    if {$data == ""} {return ""}

    foreach l [split $data "\n"] {
      if [regexp {^Lyric=} $l] {
        regsub {^Lyric=} $l "" l
        if {$l == "R"} {
          set result "$result "
        } else {
          set result "$result$l"
        }
      }
    }
    set result " $result "
    regsub -all {[[:space:]]+} $result $pause result
    return $result

  } elseif [regexp -nocase {\.xml$} $lyricsFile] {
    # t@Cxmlt@CȂisɈ΂̃^Oꍇ݂̂zj
    set data [readFile $lyricsFile]
    if {$data == ""} {return ""}
    set encode [guessEncode $data]  ;# t@C̕R[h𓾂
    if {$encode != [encoding system]} {
      set data [readFile $lyricsFile $encode]
    }

    # xml̎Ƌx𒊏oisɈ΂̃^Oꍇ݂̂zj
    foreach l [split $data "\n"] {
      if [regexp -nocase {<text>.+</text>} $l] {
        regsub -nocase {^.*<text>[[:space:]]*} $l "" l
        regsub -nocase {[[:space:]]*</text>.*$} $l "" l
        set result "$result$l"
      } elseif [regexp -nocase {<rest/>} $l] {
        set result "$result "
      }
    }
    set result " $result "
    regsub -all {[[:space:]]+} $result $pause result
    return $result
  }
}

#---------------------------------------------------
# ^eLXgt@CW߂tH_ǂݍ
#
proc readLyricsDir {args} {
  global v pause lyricsFile

  set d ""
  if {[llength $args] == 0} {
    if {$lyricsFile != ""} {
      # Oǂ񂾃t@CȂ
      if [file isdirectory $lyricsFile] {
        set initDir $lyricsFile
      } else {
        set initDir [file dirname $lyricsFile]
      }
      set d [tk_chooseDirectory -initialdir $initDir -title "tH_̑I"]
    } else {
      # Oǂ񂾃t@CȂȂ
      set d [tk_chooseDirectory -title "tH_̑I"]
    }
  } else {
    set d [lindex $args 0]
  }
  if {$d == ""} {return ""}

  set lyrics ""
  foreach fn [glob -nocomplain -directory $d *.{txt,wav,ust,xml}] {
    set lyricsTmp [readLyrics $fn]
    set lyrics "$lyrics$lyricsTmp"
  }
 
  set lyricsFile $d
  return $lyrics
}

#---------------------------------------------------
# charꃂ[Ȃ1AXȂǂȂ2AzỎȂ0Ԃ
#
proc isMora {char} {
  global unitList joinToPreceding pause
  if {[lsearch $joinToPreceding $char] >= 0} {
    return 2
  } elseif {[lsearch $unitList $char] >= 0 || $char == $pause} {
    return 1
  } else {
    return 0
  }
}

#---------------------------------------------------
# 1[ɕĕԂ
#
proc getMorae {inMorae} {
  set morae {}
  for {set i 0} {$i < [string length $inMorae]} {incr i} {
    set char [string range $inMorae $i $i]
    set ret [isMora $char]
    if {$ret == 1} {
      ;# ݂$char͈ꃂ[Ȃ̂ŃXgɒǉ
      lappend morae $char
    } elseif {$ret == 2} {
      ;# ݂$char͝XȂ̂ňO̕Ɍ
      set last [expr [llength $morae] -1]
      set mora "[lindex $morae $last]$char"
      set morae [lreplace $morae $last $last $mora]
    } else {
      ;# z肵ĂȂ
    }
  }
  ;#koko, proćAreturnOmoraeAunitListɂ݂̂̂c悤ɂׂB
  return $morae
}

#---------------------------------------------------
# ꃂ[̕ꉹ̉fԂ
#
proc getVowel {mora} {
  global vowelList
  set last [expr [string length $mora] -1]
  set char [string range $mora $last $last]

  foreach key $vowelList(vowel) {
    if {[lsearch $vowelList($key) $char] >= 0} {
      return $key
    }
  }
  return $mora
}

#---------------------------------------------------
# w肵ɑΉ闓ԍԂBs̏ꍇ-1Ԃ
proc getPrevSeq {prev} {
  global vowelList

  set ret [lsearch $vowelList(vowel) $prev]
  if {$ret < 0} {
    return $ret
  } else {
    return [expr $ret + 1]  ;#+1͍̂ږ邽
  }
}

#---------------------------------------------------
# w肵ɑΉ闓ԍԂBs̏ꍇ-1Ԃ
proc getMoraSeq {mora} {
  global unitList

  set ret [lsearch $unitList $mora]
  if {$ret < 0} {
    return $ret
  } else {
    return [expr $ret + 1]  ;#+1͍̂ږ邽
  }
}

#---------------------------------------------------
# qXgO̊eZZbg
#
proc resetHistogram {} {
  global table histo rSize cSize unitList vowelList

  # egݍ킹0ɂ
  array unset histo
  for {set r 1} {$r < $rSize} {incr r} {
    for {set c 1} {$c < $cSize} {incr c} {
      set histo($r,$c) 0
      $table tag celltag none $r,$c
    }
  }
  # YZbg
  set r 1
  foreach mora $unitList {
    set histo($r,0) $mora
    incr r
  }
  # sZbg
  set c 1
  foreach prev $vowelList(vowel) {
    set histo(0,$c) $prev
    incr c
  }
  set histo(0,0) ""
}

#---------------------------------------------------
# ͌ʂ
proc resetProf {} {
  global prof

  # prof(combNum) gݍ킹̓NANɋ߂̂g
  set prof(coveredNum) 0
  set prof(uttNum) 0
  set prof(uttMoraNum) 0
  set prof(notCoveredNum) 0
}

#---------------------------------------------------
proc makeHistogram {lyrics} {
  global histo pause vowelList unitList table rSize cSize prof

  set morae [getMorae $lyrics]  ;# ̎[ɕ

  # 
  resetHistogram
  resetProf

  for {set i 1} {$i < [llength $morae]} {incr i} {
    set mora [lindex $morae $i]
    if {$mora == $pause} {
      incr prof(uttNum)      ;# 𑝂₷
    } else {
      set prev [getVowel [lindex $morae [expr $i - 1]]]
      set r [getMoraSeq $mora]
      set c [getPrevSeq $prev]
      if {[array names histo "$r,$c"] != "" && $r >= 0 && $c >= 0} {
        incr histo($r,$c)
        if {$histo($r,$c) == 1} {
          incr prof(coveredNum)
        }
      } else {
        puts "warning: z肵ĂȂp^[F$prev-$mora"
      }
      incr prof(uttMoraNum)   ;# [𑝂₷
    }
  }

  # px0̃Znone^Ot
  $table tag delete none
  for {set r 1} {$r < $rSize} {incr r} {
    for {set c 1} {$c < $cSize} {incr c} {
      if {$histo($r,$c) <= 0} {
        $table tag celltag none $r,$c
        incr prof(notCoveredNum)
      }
    }
  }
  $table tag configure none   -bg #C0C050  ;# pxÕZ̔wiF
}

#---------------------------------------------------
# CSV`Ńt@Cۑ
proc saveCSV {} {
  global rSize cSize histo

  set fn [tk_getSaveFile -initialfile "result.csv" \
    -title "͌ʂ̕ۑ" -defaultextension "csv" ]
  if {$fn == ""} return

  if [catch {open $fn w} out] {
    tk_messageBox -message "ۑł܂ł" \
      -title "G[" -icon warning
    return
  }

  for {set r 0} {$r < $rSize} {incr r} {
    for {set c 0} {$c < $cSize} {incr c} {
      puts -nonewline $out $histo($r,$c)
      if {[expr $c + 1] < $cSize} {
        puts -nonewline $out ","
      }
    }
    puts $out ""
  }

  close $out
}

#---------------------------------------------------
proc analysis {} {
  global prof loadedFiles
  set w .analysis
  if [winfo exists $w] {destroy $w}
  toplevel $w
  wm title $w "͌"
  text $w.t -width 80 -height 12
  button $w.b -text "" -command "destroy $w"
  pack $w.t $w.b

  if {[array names prof "uttNum"] != ""} {
    # prof(combNum)  .... gݍ킹
    # prof(uttNum)   .... 
    # prof(uttMoraNum) .... [
    # prof(coveredNum) .... Jo[gݍ킹
    # prof(notCoveredNum) .... Jo[ĂȂgݍ킹
    if {$prof(combNum) > 0} {
      set coverage   [expr 100.0 * $prof(coveredNum) / $prof(combNum)]
    } else {
      set coverage 0
    }
    if {$prof(uttMoraNum) > 0} {
      set efficiency [expr 100.0 * $prof(coveredNum) / $prof(uttMoraNum)]
    } else {
      set efficiency 0
    }
 
    $w.t insert end "
͑ΏہF
$loadedFiles

񐔁F\t$prof(uttNum) 
[F\t$prof(uttMoraNum) 
gݍ킹F\t$prof(combNum) Ƃ
Jo[ϑgݍ킹F\t$prof(coveredNum) Ƃ
Jo[gݍ킹F\t$prof(notCoveredNum) Ƃ
Jo[F\t$coverage %
^F\t$efficiency %
    "
  }
}

#---------------------------------------------------
# hbOhbv̏
proc procDnd {objList {mode 0}} {     ;# mode=0..ʏ̉́A1..ǉ
  for {set i 0} {$i < [llength $objList]} {incr i} {
    set obj [lindex $objList $i]
    set obj [file normalize $obj]
    if [file isdirectory $obj] {       ;# tH_hbvꂽꍇ
      if {$i <= 0 && $mode == 0} {
        folderAnalysis $obj
      } else {
        addedFolderAnalysis $obj
      }
    } elseif [regexp -nocase {\.(txt|wav|ust|xml)$} $obj] {  ;# et@Chbvꂽꍇ
      if {$i <= 0 && $mode == 0} {
        fileAnalysis $obj
      } else {
        addedFileAnalysis $obj
      }
    }
  }
}

#---------------------------------------------------
# t@CJ
proc fileAnalysis {{fn ""}} {
  global lyrics loadedFiles lyricsFile
  if {$fn == ""} {
    set lyricsTmp [readLyrics]   ;# ̎t@Cǂ
  } else {
    set lyricsTmp [readLyrics $fn]   ;# ̎t@Cǂ
  }
  if {$lyricsTmp != ""} {
    set lyrics $lyricsTmp
    set loadedFiles $lyricsFile
    makeHistogram $lyrics     ;# xzvZ
  }
}

#---------------------------------------------------
# t@CJ(ǉ)
proc addedFileAnalysis {{fn ""}} {
  global lyrics loadedFiles lyricsFile pause
  if {$fn == ""} {
    set lyricsTmp [readLyrics]   ;# ̎t@Cǂ
  } else {
    set lyricsTmp [readLyrics $fn]   ;# ̎t@Cǂ
  }
  if {$lyricsTmp != ""} {
    set lyrics "$lyrics$lyricsTmp"
    set loadedFiles "$loadedFiles\n$lyricsFile"
    regsub -all -- "$pause+" $lyrics $pause lyrics
    makeHistogram $lyrics     ;# xzvZ
  }
}

#---------------------------------------------------
# tH_J
proc folderAnalysis {{fn ""}} {
  global lyrics loadedFiles lyricsFile
  if {$fn == ""} {
    set lyricsTmp [readLyricsDir]   ;# ̎tH_ǂ
  } else {
    set lyricsTmp [readLyricsDir $fn]   ;# ̎tH_ǂ
  }
  if {$lyricsTmp != ""} {
    set lyrics $lyricsTmp
    set loadedFiles $lyricsFile
    makeHistogram $lyrics     ;# xzvZ
  }
}

#---------------------------------------------------
# tH_J(ǉ)
proc addedFolderAnalysis {{fn ""}} {
  global lyrics loadedFiles lyricsFile pause
  if {$fn == ""} {
    set lyricsTmp [readLyricsDir]   ;# ̎tH_ǂ
  } else {
    set lyricsTmp [readLyricsDir $fn]   ;# ̎tH_ǂ
  }
  if {$lyricsTmp != ""} {
    set lyrics "$lyrics$lyricsTmp"
    set loadedFiles "$loadedFiles\n$lyricsFile"
    regsub -all -- "$pause+" $lyrics $pause lyrics
    makeHistogram $lyrics     ;# xzvZ
  }
}

#---------------------------------------------------

set fseq 1
set f($fseq) [frame .fb]
button $f($fseq).open -text "t@CJ" -command fileAnalysis
button $f($fseq).reset -text "Zbg" -command {
  set lyrics ""
  set loadedFiles ""
  set lyricsFile ""
  resetHistogram
  resetProf
}
button $f($fseq).open2 -text "t@CJ(ǉ)" -command addedFileAnalysis
button $f($fseq).analysis -text "" -command analysis
button $f($fseq).save -text "csv`ŕۑ" -command saveCSV
button $f($fseq).openDir -text "tH_J" -command folderAnalysis
button $f($fseq).openDir2 -text "tH_J(ǉ)" -command addedFolderAnalysis
button $f($fseq).exit -text "I" -command {exit}
grid $f($fseq).open $f($fseq).open2 $f($fseq).analysis $f($fseq).reset -sticky ewsn
grid $f($fseq).openDir $f($fseq).openDir2 $f($fseq).save $f($fseq).exit -sticky ewsn
grid $f($fseq)
incr fseq

set f($fseq) [frame .fe]
entry $f($fseq).e -textvar loadedFiles
pack $f($fseq).e -expand 1 -fill x
grid $f($fseq) -sticky ewsn
incr fseq

set rSize [expr [llength $unitList] + 1]         ;# +1͍ږ邽
set cSize [expr [llength $vowelList(vowel)] + 1] ;# +1͍ږ邽

set table [table .t -variable histo -rows $rSize -cols $cSize \
    -colwidth 8 \
    -multiline 0 -selectmode extended \
    -titlerows 1 -titlecols 1 -selecttitle 0 \
    -colstretchmode none -rowstretchmode none \
    -padx 1 -pady 1 \
    -xscrollcommand {.x set} -yscrollcommand {.y set} ]
scrollbar .x -command {$table xview} -orient horizontal
scrollbar .y -command {$table yview} -orient vertical
resetHistogram

grid $table .y -sticky news
grid .x -sticky news
grid rowconfigure . 0 -weight 1
grid columnconfigure . 0 -weight 1

#$table width 0 10                        ;# 0ڂ̉ύX
$table tag configure active -bg #A0A0A0  ;# ANeBuȃZ̔wiF
$table tag configure none   -bg #C0C050  ;# pxÕZ̔wiF
$table configure -resizeborders none
#$table configure -rows $rSize
#$table configure -cols $cSize

bind Table <MouseWheel> {
  if {%D > 0} {
    ::tk::table::MoveCell $table  -1 0  ;# 
  } else {
    ::tk::table::MoveCell $table   1 0  ;# 
  }
  $table selection anchor active
}
bind . <Control-Alt-d> { console show }
dnd bindtarget . text/uri-list <Drop> {procDnd %D}  ;# D&Df[^
dnd bindtarget . text/uri-list <Control-Drop> {procDnd %D 1} ;# D&Df[^ǉ

wm title . "$appname ver.$version"


