#!/usr/bin/ruby
# -*- coding:utf-8 -*-

require 'fileutils'


# ==============================================================================
# reset_chimei
# ==============================================================================

reset_chimei = Proc.new do
	file = File.new("../chimei/KEN_ALL.CSV.modzip.hits", "r")
		chimei = file.readlines
	file.close

	chimei.length.times do |i|
		s = chimei[i].chomp.split("	")
		s = [s[0], s[1], "*"]
		chimei[i] = s.join("	")
	end

	FileUtils.cp($filename, $filename + "_bak")

	file = File.new($filename, "r")
		lines = file.read.split("\n")
	file.close

	lines = lines + chimei
	lines = lines.sort

	dicfile = File.new($filename, "w")

	lines.length.times do |i|
		s1 = lines[i].split("	")
		s2 = lines[i - 1].split("	")

		if s1[2] != "*" &&
		s1[0..1] == s2[0..1] &&
		s2[2] == "*"
			s1[2] = "0"
		end

		if s1[2] != "*"
			dicfile.puts s1.join("	")
		end
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]

	reset_chimei.call
end
