#!/usr/bin/ruby
# -*- coding:utf-8 -*-

require 'nkf'


# ==============================================================================
# modify_edict
# ==============================================================================

modify_edict = Proc.new do
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	l2 = []
	p = 0

	lines.length.times do |i|
		# 全角スペースで始まるエントリを飛ばす
		if lines[i][0] == "　" ||
		# 名詞のみを収録
		lines[i].index(" /(n") == nil
			next
		end

		# 英訳部分をカット
		# ウォール街 [ウォールがい] /(n) Wall Street/(P)/EntL1613010X/
		s = lines[i].chomp.split(" /")[0]

		# 表記と読みに分ける
		if s.index(" [") != nil
			s = s.split(" [")
			# 読みの末尾の"]"を取る
			s[1] = s[1][0..-2]
			hyouki = s[0].split(";")
			yomi = s[1].split(";")
			# 不要な読みを削除
			# ik	word containing irregular kana usage
			# iK	word containing irregular kanji usage
			# io	irregular okurigana usage
			# ok	out-dated or obsolete kana usage
			# oK	word containing out-dated kanji
			yomi = yomi.delete_if {|s| s.downcase.index("(ik)") != nil}
			yomi = yomi.delete_if {|s| s.index("(io)") != nil}
			yomi = yomi.delete_if {|s| s.downcase.index("(ok)") != nil}
			yomi = yomi.delete_if {|s| s.length < 2}
		else
			# カタカナ語には読みが付いていない
			# ブラスバンド(P);ブラス・バンド /(n) brass band/
			hyouki = s.split(";")
			yomi = nil
		end

		# 不要な表記を削除
		hyouki = hyouki.delete_if {|s| s.downcase.index("(ik)") != nil}
		hyouki = hyouki.delete_if {|s| s.index("(io)") != nil}
		hyouki = hyouki.delete_if {|s| s.downcase.index("(ok)") != nil}
		# 表記はこの時点で完成形にする
		hyouki = hyouki.each_index {|c| hyouki[c] = hyouki[c].split("(")[0]}
		hyouki = hyouki.delete_if {|s| s.length < 2}

		# カタカナ語の読みを補充する
		# 読みがひらがなになっていないが最後にまとめて変換する
		if yomi == nil
			hyouki.length.times do |q|
				yomi2 = hyouki[q].tr('・', '')
				l2[p] = yomi2 + "	" + hyouki[q]
				p = p + 1
			end

			# カタカナ語の場合はこれ以降の処理が必要ない
			next
		end

		yomi.length.times do |q|
			# 読みがカタカナのみの場合は表記にカタカナを追加
			# 以下の場合は「ベータカロテン」「ベータカロチン」
			# 「ベータ・カロテン」の表記を追加する
			# βカロテン;βカロチン;β-カロテン;β-カロチン 
			# [ベータカロテン(βカロテン,β-カロテン);
			# ベータカロチン(βカロチン,β-カロチン);ベータ・カロテン]
			yomi2 =  yomi[q].split("(")[0]

			if yomi2.tr('ァ-ヴー・' , '') == ""
				l2[p] = yomi2.tr('・', '') + "	" + yomi2
				p = p + 1
			end
		end

		# 読みがカタカナだけでかつ () の無いものを削除
		# 以下の場合は「ベータ・カロテン」を削除する
		# βカロテン;βカロチン;β-カロテン;β-カロチン 
		# [ベータカロテン(βカロテン,β-カロテン);
		# ベータカロチン(βカロチン,β-カロチン);ベータ・カロテン]
		yomi = yomi.delete_if {|s| s.tr('ァ-ヴー・' , '') == ""}

		# 読みの中で表記が指定されているものを出力する
		# 以下の場合は「ぬのじ 布地」「ベータカロテン βカロテン」
		# 「ベータカロテン β-カロテン」などを出力
		# 布地;切れ地;切地;裂地 [ぬのじ(布地)(P);きれじ]
		# βカロテン;βカロチン;β-カロテン;β-カロチン 
		# [ベータカロテン(βカロテン,β-カロテン);
		# ベータカロチン(βカロチン,β-カロチン)]
		yomi.length.times do |q|
			hyouki.length.times do |r|
				# 読みの中に表記があるか調べる
				# 読みと表記の「_done」マークは残し続ける
				# いつループを抜けるかわからないので
				if yomi[q].index(hyouki[r].tr('_done', '')) == nil
					next
				end

				# 読みの末尾の「_done」マークは「split("(")」で消える
				l2[p] = yomi[q].split("(")[0] + "	" + hyouki[r].tr('_done', '')
				p = p + 1
				# 読みと表記に出力済みのマークをつける
				yomi[q] = yomi[q] + "_done"
				hyouki[r] = hyouki[r] + "_done"
			end
		end

		# 出力済みの読みと表記を削る
		yomi = yomi.delete_if {|s| s.index("_done") != nil}
		hyouki = hyouki.delete_if {|s| s.index("_done") != nil}

		# 読みをひらがなにする
		yomi.length.times do |q|
			# レンズ豆 [レンズまめ]
			yomi[q] = yomi[q].split("(")[0]
			yomi[q] = NKF.nkf("--hiragana -w -W", yomi[q])
			yomi[q] = yomi[q].tr('ゐゑ', 'いえ')
			yomi[q] = yomi[q].tr('・', '')
		end

		# 重複した読みを削除する
		yomi = yomi.uniq

		yomi.length.times do |q|
			hyouki.length.times do |r|
				l2[p] = yomi[q] + "	" + hyouki[r]
				p = p + 1
			end
		end
	end

	lines = l2

	dicfile = File.new($dicname, "w")

	lines.length.times do |i|
		s = lines[i].split("	")
		s[0] = NKF.nkf("--hiragana -w -W", s[0])
		s[0] = s[0].tr('ゐゑ', 'いえ')
		s[0] = s[0].tr('・', '')

		if s[0].length < 2
			next
		end

		dicfile.puts s.join("	")
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".modedict"

	modify_edict.call
end
