#!/usr/bin/ruby
# -*- coding:utf-8 -*-


# ==============================================================================
# modify_jinmei_jawikihits
# ==============================================================================

modify_jinmei_jawikihits = Proc.new do
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	dicfile = File.new($dicname, "w")

	# 辞書の並びを「表記, 読み, ヒット数」にする
	lines.length.times do |i|
		s = lines[i].chomp.split("	")
		s = [s[1], s[0], s[2]]
		lines[i] = s.join("	")
	end

	file = File.new("jinmei_specified.txt", "r")
		# 「\n」をカットしておかないとsortしたときの並びが逆になる
		jinmeilist = file.read.split("\n")
	file.close

	lines = lines + jinmeilist
	lines = lines.sort

	dicfile = File.new($dicname, "w")

	jinmei = ""

	lines.length.times do |i|
		s = lines[i].split("	")

		if s.length == 1
			jinmei = s[0]
			next
		end

		# 日本語版Wikipediaは特筆性のない人名が収録されないので、
		# 別途人名リストを読み込んでそこに含まれていればヒット数を10加える
		if s[0] == jinmei
			s[2] = s[2].to_i + 10
			s[2] = s[2].to_s
		end

		s = [s[1], s[0], s[2]]
		dicfile.puts s.join("	")
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".modhits"

	modify_jinmei_jawikihits.call
end
