#!/usr/bin/ruby
# -*- coding:utf-8 -*-


# ==============================================================================
# get_jawiki_hits
# ==============================================================================

get_jawiki_hits = Proc.new do
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	dicfile = File.new($dicname, "w")

	lines.length.times do |i|
		s = lines[i].chomp.split("	")

		# 「\」（バックスラッシュ）は検索できないので削除
		t = s[1].gsub('\\' , '')
		# 「"」を検索するときは \ でエスケープする
		t = t.gsub('"', '\"')
		# 表記の ` を ' に修正（"`皿`皿`皿".gsub('`', '\`') が上手くいかない）
		t = t.gsub("`", "'")

		# jawiki内でヒットする文書数を検索
		# （例）estcmd search jawiki_index/ "徳川"
		# --------[4700000000000000]--------
		# VERSION	1.0
		# NODE	local
		# HIT	17388
		c = `estcmd search ../src/jawiki_index/ #{'"' + t + '"'}`
		c = c.split("\n")[3]
		c = c[4..-1]

		dicfile.puts s[0] + "	" + s[1] + "	" + c
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".hits"

	get_jawiki_hits.call
end
