#!/usr/bin/ruby
# -*- coding:utf-8 -*-

require 'nkf'


# ==============================================================================
# get_yomigana_hyouki
# ==============================================================================

get_yomigana_hyouki = Proc.new do
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	# 単語フィルタを読み込む
	file = File.new("../src/filter-ut.txt", "r")
		filter = file.readlines
	file.close

	filter.length.times do |i|
		if filter[i].index("/") == 0
			# 高速化のためあらかじめ正規表現の形にしておく
			filter[i] = /#{filter[i].chomp[1..-2]}/
		else
			filter[i] = filter[i].chomp
		end
	end

	dicfile = File.new($dicname, "w")

	lines.length.times do |i|
		# 読みと表記に分ける
		s = lines[i].chomp.split("	")

		# 読みと表記を修正
		if s.length != 2
			puts "error: " + s.join("	")
			next
		end
		
		# 読みのスペースを除去
		s[0] = s[0].gsub(" ", "")
		# 読みの「う゛」を「ゔ」に修正
		s[0] = s[0].gsub("う゛", "ゔ")
		# 表記の全角を半角に変換
		s[1] = NKF.nkf('-m0Z1 -w -W', s[1])
		# 表記の中黒を修正
		s[1] = s[1].tr('･', '・')
		# 表記の ` を ' に修正（"`皿`皿`皿".gsub('`', '\`') が上手くいかない）
		s[1] = s[1].gsub("`", "'")

		# カタカナ語の読みを修正
		if s[1].tr('ァ-ヴー・、。☆★\!', '') == ""
			s[0] = s[1].tr('・、。☆★\!', '')
			s[0] = NKF.nkf("--hiragana -w -W", s[0])
			s[0] = s[0].tr('ゐゑ', 'いえ')
		# ひらがな語の読みを修正
		elsif s[1].tr('ぁ-ゔー・、。☆★\!', '') == ""
			s[0] = s[1].tr('・、。☆★\!', '')
			s[0] = s[0].tr('ゐゑ', 'いえ')
		else
			# 読みのカタカナをひらがなに修正
			# 「tr('ァ-ヴ', 'ぁ-ゔ')」よりnkfのほうが速い
			s[0] = NKF.nkf("--hiragana -w -W", s[0])
			s[0] = s[0].tr('ゐゑ', 'いえ')
		end

		# 2文字未満の読みを除外
		if s[0].length < 2 ||
		# 2文字未満の表記を除外
		s[1].gsub(" ", "").length < 2 ||
		# 20文字より多い表記を除外
		s[1].length > 20 ||
		# 英数字のみの表記を除外
		s[1].length == s[1].bytesize ||
		# 表記の頭が「ー「【『〈《([“"/」のものを除外
		s[1][0] != s[1][0].tr('ー「【『〈《([“"/', '') ||
		# 読みがひらがなか数字のものを収録（記号などを含まない）
		s[0].tr("/ぁ-ゔ/ー01234567890", "") != "" ||
		# 表記の文字数が読みの文字数より多いものを除外
		# （例）おりこん オリジナルコンフィデンス
		# ただし調整しないと次の例が弾かれてしまう
		# （例）あいあんめいでん アイアン・メイデン
		s[0].length < s[1].downcase.tr('・、。〜☆★abcdefghijklmnopqrstuvwxyz\ \!\"\#\$\%\&\'\=\^\\\|\@\;\:\+\*\,\.\/\?\_', '').length ||
		# 読みの文字数が表記の文字数の4倍以上のものを除外
		# 多少の不具合が出るかもしれないが割り切る
		# （例）くまもとじょうくまもとじょう 熊本城
		s[0].length >= s[1].length * 4
			next
		end

		# フィルタリング対象の単語をチェック
		filter.length.times do |c|
			if s[1].index(filter[c]) != nil
				s[1] = ""
				break
			end
		end

		if s[1] == ""
			next
		end

		dicfile.puts s.join("	")
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".pairs"

	get_yomigana_hyouki.call
end
