/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel.ExcelModel;
import jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel.MenuHandler;
import jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel.Setting;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.util.Log;

public class ImExController
implements IApplicationEventListener,
IProjectEventListener,
ActionListener {
    private static final ImExController instance = new ImExController();

    public static ImExController getInstance() {
        return instance;
    }

    private ImExController() {
    }

    @Override
    public void onApplicationStartup() {
        if (ExcelModel.getInstalledExcelVersion() != -1) {
            MenuHandler.initializeMenu(this);
            CoreEvents.registerProjectChangeListener(this);
        }
    }

    @Override
    public void onApplicationShutdown() {
        ExcelModel.close();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
        String action = menuItem.getActionCommand();
        Log.logInfoRB("LOG_MENU_CLICK", action);
        try {
            boolean enabled = menuItem.isSelected();
            Setting.setEnabled(enabled);
            if (enabled) {
                ExcelModel.exportHTML();
            }
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        try {
            switch (eventType) {
                case CREATE: 
                case LOAD: {
                    Setting.open();
                    boolean autoConvEnabled = Setting.getEnabled();
                    MenuHandler.enableSettingMenuItem(autoConvEnabled);
                    if (!autoConvEnabled) break;
                    ExcelModel.exportHTML();
                    break;
                }
                case COMPILE: {
                    if (!Setting.getEnabled()) break;
                    ExcelModel.importHTML();
                    break;
                }
                case CLOSE: {
                    Setting.close();
                    MenuHandler.disableSettingMenuItem();
                }
            }
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }
}

