//
define option 17 1;
define const IMAX = 100001;
/*================================================================*/
/*       main function                                            */
/*================================================================*/
proc main;
	double x IMAX;
	double y IMAX;
	dim final_x h  k1 k2 k3 k4 as double;
	dim ncal i as int;
//echo x y;
	/*--- set initial condition and cal range ---*/
echo t1=gettime(0);
	xx=x[0]=0.0;
	yy=y[0]=0.0;
	putline(xx,', ',yy);

	final_x=20.0;

	/* --- size of calculation step --- */
	h=0.25;
	ncal=(final_x-x[0])/h;
	if (ncal > IMAX-1) then
		ncal=IMAX-1; 
		h=(final_x-x[0])/ncal;
	end if;
	h2=h/2.0;
//echo h;
	/* --- 4th Runge Kutta Calculation --- */

	for (i=0; i < ncal; i++) do
//	for (i=0; i < 1000; i++) do
	/*
		k1=h*func1(xx,yy);
		k2=h*func1(x[i]+h/2.0, y[i]+k1/2.0);
		k3=h*func1(x[i]+h/2.0, y[i]+k2/2.0);
		k4=h*func1(x[i]+h, y[i]+k3);

		x[i+1]=x[i]+h;
		y[i+1]=y[i]+1.0/6.0*(k1+2.0*k2+2.0*k3+k4);
//		putline(x[i+1],', ',y[i+1]);
	*/
		xx2=xx+h2;
		k1=h*func1(xx,yy);
		k2=h*func1(xx2, yy+k1/2.0);
		k3=h*func1(xx2, yy+k2/2.0);
		xx=xx+h;
		k4=h*func1(xx, yy+k3);
		yy=yy+(k1+k2+k2+k3+k3+k4)/6.0;
		putline(xx,', ',yy);
	
	next;
echo t2=gettime(0) t2-t1;
	return 0;
end proc;

/*================================================================*/
/*       define function                                          */
/*================================================================*/
function func1(x, y);
	double dydx;

	dydx=sin(x)*cos(x)-y*cos(x);
//echo x y dydx;
	return dydx;
end func;
