/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.parsing.UnparsablePacket;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class PacketReader {
    private static Logger log = Logger.getLogger(PacketReader.class.getName());
    private Thread readerThread;
    private ExecutorService listenerExecutor;
    private XMPPConnection connection;
    private XmlPullParser parser;
    volatile boolean done;
    private String connectionID = null;

    protected PacketReader(XMPPConnection connection) {
        this.connection = connection;
        this.init();
    }

    protected void init() {
        this.done = false;
        this.connectionID = null;
        this.readerThread = new Thread(){

            @Override
            public void run() {
                PacketReader.this.parsePackets(this);
            }
        };
        this.readerThread.setName("Smack Packet Reader (" + this.connection.connectionCounterValue + ")");
        this.readerThread.setDaemon(true);
        this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Smack Listener Processor (" + ((PacketReader)PacketReader.this).connection.connectionCounterValue + ")");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.resetParser();
    }

    public synchronized void startup() throws XMPPException {
        this.readerThread.start();
        try {
            int waitTime = SmackConfiguration.getPacketReplyTimeout();
            this.wait(3 * waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.connectionID == null) {
            throw new XMPPException("Connection failed. No response from server.");
        }
        this.connection.connectionID = this.connectionID;
    }

    public void shutdown() {
        if (!this.done) {
            for (ConnectionListener listener : this.connection.getConnectionListeners()) {
                try {
                    listener.connectionClosed();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error in listener while closing connection", e);
                }
            }
        }
        this.done = true;
        this.listenerExecutor.shutdown();
    }

    private void resetParser() {
        try {
            this.parser = new MXParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.connection.reader);
        }
        catch (XmlPullParserException xppe) {
            log.log(Level.WARNING, "Error while resetting parser", xppe);
        }
    }

    private void parsePackets(Thread thread) {
        block38: {
            try {
                int eventType = this.parser.getEventType();
                do {
                    if (eventType == 2) {
                        UnparsablePacket message;
                        String content;
                        int parserDepth = this.parser.getDepth();
                        ParsingExceptionCallback callback = this.connection.getParsingExceptionCallback();
                        if (this.parser.getName().equals("message")) {
                            Packet packet;
                            try {
                                packet = PacketParserUtils.parseMessage(this.parser);
                            }
                            catch (Exception e) {
                                content = PacketParserUtils.parseContentDepth(this.parser, parserDepth);
                                message = new UnparsablePacket(content, e);
                                if (callback == null) continue;
                                callback.handleUnparsablePacket(message);
                                continue;
                            }
                            this.processPacket(packet);
                        } else if (this.parser.getName().equals("iq")) {
                            IQ iq;
                            try {
                                iq = PacketParserUtils.parseIQ(this.parser, this.connection);
                            }
                            catch (Exception e) {
                                content = PacketParserUtils.parseContentDepth(this.parser, parserDepth);
                                message = new UnparsablePacket(content, e);
                                if (callback == null) continue;
                                callback.handleUnparsablePacket(message);
                                continue;
                            }
                            this.processPacket(iq);
                        } else if (this.parser.getName().equals("presence")) {
                            Presence presence;
                            try {
                                presence = PacketParserUtils.parsePresence(this.parser);
                            }
                            catch (Exception e) {
                                content = PacketParserUtils.parseContentDepth(this.parser, parserDepth);
                                message = new UnparsablePacket(content, e);
                                if (callback == null) continue;
                                callback.handleUnparsablePacket(message);
                                continue;
                            }
                            this.processPacket(presence);
                        } else if (this.parser.getName().equals("stream")) {
                            if ("jabber:client".equals(this.parser.getNamespace(null))) {
                                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                    if (this.parser.getAttributeName(i).equals("id")) {
                                        this.connectionID = this.parser.getAttributeValue(i);
                                        if ("1.0".equals(this.parser.getAttributeValue("", "version"))) continue;
                                        this.releaseConnectionIDLock();
                                        continue;
                                    }
                                    if (!this.parser.getAttributeName(i).equals("from")) continue;
                                    this.connection.config.setServiceName(this.parser.getAttributeValue(i));
                                }
                            }
                        } else {
                            if (this.parser.getName().equals("error")) {
                                throw new XMPPException(PacketParserUtils.parseStreamError(this.parser));
                            }
                            if (this.parser.getName().equals("features")) {
                                this.parseFeatures(this.parser);
                            } else if (this.parser.getName().equals("proceed")) {
                                this.connection.proceedTLSReceived();
                                this.resetParser();
                            } else if (this.parser.getName().equals("failure")) {
                                String namespace = this.parser.getNamespace(null);
                                if ("urn:ietf:params:xml:ns:xmpp-tls".equals(namespace)) {
                                    throw new Exception("TLS negotiation has failed");
                                }
                                if ("http://jabber.org/protocol/compress".equals(namespace)) {
                                    this.connection.streamCompressionDenied();
                                } else {
                                    SASLMechanism.Failure failure = PacketParserUtils.parseSASLFailure(this.parser);
                                    this.processPacket(failure);
                                    this.connection.getSASLAuthentication().authenticationFailed(failure.getCondition());
                                }
                            } else if (this.parser.getName().equals("challenge")) {
                                String challengeData = this.parser.nextText();
                                this.processPacket(new SASLMechanism.Challenge(challengeData));
                                this.connection.getSASLAuthentication().challengeReceived(challengeData);
                            } else if (this.parser.getName().equals("success")) {
                                this.processPacket(new SASLMechanism.Success(this.parser.nextText()));
                                this.connection.packetWriter.openStream();
                                this.resetParser();
                                this.connection.getSASLAuthentication().authenticated();
                            } else if (this.parser.getName().equals("compressed")) {
                                this.connection.startStreamCompression();
                                this.resetParser();
                            }
                        }
                    } else if (eventType == 3 && this.parser.getName().equals("stream")) {
                        this.connection.disconnect();
                    }
                    eventType = this.parser.next();
                } while (!this.done && eventType != 1 && thread == this.readerThread);
            }
            catch (Exception e) {
                if (this.done || this.connection.isSocketClosed()) break block38;
                this.connection.notifyConnectionError(e);
            }
        }
    }

    private synchronized void releaseConnectionIDLock() {
        this.notify();
    }

    private void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        for (PacketCollector collector : this.connection.getPacketCollectors()) {
            collector.processPacket(packet);
        }
        this.listenerExecutor.submit(new ListenerNotification(packet));
    }

    private void parseFeatures(XmlPullParser parser) throws Exception {
        boolean startTLSReceived = false;
        boolean startTLSRequired = false;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("starttls")) {
                    startTLSReceived = true;
                    continue;
                }
                if (parser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms(parser));
                    continue;
                }
                if (parser.getName().equals("bind")) {
                    this.connection.getSASLAuthentication().bindingRequired();
                    continue;
                }
                if (parser.getName().equals("c")) {
                    String node = parser.getAttributeValue(null, "node");
                    String ver = parser.getAttributeValue(null, "ver");
                    if (ver == null || node == null) continue;
                    String capsNode = node + "#" + ver;
                    this.connection.setServiceCapsNode(capsNode);
                    continue;
                }
                if (parser.getName().equals("session")) {
                    this.connection.getSASLAuthentication().sessionsSupported();
                    continue;
                }
                if (parser.getName().equals("compression")) {
                    this.connection.setAvailableCompressionMethods(PacketParserUtils.parseCompressionMethods(parser));
                    continue;
                }
                if (!parser.getName().equals("register")) continue;
                this.connection.getAccountManager().setSupportsAccountCreation(true);
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("starttls")) {
                this.connection.startTLSReceived(startTLSRequired);
                continue;
            }
            if (parser.getName().equals("required") && startTLSReceived) {
                startTLSRequired = true;
                continue;
            }
            if (!parser.getName().equals("features")) continue;
            done = true;
        }
        if (!this.connection.isSecureConnection() && !startTLSReceived && this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new XMPPException("Server does not support security (TLS), but security required by connection configuration.", new XMPPError(XMPPError.Condition.forbidden));
        }
        if (!startTLSReceived || this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.releaseConnectionIDLock();
        }
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            for (Connection.ListenerWrapper listenerWrapper : ((PacketReader)PacketReader.this).connection.recvListeners.values()) {
                try {
                    listenerWrapper.notifyListener(this.packet);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception in packet listener", e);
                }
            }
        }
    }
}

