package com.xxxxxxx.drvpp.fw.web.controller;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSession;
import org.springframework.ui.Model;

import com.xxxxxxx.drvpp.fw.common.mybatis.FwSqlSession;
import com.xxxxxxx.drvpp.fw.common.util.Setting;
import com.xxxxxxx.drvpp.fw.common.util.SettingFactory;
import com.xxxxxxx.drvpp.fw.web.util.Business;
import com.xxxxxxx.drvpp.fw.web.util.EventParameter;
import com.xxxxxxx.drvpp.fw.web.util.SessionInfo;
import com.xxxxxxx.drvpp.fw.web.util.WebParameter;

public class ApplicationControllerImpl {
	public int doExecute(String url, Map<String, String> requestParameter,
			Model model, SessionInfo sessionInfo, FwSqlSession fwSqlSession,
			SettingFactory settingFactory, WebParameter parameter) {
		Setting requestMap = settingFactory.getSystemSetting("requestMap");

		// セッション取得(MyBatisオリジナル)
		SqlSession sqlSession = fwSqlSession.getSqlSession();

		// パラメータ設定
		String errorView = "error"; // TODO 設定値から
		parameter.setSqlSession(fwSqlSession);
		parameter.setRequestParameter(requestParameter);
		parameter.setModel(model);
		parameter.setViewName(errorView);
		parameter.setSessionInfo(sessionInfo);
		parameter.setUrl(url);

		// フローの取得(ビジネスロジック起動前処理用)
		List<Business<WebParameter>> pre = (List<Business<WebParameter>>) requestMap.getList("pre");
		
		// 実行(ビジネスロジック起動前処理)
		int result = -1;
		try {
			for (Business<WebParameter> b : pre) {
				// 起動前処理起動
				result = b.doExecute(parameter);
			}
		} catch (Exception e) {
			result = -1;
			parameter.setViewName(errorView);
			e.printStackTrace();
		} finally {
			// 後処理
			doFinish(sessionInfo, sqlSession, result);
		}
		if (result != 0){
			// TODO
			return result;
		}
		
		// フローの決定
		String reqId = getRequestMapping(url);
		List<Business<WebParameter>> flow = (List<Business<WebParameter>>) requestMap.getList(reqId);

		if(flow == null){
			return 0;
		}
		
		// 実行(ビジネスロジック)
		result = -1;
		try {
			for (Business<WebParameter> b : flow) {
				// ビジネスロジック起動
				result = b.doExecute(parameter);
			}
		} catch (Exception e) {
			result = -1;
			parameter.setViewName(errorView);
			e.printStackTrace();
		} finally {
			// 後処理
			doFinish(sessionInfo, sqlSession, result);
		}
		
		sqlSession.close();
		
		return result;
	}

	public int doExecute(String url, Map<String, String> requestParameter,
			FwSqlSession fwSqlSession, SettingFactory settingFactory,
			EventParameter parameter, InputStream is, OutputStream os) {
		Setting requestMap = settingFactory.getSystemSetting("requestMap");

		// セッション取得(MyBatisオリジナル)
		SqlSession sqlSession = fwSqlSession.getSqlSession();

		// パラメータ設定
		parameter.setSqlSession(fwSqlSession);
		parameter.setRequestParameter(requestParameter);
		// parameter.setRequest(request);
		// parameter.setModel(model);
		// parameter.setViewName("error");
		parameter.setInputStream(is);
		parameter.setOutputStream(os);
		parameter.setUrl(url);

		// フローの決定
		String reqId = getRequestMapping(url);
		List<Business> flow = (List<Business>) requestMap.getList(reqId);

		// 実行
		int result = -1;
		try {
			for (Business b : flow) {
				// ビジネスロジック起動
				result = b.doExecute(parameter);
			}
		} catch (Exception e) {
			result = -1;
			e.printStackTrace();
		} finally {
			// 後処理
			doFinish(null, sqlSession, result);
		}
		
		sqlSession.close();

		return result;
	}

	private void doFinish(SessionInfo sessionInfo, SqlSession sqlSession,
			int result) {
		if (result == 0) {
			sqlSession.commit();
			if (sessionInfo != null) {
				sessionInfo.commin();
			}
		} else {
			sqlSession.rollback();
		}
	}

	// TODO
	private String getRequestMapping(String url) {
		int pos = url.indexOf(';');
		if (pos >= 0){
			url = url.substring(0, pos);
		}
		
		String id = null;
		if (url.equals("/web/")) {
			id = "id1";
		} else if (url.equals("/web/controller")) {
			id = "id2";
		} else if (url.equals("/web/subwindow")) {
			id = "id3";
		} else if (url.equals("/download/foo")) {
			id = "id7";
		} else if (url.equals("/upload/")) {
			id = "id8";
		} else if (url.equals("/rest/")) {
			id = "id9";
		}
		return id;
	}
}
