package com.xxxxxxx.drvpp.fw.web.controller;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public class Xmpp2 {
	private static class Xmpp2Holder {
		/**
		 * インスタンス
		 */
		private static final Xmpp2 instance = new Xmpp2();
	}

	/**
	 * インスタンス取得.
	 * @return インスタンス
	 */
	public static Xmpp2 getInstance() {
		return Xmpp2Holder.instance;
	}
		
	private Xmpp2(){
		doExecute();		
	}
	
	private XMPPConnection connection = null;
	private boolean isRunning = true;

	private ConcurrentHashMap<String, TaskInfo2> map = new ConcurrentHashMap<String, TaskInfo2>();
	
	public ConcurrentHashMap<String, TaskInfo2> getMap() {
		return map;
	}
	
	/* サーバへの接続とログイン */
	public void connect(String server, String username, String password) {
		try {
			// 接続の設定
			Connection.DEBUG_ENABLED = true;
			SmackConfiguration.setPacketReplyTimeout(5000);
			ConnectionConfiguration config = new ConnectionConfiguration(server);
			config.setSASLAuthenticationEnabled(false);

			// サーバに接続してログインする
			this.connection = new XMPPConnection(config);
			this.connection.connect();
			this.connection.login(username, password);
		} catch (XMPPException ex) {
			ex.printStackTrace();
		}
	}

	/* チャットが継続中か否か */
	public boolean isRunning() {
		return this.isRunning;
	}

	/* チャットの終了 */
	public void chatClose() {
		this.isRunning = false;
	}

	/* 接続の終了 */
	public void destroy() {
		this.connection.disconnect();
	}

	/* 仲間リストを監視 */
	public void startRosterWatching() {
		Roster roster = connection.getRoster();
		// リスナを登録してRosterの変更を監視する
		roster.addRosterListener(new RosterListener() {
			public void presenceChanged(Presence presence) {
				System.out.println(presence.getFrom() + "の状態が更新されました: "
						+ presence);
			}

			public void entriesDeleted(Collection<String> addresses) {
				System.out.println(addresses.toString() + "の状態が更新されました: ");
			}

			public void entriesUpdated(Collection<String> addresses) {
				System.out.println(addresses.toString() + "の状態が更新されました: ");
			}

			public void entriesAdded(Collection<String> addresses) {
				System.out.println(addresses.toString() + "の状態が更新されました: ");
			}
		});
	}
	
	public void doExecute(){
		// 接続してチャットを開始
		// xmpp.connect("192.168.13.105", "user01", "user01");
		//connect("mint16", "user01", "user01");
		//connect("127.0.0.1", "user01", "user01");
		connect("mint16.yuji-k.net", "user01", "user01");
		//connect("mint16.yuji-k.net", "user04@yuji-k.net", "user04");

		// Roster監視のテスト
		// xmpp.startRosterWatching();

		connection.addPacketListener(new PacketListener() {
			public void processPacket(Packet packet) {
				String id = packet.getPacketID();
				System.out.println("Recv id=" + id);
				
				String id2 = "1";
				
				System.out.println("\t\treceive");				
				TaskInfo2 info = getMap().get(id2);
				if (info == null){
					return;
				}
				Xmpp2 t = info.getTask();
				info.setDone(true);
				synchronized (t){
					t.notify();
				}
				System.out.println("\t\tdone");
			}

		}, new PacketFilter() {
			public boolean accept(Packet arg0) {
				return true;
			}
		});

//		// メッセージの送信処理
//		while (isRunning()) {
//			System.out.println("\tsend");
//			String id = "1";
//			TaskInfo2 info = new TaskInfo2(this);
//			getMap().put(id, info);
//			while (!info.isDone()){
//				System.out.println("\tyedld");
//				synchronized (this){
//					try {
//						sendPacket();
//						System.out.println("\twait");
//						this.wait();
//					} catch (InterruptedException e) {
//						System.out.println("\tInterruptedException");
//					}
//				}
//			}
//			System.out.println("\tdone");
//		}
//
//		// 終了
//		destroy();
	}

	public void sendPacket() {
		IQ iq = new IQ() {
			@Override
			public String getChildElementXML() {
				String str = "<ping xmlns=\"urn:xmpp:ping\"/>";
				return str;
			}
		};
		String id = iq.getPacketID();
		System.out.println("Send id=" + id);
		iq.setType(IQ.Type.GET);
		iq.setTo("user01@mint16");
		connection.sendPacket(iq);
	}

	public static void main(String[] args) {
		Xmpp2 xmpp = new Xmpp2();
		//xmpp.doExecute();
	}
}