static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************
 *
 *	akxsCacheXHas.c
 *
 *	    coded   by A.Kobayashi 96.5.24
 *	  updated   by A.Kobayashi 97.1.26
 *	  updated   by A.Kobayashi 2003.10.15
 *
 ************************************************/
/*
	cc -g -DLINUX -I../include -c akxsCacheXHas.c
*/
#define CACHE_XHAS
#include "akxcommon.h"

static struct {
	time_t    my_mtime;	/* t@C̍Ō̕ύX*/
	off_t     st_size;	/* t@C̍vTCY/(oCgP)*/
} tMod;

#define DEBUGP(x)

/*tdtCACHE_CTL_HEAD *akxs_cache_new(int iMax)*/
tdtCACHE_CTL_HEAD *akxs_cache_newXHas(iMax)
int iMax;
{
	tdtCACHE_CTL_HEAD *pCH;

	if (iMax==0) return NULL;
	
	if (pCH = (tdtCACHE_CTL_HEAD *)Malloc(sizeof(tdtCACHE_CTL_HEAD))) {
		memset(pCH,0,sizeof(tdtCACHE_CTL_HEAD));	/* add 2000.12.13 Koba */
		if (iMax<0) {
			iMax = -iMax;
			pCH->ch_opt |= AKX_CACHE_NOAUTOEXT;
		}
		pCH->ch_imax = iMax;
		pCH->ch_kind = 1;
		pCH->ch_keylen = 0;
		pCH->ch_cmplen = sizeof(time_t)+sizeof(off_t);
		pCH->ch_cshlen = 0;
#ifdef CACHE_CHKTIME
		if (pCH->ch_opt & AKX_CACHE_NOAUTOEXT) {
			if (pCH->ch_pchktime=(int *)Malloc(iMax*sizeof(int))) {
				memset(pCH->ch_pchktime,0,iMax*sizeof(int));
			}
			else {
				Free(pCH);
				pCH = NULL;
			}
		}
#endif
	}
	return pCH;
}

/* static void cache_free(unsigned char ucOpt,qCacheCtl *pCt)*/
static void cache_free(ucOpt, pCt)
unsigned char ucOpt;
tdtCACHE_CTL *pCt;
{
/*
	if (pCt->ca_key ) Free(pCt->ca_key );
*/
	if (pCt->ca_cmp1) Free(pCt->ca_cmp1);
	if (pCt->ca_cmp2) Free(pCt->ca_cmp2);
	if (ucOpt & AKX_CACHE_DATASAVE) {
		if (pCt->ca_data) Free(pCt->ca_data);
	}
	memset(pCt,0,sizeof(tdtCACHE_CTL));
}

/*int akxscache_free(tdtCACHE_CTL_HEAD *pCH)*/
int akxscache_freeXHas(pCH)
tdtCACHE_CTL_HEAD *pCH;
{
	tdtCACHE_CTL *pCt;
	int i,iMax;
	XHASHB *xha;

	if (!pCH) return -1;
	if (pCt=pCH->ch_prls) {
		cache_free(pCH->ch_opt,pCt);
		if (pCH->ch_opt & AKX_CACHE_NOAUTOEXT) {
			if (pCt->ca_key) Free(pCt->ca_key);
			Free(pCt);
		}
	}
#ifdef CACHE_CHKTIME
	if (pCH->ch_pchktime) Free(pCH->ch_pchktime);
#endif
	if (xha=pCH->ch_pxhas) {
		iMax = pCH->ch_imax;
		for (i=1;i<=iMax;i++) {
			xha->xha_xhix = i;
			if (akxs_xhash2(xha,'p',NULL,&pCt) > 0) cache_free(pCH->ch_opt,pCt);
		}
		akxs_xhash_free(xha);
	}
	Free(pCH);
	
	return 0;
}
#if 0
/*static int cache_srch(tdtCACHE_CTL_HEAD *pCH,char *cpKey)*/
static int cache_srch(pCH, cpKey)
tdtCACHE_CTL_HEAD *pCH;
char *cpKey;
{
	tdtLIST_CHAIN *pList,*pNext,*pCur,*pTop,*pPrev;
	tdtCACHE_CTL *pCt;
	int i,iKeyLen,found;
	unsigned char ucOpt;

	if (!pCH) return -1;
	pCH->ch_entry = 0;
	pCH->ch_pentry = NULL;
	if (!cpKey) return -3;	/* add 1998.8.13 Koba */
	i = akxs_xhash2(pCH->ch_pxhas,'r',cpKey,&pCt);
	pCH->ch_entry = i;
	pCH->ch_pentry = pCt;
	return i;
}
#endif
/*int akxs_cache_del(tdtCACHE_CTL_HEAD *pCH,char *cpKey)*/
int akxs_cache_delXHas(pCH, cpKey)
tdtCACHE_CTL_HEAD *pCH;
char *cpKey;
{
	tdtCACHE_CTL *pCt,*pCtW;
	int iRc,*ipCCT,no_auto_ext,iKeyLen;

	if ((iRc=akxs_xhash2(pCH->ch_pxhas,'d',cpKey,&pCt)) > 0) {
		pCH->ch_entry = iRc;
		pCH->ch_smax--;
		no_auto_ext = pCH->ch_opt & AKX_CACHE_NOAUTOEXT;
		if (pCtW=pCH->ch_prls) {
			cache_free(pCH->ch_opt,pCtW);
			if (no_auto_ext) {
				if (pCtW->ca_key) Free(pCtW->ca_key);
				Free(pCtW);
			}
		}
		if (no_auto_ext) {
			pCH->ch_prls = pCH->ch_pentry = NULL;
			if (!(pCtW = (tdtCACHE_CTL *)Malloc(sizeof(tdtCACHE_CTL)))) return -16;
			memcpy(pCtW,pCt,sizeof(tdtCACHE_CTL));
			iKeyLen = pCH->ch_keylen;
			if (pCH->ch_opt & AKX_CACHE_FIXEDKEYL) {	/* fixed len */
				if (iKeyLen<=0) return -8;
				if (!(pCtW->ca_key=Malloc(iKeyLen))) return -9;
				memcpy(pCtW->ca_key,pCt->ca_key,iKeyLen);
			}
			else {	/* SZ */
				if (!(pCtW->ca_key=Strdup(pCt->ca_key))) return -10;
			}
			pCt = pCtW;
		}
		pCH->ch_prls = pCt;
		pCH->ch_pentry = pCt;
#ifdef CACHE_CHKTIME
		if (ipCCT = pCH->ch_pchktime) ipCCT[iRc-1] = 0;
#endif
	}
	return iRc;
}

/***************************************************/
/*  ret < 0 : error                                */
/*      = 0 : o^Gg󂫂Ȃ                 */
/*      > 0 : o^Ggԍ                     */
/***************************************************/
/*int akxs_cache_set(tdtCACHE_CTL_HEAD *pCH,tdtCACHE_CTL *pCt0)*/
int akxs_cache_setXHas(pCH, pCt0)
tdtCACHE_CTL_HEAD *pCH;
tdtCACHE_CTL *pCt0;
{
	tdtCACHE_CTL *pCt, *pOldCt, qCt;
	int iRc, i, iKeyLen, iCmpLen, iMax, iCshLen, iOldTime, iOldCt, iMax2, len;
	unsigned char ucOpt;
	struct stat tStat;
	char *p,*cpKey;
	int t,*ipCCT;
	XHASHB *xha;

	if (!pCt0) return -25;	/* add 2001.1.26 Koba */
	ucOpt   = pCH->ch_opt;
	iCshLen = pCH->ch_cshlen;
	if (xha = pCH->ch_pxhas) {
		if ((iRc=akxs_xhash2(xha,'r',pCt0->ca_key,&pCt)) > 0) {
			pCH->ch_entry = iRc;
			pCH->ch_pentry = pCt;
			if (ucOpt & AKX_CACHE_DATASAVE) {	/* malloc cache data area */
				if (!pCt0->ca_data) return -7;
				if (!pCt->ca_data) return -13;
				if (iCshLen <= 0) {
					if (iCshLen) {
						memcpy(&iCshLen,pCt0->ca_data,sizeof(INT4));
						iCshLen += sizeof(INT4);
					}
					else iCshLen = strlen(pCt0->ca_data) + 1;
					if (!(p=Realloc(pCt->ca_data,iCshLen))) {
						return -15;
					}
					pCt->ca_data = p;
				}
				memcpy(pCt->ca_data,pCt0->ca_data,iCshLen);
			}
			else pCt->ca_data = pCt0->ca_data;
#ifdef CACHE_CHKTIME
			if (ucOpt & AKX_CACHE_NOAUTOEXT) {
				pCH->ch_pchktime[iRc-1] =
				pCt->ca_chktime = akxe_getm_sec(NULL,NULL);
/*
printf("akxs_cache_set:ChkTime=%d\n",pCt->ca_chktime);
*/
			}
#endif
			return iRc;
		}
		else if (iRc < 0) return iRc;
		else {
			iMax = pCH->ch_imax;
			if ((pCH->ch_smax>=iMax) &&
			    (pCH->ch_opt & AKX_CACHE_NOAUTOEXT)) {
#ifdef CACHE_CHKTIME
				ipCCT = pCH->ch_pchktime;
				iOldTime = INT_MAX;
				iOldCt = -1;
				for (i=0;i<iMax;i++) {
					if (t=ipCCT[i]) {
/*
printf("akxs_cache_set: i=%d t=%d\n",i,t);
*/
						if (t < iOldTime) {
							iOldTime = t;
							iOldCt = i;
						}
					}
				}
/*
printf("akxs_cache_set: iOldTime=%d iOldCt=%d\n",iOldTime,iOldCt);
*/
#else
				iOldCt = akxe_getm_sec(NULL,NULL) % iMax;
/*
printf("akxs_cache_set: iOldCt=%d\n",iOldCt);
*/
#endif
				xha->xha_xhix = ++iOldCt;
				if ((iRc=akxs_xhash(xha,'p',&cpKey)) > 0) {
					akxs_cache_delXHas(pCH,cpKey);
				}
			}
		}
	}

	pCt = &qCt;
	memset(pCt,0,sizeof(tdtCACHE_CTL));
/*	ucOpt   = pCH->ucCOpt;		*/
	iKeyLen = pCH->ch_keylen;
	iCmpLen = pCH->ch_cmplen;
/*	iCshLen = pCH->iCCshLen;	*/
	if (iCmpLen<=0) return -4;
	if (!pCt0->ca_key) return -5;
	if (!pCt0->ca_cmp1) return -6;
	if (ucOpt & AKX_CACHE_DATASAVE) {	/* malloc cache data area */
		if (!pCt0->ca_data) return -7;
	}
#if 0
	if (ucOpt & AKX_CACHE_FIXEDKEYL) {	/* fixed len */
		if (iKeyLen<=0) return -8;
		if (!(pCt->ca_key=Malloc(iKeyLen))) return -9;
		memcpy(pCt->ca_key,pCt0->ca_key,iKeyLen);
	}
	else {	/* SZ */
		if (!(pCt->ca_key=Malloc(strlen(pCt0->ca_key)+1))) return -10;
		strcpy(pCt->ca_key,pCt0->ca_key);
	}
#endif
	if (!(pCt->ca_cmp2=Malloc(iCmpLen*2))) {
			cache_free(ucOpt,pCt);
			return -11;
	}
	if (ucOpt & AKX_CACHE_MEMCMP) {	/* memory */
		pCt->ca_cmp1 = pCt0->ca_cmp1;
		memcpy(pCt->ca_cmp2,pCt->ca_cmp1,iCmpLen);
	}
	else {	/* file */
		if (!(pCt->ca_cmp1=Malloc(strlen(pCt0->ca_cmp1)+1))) {
			cache_free(ucOpt,pCt);
			return -12;
		}
		strcpy(pCt->ca_cmp1,pCt0->ca_cmp1);	/* file name */
		if (stat(pCt->ca_cmp1,&tStat)) {
			if (ucOpt & AKX_CACHE_IGNCHKERR) {
				tStat.st_mtime = tStat.st_size = 0;
			}
			else {
				cache_free(ucOpt,pCt);
				return -21;
			}
		}
		tMod.my_mtime = tStat.st_mtime;
		tMod.st_size  = tStat.st_size;
		memcpy(pCt->ca_cmp2,(char *)&tMod,iCmpLen);
	}
	memset(pCt->ca_cmp2+iCmpLen,0,iCmpLen);
	if (ucOpt & AKX_CACHE_DATASAVE) {	/* malloc cache data area */
		if (iCshLen <= 0) {
			if (iCshLen) {
				memcpy(&iCshLen,pCt0->ca_data,sizeof(INT4));
				iCshLen += sizeof(INT4);
			}
			else iCshLen = strlen(pCt0->ca_data) + 1;
		}
		if (!(pCt->ca_data=Malloc(iCshLen))) {
			cache_free(ucOpt,pCt);
			return -15;
		}
		memcpy(pCt->ca_data,pCt0->ca_data,iCshLen);
	}
	else pCt->ca_data = pCt0->ca_data;
	if (pCH->ch_interval > 0) {
		pCt->ca_cmpnext = akxe_getm_sec(NULL,NULL) + pCH->ch_interval;
/*
printf("akxs_cache_set:Key=[%s] CmpNext=%d\n",pCt->ca_key,pCt->ca_cmpnext);
*/
	}
#ifdef CACHE_CHKTIME
	if (ucOpt & AKX_CACHE_NOAUTOEXT) {
		pCt->ca_chktime = akxe_getm_sec(NULL,NULL);
/*
printf("akxs_cache_set:ChkTime=%d\n",pCt->ca_chktime);
*/
	}
#endif

	iMax = pCH->ch_imax;
	if (!pCH->ch_pxhas) {
		if (!(pCH->ch_pxhas=akxs_xhash_new2(iKeyLen,iMax,0,sizeof(tdtCACHE_CTL))))
			return -16;
	}
	xha = pCH->ch_pxhas;
	iRc = akxs_xhash2(xha,'s',pCt0->ca_key,pCt);
	pCH->ch_entry = iRc;
	if (iRc > 0) {
		pCH->ch_pentry = pCt;
#ifdef CACHE_CHKTIME
		if (ucOpt & AKX_CACHE_NOAUTOEXT) {
			if (!pCH->ch_pchktime) {
				if (pCH->ch_pchktime=(int *)Malloc(iMax*sizeof(int))) {
					memset(pCH->ch_pchktime,0,iMax*sizeof(int));
				}
				else return -17;
			}
			pCH->ch_pchktime[iRc-1] = akxe_getm_sec(NULL,NULL);
		}
#endif
		pCH->ch_smax++;
		if ((pCH->ch_smax>iMax) && !(pCH->ch_opt & AKX_CACHE_NOAUTOEXT)) {
			pCH->ch_imax += xha->xha_maxreg;
		}
		xha->xha_xhix = iRc;
		akxs_xhash2(xha,'p',&cpKey,&pCt);
		pCH->ch_pentry = pCt;
		pCt->ca_key = cpKey;
		xha->xha_xhix = 0;
	}
	else cache_free(pCH->ch_opt,pCt);
	return iRc;
}

/***************************************************/
/*  ret < 0 : error                                */
/*      = 0 : LbV͗L                     */
/*      > 0 : LbV͖                     */
/***************************************************/
/*int akxs_cache_chk(tdtCACHE_CTL_HEAD *pCH,char *cpKey,tdtCACHE_CTL *pCt0)*/
int akxs_cache_chkXHas(pCH, cpKey, pCt0)
tdtCACHE_CTL_HEAD *pCH;
char *cpKey;
tdtCACHE_CTL *pCt0;
{
	tdtCACHE_CTL **ppCt, *pCt;
	int iRc, iKeyLen, iCmpLen;
	unsigned char ucOpt;
	struct stat tStat;
	int t,ichk;

	if (!pCt0) return -25;	/* add 2001.1.26 Koba */
	if ((iRc=akxs_xhash2(pCH->ch_pxhas,'r',cpKey,&pCt)) > 0) {
		pCH->ch_entry = iRc;
		pCH->ch_pentry = pCt;
		ucOpt   = pCH->ch_opt;
		iCmpLen = pCH->ch_cmplen;
#ifdef CACHE_CHKTIME
		if (pCH->ch_opt & AKX_CACHE_NOAUTOEXT) {
			pCH->ch_pchktime[iRc-1] =
			pCt->ca_chktime = akxe_getm_sec(NULL,NULL);
/*
printf("akxsCacheCheck:Key=[%s] ChkTime=%d\n",pCt->ca_key,pCt->ca_chktime);
*/
		}
#endif
		iRc = 0;
		if (ucOpt & AKX_CACHE_MEMCMP) {	/* memory */
			if (memcmp(pCt->ca_cmp2,pCt->ca_cmp1,iCmpLen)) {
				iRc = 1;
				memcpy(pCt->ca_cmp2+iCmpLen,pCt->ca_cmp2,iCmpLen);
				memcpy(pCt->ca_cmp2,pCt->ca_cmp1,iCmpLen);
			}
		}
		else {	/* file */
			ichk = 1;
			if (pCH->ch_interval > 0) {
				t = akxe_getm_sec(NULL,NULL);
				if (t >= pCt->ca_cmpnext) {
/*
printf("akxsCacheCheck:Key=[%s] t=%d\n",pCt->ca_key,t);
*/
					pCt->ca_cmpnext = t + pCH->ch_interval;
				}
				else ichk = 0;
			}
			if (ichk) {
				if (stat(pCt->ca_cmp1,&tStat)) {
					if (ucOpt & AKX_CACHE_IGNCHKERR) {
						tStat.st_mtime = tStat.st_size = 0;
					}
					else return -21;
				}
				tMod.my_mtime = tStat.st_mtime;
				tMod.st_size  = tStat.st_size;
				if (memcmp(pCt->ca_cmp2,(char *)&tMod,iCmpLen)) {
					iRc = 1;
					memcpy(pCt->ca_cmp2+iCmpLen,pCt->ca_cmp2,iCmpLen);
					memcpy(pCt->ca_cmp2,(char *)&tMod,iCmpLen);
				}
			}
		}
		memcpy(pCt0,pCt,sizeof(tdtCACHE_CTL));
	}
	else if (!iRc) iRc = -22;
	return iRc;
}

/***************************************************/
/*  ret = 0 :                                  */
/*      < 0 : G[                               */
/***************************************************/
/*int akxs_cache_get(tdtCACHE_CTL_HEAD *pCH,int iEntry,tdtCACHE_CTL *pCt0)*/
int akxs_cache_getXHas(pCH, iEntry, pCt0)
tdtCACHE_CTL_HEAD *pCH;
int iEntry;
tdtCACHE_CTL *pCt0;
{
	tdtCACHE_CTL *pCt;
	int i;
	char *cpKey;
	XHASHB *xha;

	if (!pCH) return -1;
	if (!pCt0) return -25;
	if (iEntry<=0 || iEntry>pCH->ch_imax) return -26;
	pCt = NULL;
	if (iEntry && (xha = pCH->ch_pxhas)) {
		xha->xha_xhix = iEntry;
	/*	i = akxs_xhash2(xha,'p',&cpKey,&pCt);	*/
		i = akxs_xhash2(xha,'p',NULL,&pCt);
		xha->xha_xhix = 0;
	}
	if (pCt) {
		memcpy(pCt0,pCt,sizeof(tdtCACHE_CTL));
	/*	pCt0->cpCKey = cpKey;	*/
	/*	if (!iEntry) Free(pCt);	*/
	}
	else {
		memset(pCt0,0,sizeof(tdtCACHE_CTL));
		return -22;
	}
	return 0;
}

int akxs_cache_ct_clear_xhas(pCH, pCt)
tdtCACHE_CTL_HEAD *pCH;
tdtCACHE_CTL *pCt;
{
	if (!pCH || !pCt) return -1;
	cache_free(pCH->ch_opt, pCt);
	return 0;
}
