/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;

public final class FileUtils {
    private FileUtils() {
    }

    public static InputStream getStreamForUrl(String url, ClassLoader loader) throws MalformedURLException, IOException {
        URI fileUri = URI.create(url);
        if (fileUri.getScheme() == null) {
            throw new MalformedURLException("No protocol found in file URL: " + url);
        }
        if (fileUri.getScheme().equals("classpath")) {
            ClassLoader[] classLoaders;
            for (ClassLoader classLoader : classLoaders = FileUtils.getClassLoaders()) {
                InputStream is = classLoader.getResourceAsStream(fileUri.getSchemeSpecificPart());
                if (is == null) continue;
                return is;
            }
        } else {
            return fileUri.toURL().openStream();
        }
        return null;
    }

    public static ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaders = new ClassLoader[]{FileUtils.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : classLoaders) {
            if (classLoader == null) continue;
            loaders.add(classLoader);
        }
        return loaders.toArray(new ClassLoader[loaders.size()]);
    }
}

